/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.ints.utils;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import speiger.src.collections.ints.collections.IntCollection;
import speiger.src.collections.ints.collections.IntIterator;
import speiger.src.collections.ints.collections.IntSplititerator;
import speiger.src.collections.utils.SanityChecks;

public class IntSplititerators {
    public static Spliterator.OfInt createArrayJavaSplititerator(int[] array, int characteristics) {
        return IntSplititerators.createArrayJavaSplititerator(array, 0, array.length, characteristics);
    }

    public static Spliterator.OfInt createArrayJavaSplititerator(int[] array, int size, int characteristics) {
        return IntSplititerators.createArrayJavaSplititerator(array, 0, size, characteristics);
    }

    public static Spliterator.OfInt createArrayJavaSplititerator(int[] array, int offset, int size, int characteristics) {
        SanityChecks.checkArrayCapacity(array.length, offset, size);
        return new ArraySplitIterator(array, offset, size, characteristics);
    }

    public static Spliterator.OfInt createJavaSplititerator(IntCollection collection, int characteristics) {
        return new IteratorSpliterator(collection, characteristics);
    }

    public static Spliterator.OfInt createUnknownJavaSplititerator(IntIterator iterator, int characteristics) {
        return new IteratorSpliterator(iterator, characteristics);
    }

    public static Spliterator.OfInt createSizedJavaSplititerator(IntIterator iterator, long size, int characteristics) {
        return new IteratorSpliterator(iterator, size, characteristics);
    }

    public static IntSplititerator createArraySplititerator(int[] array, int characteristics) {
        return IntSplititerators.createArraySplititerator(array, 0, array.length, characteristics);
    }

    public static IntSplititerator createArraySplititerator(int[] array, int size, int characteristics) {
        return IntSplititerators.createArraySplititerator(array, 0, size, characteristics);
    }

    public static IntSplititerator createArraySplititerator(int[] array, int offset, int size, int characteristics) {
        SanityChecks.checkArrayCapacity(array.length, offset, size);
        return new TypeArraySplitIterator(array, offset, size, characteristics);
    }

    public static IntSplititerator createSplititerator(IntCollection collection, int characteristics) {
        return new TypeIteratorSpliterator(collection, characteristics);
    }

    public static IntSplititerator createUnknownSplititerator(IntIterator iterator, int characteristics) {
        return new TypeIteratorSpliterator(iterator, characteristics);
    }

    public static IntSplititerator createSizedSplititerator(IntIterator iterator, long size, int characteristics) {
        return new TypeIteratorSpliterator(iterator, size, characteristics);
    }

    static final class ArraySplitIterator
    implements Spliterator.OfInt {
        private final int[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public ArraySplitIterator(int[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            ArraySplitIterator arraySplitIterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                arraySplitIterator = null;
            } else {
                this.index = mid;
                ArraySplitIterator arraySplitIterator2 = new ArraySplitIterator(this.array, lo, this.index, this.characteristics);
                arraySplitIterator = arraySplitIterator2;
            }
            return arraySplitIterator;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i]);
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static class IteratorSpliterator
    implements Spliterator.OfInt {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final IntCollection collection;
        private IntIterator it;
        private final int characteristics;
        private long est;
        private int batch;

        IteratorSpliterator(IntCollection collection, int characteristics) {
            this.collection = collection;
            this.it = null;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        IteratorSpliterator(IntIterator iterator, long size, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        IteratorSpliterator(IntIterator iterator, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        private IntIterator iterator() {
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.est = this.collection.size();
            }
            return this.it;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            IntIterator i = this.iterator();
            if (this.est > 1L && i.hasNext()) {
                int n = Math.min(this.batch + 1024, Math.min((int)this.est, 0x2000000));
                int[] a = new int[n];
                int j = 0;
                do {
                    a[j] = i.nextInt();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new ArraySplitIterator(a, 0, j, this.characteristics);
            }
            return null;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            this.iterator().forEachRemaining((int T) -> action.accept(T));
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            IntIterator iter = this.iterator();
            if (iter.hasNext()) {
                action.accept(iter.nextInt());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            this.iterator();
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class TypeArraySplitIterator
    implements IntSplititerator {
        private final int[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public TypeArraySplitIterator(int[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public IntSplititerator trySplit() {
            TypeArraySplitIterator typeArraySplitIterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                typeArraySplitIterator = null;
            } else {
                this.index = mid;
                TypeArraySplitIterator typeArraySplitIterator2 = new TypeArraySplitIterator(this.array, lo, this.index, this.characteristics);
                typeArraySplitIterator = typeArraySplitIterator2;
            }
            return typeArraySplitIterator;
        }

        @Override
        public void forEachRemaining(speiger.src.collections.ints.functions.IntConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i]);
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(speiger.src.collections.ints.functions.IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept((Integer)this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.index++];
        }

        @Override
        public boolean hasNext() {
            return this.index < this.fence;
        }
    }

    static class TypeIteratorSpliterator
    implements IntSplititerator {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final IntCollection collection;
        private IntIterator it;
        private final int characteristics;
        private long est;
        private int batch;

        TypeIteratorSpliterator(IntCollection collection, int characteristics) {
            this.collection = collection;
            this.it = null;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        TypeIteratorSpliterator(IntIterator iterator, long size, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        TypeIteratorSpliterator(IntIterator iterator, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        private IntIterator iterator() {
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.est = this.collection.size();
            }
            return this.it;
        }

        @Override
        public IntSplititerator trySplit() {
            IntIterator i = this.iterator();
            if (this.est > 1L && i.hasNext()) {
                int n = Math.min(this.batch + 1024, Math.min((int)this.est, 0x2000000));
                int[] a = new int[n];
                int j = 0;
                do {
                    a[j] = i.nextInt();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new TypeArraySplitIterator(a, 0, j, this.characteristics);
            }
            return null;
        }

        @Override
        public void forEachRemaining(speiger.src.collections.ints.functions.IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            this.iterator().forEachRemaining(action);
        }

        @Override
        public boolean tryAdvance(speiger.src.collections.ints.functions.IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            IntIterator iter = this.iterator();
            if (iter.hasNext()) {
                action.accept(iter.nextInt());
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            IntIterator iter = this.iterator();
            if (iter.hasNext()) {
                action.accept((Integer)iter.nextInt());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            this.iterator();
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }

        @Override
        public int nextInt() {
            return this.iterator().nextInt();
        }

        @Override
        public boolean hasNext() {
            return this.iterator().hasNext();
        }
    }
}

