/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.ints.utils;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import speiger.src.collections.ints.collections.IntIterable;
import speiger.src.collections.ints.collections.IntIterator;
import speiger.src.collections.ints.functions.IntComparator;
import speiger.src.collections.ints.functions.IntConsumer;
import speiger.src.collections.ints.functions.function.IntFunction;
import speiger.src.collections.ints.utils.IntCollections;
import speiger.src.collections.ints.utils.IntIterators;
import speiger.src.collections.objects.collections.ObjectIterable;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.utils.ISizeProvider;

public class IntIterables {
    public static <E> ObjectIterable<E> map(Iterable<? extends Integer> iterable, IntFunction<E> mapper) {
        return new MappedIterable<E>(IntIterables.wrap(iterable), mapper);
    }

    public static <E> ObjectIterable<E> map(IntIterable iterable, IntFunction<E> mapper) {
        return new MappedIterable<E>(iterable, mapper);
    }

    public static <E, V extends Iterable<E>> ObjectIterable<E> flatMap(Iterable<? extends Integer> iterable, IntFunction<V> mapper) {
        return new FlatMappedIterable(IntIterables.wrap(iterable), mapper);
    }

    public static <E, V extends Iterable<E>> ObjectIterable<E> flatMap(IntIterable iterable, IntFunction<V> mapper) {
        return new FlatMappedIterable(iterable, mapper);
    }

    public static <E> ObjectIterable<E> arrayFlatMap(Iterable<? extends Integer> iterable, IntFunction<E[]> mapper) {
        return new FlatMappedArrayIterable(IntIterables.wrap(iterable), mapper);
    }

    public static <E> ObjectIterable<E> arrayFlatMap(IntIterable iterable, IntFunction<E[]> mapper) {
        return new FlatMappedArrayIterable(iterable, mapper);
    }

    public static IntIterable filter(Iterable<? extends Integer> iterable, IntPredicate filter) {
        return new FilteredIterable(IntIterables.wrap(iterable), filter);
    }

    public static IntIterable filter(IntIterable iterable, IntPredicate filter) {
        return new FilteredIterable(iterable, filter);
    }

    public static IntIterable distinct(IntIterable iterable) {
        return new DistinctIterable(iterable);
    }

    public static IntIterable distinct(Iterable<? extends Integer> iterable) {
        return new DistinctIterable(IntIterables.wrap(iterable));
    }

    public static IntIterable repeat(IntIterable iterable, int repeats) {
        return new RepeatingIterable(iterable, repeats);
    }

    public static IntIterable repeat(Iterable<? extends Integer> iterable, int repeats) {
        return new RepeatingIterable(IntIterables.wrap(iterable), repeats);
    }

    public static IntIterable limit(IntIterable iterable, long limit) {
        return new LimitedIterable(iterable, limit);
    }

    public static IntIterable limit(Iterable<? extends Integer> iterable, long limit) {
        return new LimitedIterable(IntIterables.wrap(iterable), limit);
    }

    public static IntIterable sorted(IntIterable iterable, IntComparator sorter) {
        return new SortedIterable(iterable, sorter);
    }

    public static IntIterable sorted(Iterable<? extends Integer> iterable, IntComparator sorter) {
        return new SortedIterable(IntIterables.wrap(iterable), sorter);
    }

    public static IntIterable peek(IntIterable iterable, IntConsumer action) {
        return new PeekIterable(iterable, action);
    }

    public static IntIterable peek(Iterable<? extends Integer> iterable, IntConsumer action) {
        return new PeekIterable(IntIterables.wrap(iterable), action);
    }

    public static IntIterable wrap(Iterable<? extends Integer> iterable) {
        return new WrappedIterable(iterable);
    }

    private static class PeekIterable
    implements IntIterable,
    ISizeProvider {
        IntIterable iterable;
        IntConsumer action;

        public PeekIterable(IntIterable iterable, IntConsumer action) {
            this.iterable = iterable;
            this.action = action;
        }

        @Override
        public IntIterator iterator() {
            return IntIterators.peek(this.iterable.iterator(), this.action);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(IntConsumer action) {
            Objects.requireNonNull(action);
            this.iterable.forEach(this.action.andThen(action));
        }
    }

    private static class DistinctIterable
    implements IntIterable {
        IntIterable iterable;

        public DistinctIterable(IntIterable iterable) {
            this.iterable = iterable;
        }

        @Override
        public IntIterator iterator() {
            return IntIterators.distinct(this.iterable.iterator());
        }

        @Override
        public void forEach(IntConsumer action) {
            Objects.requireNonNull(action);
            IntCollections.DistinctCollectionWrapper filtered = IntCollections.distinctWrapper();
            this.iterable.forEach((int T) -> {
                if (filtered.add(T)) {
                    action.accept(T);
                }
            });
        }
    }

    private static class SortedIterable
    implements IntIterable,
    ISizeProvider {
        IntIterable iterable;
        IntComparator sorter;

        public SortedIterable(IntIterable iterable, IntComparator sorter) {
            this.iterable = iterable;
            this.sorter = sorter;
        }

        @Override
        public IntIterator iterator() {
            return IntIterators.sorted(this.iterable.iterator(), this.sorter);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(IntConsumer action) {
            Objects.requireNonNull(action);
            IntCollections.CollectionWrapper wrapper = IntCollections.wrapper();
            this.iterable.forEach(wrapper::add);
            wrapper.unstableSort(this.sorter);
            wrapper.forEach(action);
        }
    }

    private static class LimitedIterable
    implements IntIterable,
    ISizeProvider {
        IntIterable iterable;
        long limit;

        public LimitedIterable(IntIterable iterable, long limit) {
            this.iterable = iterable;
            this.limit = limit;
        }

        @Override
        public IntIterator iterator() {
            return IntIterators.limit(this.iterable.iterator(), this.limit);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : (int)Math.min((long)prov.size(), this.limit);
        }

        @Override
        public void forEach(IntConsumer action) {
            Objects.requireNonNull(action);
            AtomicLong counter = new AtomicLong();
            this.iterable.forEach((int T) -> {
                if (counter.get() >= this.limit) {
                    return;
                }
                counter.incrementAndGet();
                action.accept(T);
            });
        }
    }

    private static class FilteredIterable
    implements IntIterable {
        IntIterable iterable;
        IntPredicate filter;

        public FilteredIterable(IntIterable iterable, IntPredicate filter) {
            this.iterable = iterable;
            this.filter = filter;
        }

        @Override
        public IntIterator iterator() {
            return IntIterators.filter(this.iterable.iterator(), this.filter);
        }

        @Override
        public void forEach(IntConsumer action) {
            Objects.requireNonNull(action);
            this.iterable.forEach((int T) -> {
                if (!this.filter.test(T)) {
                    action.accept(T);
                }
            });
        }
    }

    private static class RepeatingIterable
    implements IntIterable,
    ISizeProvider {
        IntIterable iterable;
        int repeats;

        public RepeatingIterable(IntIterable iterable, int repeats) {
            this.iterable = iterable;
            this.repeats = repeats;
        }

        @Override
        public IntIterator iterator() {
            return IntIterators.repeat(this.iterable.iterator(), this.repeats);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size() * (this.repeats + 1);
        }

        @Override
        public void forEach(IntConsumer action) {
            Objects.requireNonNull(action);
            IntCollections.CollectionWrapper repeater = IntCollections.wrapper();
            this.iterable.forEach(action.andThen(repeater::add));
            for (int i = 0; i < this.repeats; ++i) {
                repeater.forEach(action);
            }
        }
    }

    private static class FlatMappedArrayIterable<T>
    implements ObjectIterable<T> {
        IntIterable iterable;
        IntFunction<T[]> mapper;

        FlatMappedArrayIterable(IntIterable iterable, IntFunction<T[]> mapper) {
            this.iterable = iterable;
            this.mapper = mapper;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return IntIterators.arrayFlatMap(this.iterable.iterator(), this.mapper);
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.iterable.forEach((int E) -> {
                T[] array = this.mapper.apply(E);
                int i = 0;
                int m = array.length;
                while (i < m) {
                    action.accept((T)array[i++]);
                }
            });
        }
    }

    private static class FlatMappedIterable<T, V extends Iterable<T>>
    implements ObjectIterable<T> {
        IntIterable iterable;
        IntFunction<V> mapper;

        FlatMappedIterable(IntIterable iterable, IntFunction<V> mapper) {
            this.iterable = iterable;
            this.mapper = mapper;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return IntIterators.flatMap(this.iterable.iterator(), this.mapper);
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.iterable.forEach((int E) -> ((Iterable)this.mapper.apply(E)).forEach(action));
        }
    }

    private static class MappedIterable<T>
    implements ObjectIterable<T>,
    ISizeProvider {
        IntIterable iterable;
        IntFunction<T> mapper;

        MappedIterable(IntIterable iterable, IntFunction<T> mapper) {
            this.iterable = iterable;
            this.mapper = mapper;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return IntIterators.map(this.iterable.iterator(), this.mapper);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.iterable.forEach((int E) -> action.accept((T)this.mapper.apply(E)));
        }
    }

    private static class WrappedIterable
    implements IntIterable,
    ISizeProvider {
        Iterable<? extends Integer> iterable;

        public WrappedIterable(Iterable<? extends Integer> iterable) {
            this.iterable = iterable;
        }

        @Override
        public IntIterator iterator() {
            return IntIterators.wrap(this.iterable.iterator());
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(IntConsumer action) {
            Objects.requireNonNull(action);
            this.iterable.forEach(action);
        }
    }
}

