/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.ints.maps.abstracts;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import speiger.src.collections.ints.collections.IntIterator;
import speiger.src.collections.ints.functions.consumer.IntObjectConsumer;
import speiger.src.collections.ints.functions.function.IntFunction;
import speiger.src.collections.ints.functions.function.IntObjectUnaryOperator;
import speiger.src.collections.ints.maps.interfaces.Int2ObjectMap;
import speiger.src.collections.ints.sets.AbstractIntSet;
import speiger.src.collections.ints.sets.IntSet;
import speiger.src.collections.objects.collections.AbstractObjectCollection;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterable;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.ObjectSupplier;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.sets.ObjectSet;
import speiger.src.collections.utils.SanityChecks;

public abstract class AbstractInt2ObjectMap<V>
extends AbstractMap<Integer, V>
implements Int2ObjectMap<V> {
    protected V defaultReturnValue = null;

    @Override
    public V getDefaultReturnValue() {
        return this.defaultReturnValue;
    }

    @Override
    public AbstractInt2ObjectMap<V> setDefaultReturnValue(V v) {
        this.defaultReturnValue = v;
        return this;
    }

    protected ObjectIterable<Int2ObjectMap.Entry<V>> getFastIterable(Int2ObjectMap<V> map) {
        return map.int2ObjectEntrySet();
    }

    protected ObjectIterator<Int2ObjectMap.Entry<V>> getFastIterator(Int2ObjectMap<V> map) {
        return map.int2ObjectEntrySet().iterator();
    }

    @Override
    public Int2ObjectMap<V> copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public V put(Integer key, V value) {
        return ((AbstractMap)this).put(key.intValue(), value);
    }

    @Override
    public void putAll(Int2ObjectMap<V> m) {
        ObjectIterator<Int2ObjectMap.Entry<V>> iter = this.getFastIterator(m);
        while (iter.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iter.next();
            ((AbstractMap)this).put(entry.getIntKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> m) {
        if (m instanceof Int2ObjectMap) {
            this.putAll((Int2ObjectMap)m);
        } else {
            super.putAll(m);
        }
    }

    @Override
    public void putAll(int[] keys, V[] values, int offset, int size) {
        SanityChecks.checkArrayCapacity(keys.length, offset, size);
        SanityChecks.checkArrayCapacity(values.length, offset, size);
        for (int i = 0; i < size; ++i) {
            ((AbstractMap)this).put(keys[i], values[i]);
        }
    }

    @Override
    public void putAll(Integer[] keys, V[] values, int offset, int size) {
        SanityChecks.checkArrayCapacity(keys.length, offset, size);
        SanityChecks.checkArrayCapacity(values.length, offset, size);
        for (int i = 0; i < size; ++i) {
            this.put(keys[i], values[i]);
        }
    }

    @Override
    public void putAllIfAbsent(Int2ObjectMap<V> m) {
        for (Int2ObjectMap.Entry entry : this.getFastIterable(m)) {
            this.putIfAbsent(entry.getIntKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(int key) {
        IntIterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            if (iter.nextInt() != key) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator iter = this.values().iterator();
        while (iter.hasNext()) {
            if (!Objects.equals(value, iter.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(int key, V oldValue, V newValue) {
        Object curValue = this.get(key);
        if (!Objects.equals(curValue, oldValue) || Objects.equals(curValue, this.getDefaultReturnValue()) && !this.containsKey(key)) {
            return false;
        }
        ((AbstractMap)this).put(key, newValue);
        return true;
    }

    @Override
    public V replace(int key, V value) {
        Object curValue = this.get(key);
        if (!Objects.equals(curValue, this.getDefaultReturnValue()) || this.containsKey(key)) {
            curValue = ((AbstractMap)this).put(key, value);
        }
        return curValue;
    }

    @Override
    public void replaceObjects(Int2ObjectMap<V> m) {
        for (Int2ObjectMap.Entry entry : this.getFastIterable(m)) {
            this.replace(entry.getIntKey(), (V)entry.getValue());
        }
    }

    @Override
    public void replaceObjects(IntObjectUnaryOperator<V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        ObjectIterator<Int2ObjectMap.Entry<V>> iter = this.getFastIterator(this);
        while (iter.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iter.next();
            entry.setValue(mappingFunction.apply(entry.getIntKey(), entry.getValue()));
        }
    }

    @Override
    public V compute(int key, IntObjectUnaryOperator<V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Object value = this.get(key);
        V newValue = mappingFunction.apply(key, value);
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            if (!Objects.equals(value, this.getDefaultReturnValue()) || this.containsKey(key)) {
                this.remove(key);
                return this.getDefaultReturnValue();
            }
            return this.getDefaultReturnValue();
        }
        ((AbstractMap)this).put(key, newValue);
        return newValue;
    }

    @Override
    public V computeIfAbsent(int key, IntFunction<V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        Object value = this.get(key);
        if (!(value != this.getDefaultReturnValue() && this.containsKey(key) || Objects.equals(newValue = mappingFunction.apply(key), this.getDefaultReturnValue()))) {
            ((AbstractMap)this).put(key, newValue);
            return newValue;
        }
        return value;
    }

    @Override
    public V supplyIfAbsent(int key, ObjectSupplier<V> valueProvider) {
        V newValue;
        Objects.requireNonNull(valueProvider);
        Object value = this.get(key);
        if (!(value != this.getDefaultReturnValue() && this.containsKey(key) || Objects.equals(newValue = valueProvider.get(), this.getDefaultReturnValue()))) {
            ((AbstractMap)this).put(key, newValue);
            return newValue;
        }
        return value;
    }

    @Override
    public V computeIfPresent(int key, IntObjectUnaryOperator<V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Object value = this.get(key);
        if (!Objects.equals(value, this.getDefaultReturnValue()) || this.containsKey(key)) {
            V newValue = mappingFunction.apply(key, value);
            if (!Objects.equals(newValue, this.getDefaultReturnValue())) {
                ((AbstractMap)this).put(key, newValue);
                return newValue;
            }
            this.remove(key);
        }
        return this.getDefaultReturnValue();
    }

    @Override
    public V merge(int key, V value, ObjectObjectUnaryOperator<V, V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        Object oldValue = this.get(key);
        Object object = newValue = Objects.equals(oldValue, this.getDefaultReturnValue()) ? value : mappingFunction.apply(oldValue, value);
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            this.remove(key);
        } else {
            ((AbstractMap)this).put(key, newValue);
        }
        return newValue;
    }

    @Override
    public void mergeAll(Int2ObjectMap<V> m, ObjectObjectUnaryOperator<V, V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        for (Int2ObjectMap.Entry entry : this.getFastIterable(m)) {
            Object newValue;
            int key = entry.getIntKey();
            Object oldValue = this.get(key);
            Object object = newValue = Objects.equals(oldValue, this.getDefaultReturnValue()) ? entry.getValue() : mappingFunction.apply(oldValue, entry.getValue());
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                this.remove(key);
                continue;
            }
            ((AbstractMap)this).put(key, newValue);
        }
    }

    @Override
    public V get(Object key) {
        return key instanceof Integer ? this.get((Integer)key) : this.getDefaultReturnValue();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return key instanceof Integer ? this.getOrDefault((Integer)key, defaultValue) : this.getDefaultReturnValue();
    }

    @Override
    public V getOrDefault(int key, V defaultValue) {
        Object value = this.get(key);
        return !Objects.equals(value, this.getDefaultReturnValue()) || this.containsKey(key) ? value : defaultValue;
    }

    @Override
    public V remove(Object key) {
        return key instanceof Integer ? this.remove((Integer)key) : this.getDefaultReturnValue();
    }

    @Override
    public void forEach(IntObjectConsumer<V> action) {
        Objects.requireNonNull(action);
        ObjectIterator<Int2ObjectMap.Entry<V>> iter = this.getFastIterator(this);
        while (iter.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iter.next();
            action.accept(entry.getIntKey(), entry.getValue());
        }
    }

    @Override
    public IntSet keySet() {
        return new AbstractIntSet(){

            @Override
            public boolean remove(int o) {
                return !Objects.equals(AbstractInt2ObjectMap.this.remove(o), AbstractInt2ObjectMap.this.getDefaultReturnValue());
            }

            @Override
            public boolean add(int o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public IntIterator iterator() {
                return new IntIterator(){
                    ObjectIterator<Int2ObjectMap.Entry<V>> iter;
                    {
                        this.iter = AbstractInt2ObjectMap.this.getFastIterator(AbstractInt2ObjectMap.this);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public int nextInt() {
                        return ((Int2ObjectMap.Entry)this.iter.next()).getIntKey();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractInt2ObjectMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2ObjectMap.this.clear();
            }
        };
    }

    @Override
    public ObjectCollection<V> values() {
        return new AbstractObjectCollection<V>(){

            @Override
            public boolean add(V o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return AbstractInt2ObjectMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2ObjectMap.this.clear();
            }

            @Override
            public ObjectIterator<V> iterator() {
                return new ObjectIterator<V>(){
                    ObjectIterator<Int2ObjectMap.Entry<V>> iter;
                    {
                        this.iter = AbstractInt2ObjectMap.this.getFastIterator(AbstractInt2ObjectMap.this);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return ((Int2ObjectMap.Entry)this.iter.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }
        };
    }

    @Override
    public ObjectSet<Map.Entry<Integer, V>> entrySet() {
        return this.int2ObjectEntrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Map) {
            if (this.size() != ((Map)o).size()) {
                return false;
            }
            if (o instanceof Int2ObjectMap) {
                return this.int2ObjectEntrySet().containsAll(((Int2ObjectMap)o).int2ObjectEntrySet());
            }
            return this.int2ObjectEntrySet().containsAll(((Map)o).entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        ObjectIterator<Int2ObjectMap.Entry<V>> iter = this.getFastIterator(this);
        while (iter.hasNext()) {
            hash += ((Int2ObjectMap.Entry)iter.next()).hashCode();
        }
        return hash;
    }

    public static class BasicEntry<V>
    implements Int2ObjectMap.Entry<V> {
        protected int key;
        protected V value;

        public BasicEntry() {
        }

        public BasicEntry(Integer key, V value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(int key, V value) {
            this.key = key;
            this.value = value;
        }

        public void set(int key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int getIntKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Map.Entry) {
                if (obj instanceof Int2ObjectMap.Entry) {
                    Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)obj;
                    return this.key == entry.getIntKey() && Objects.equals(this.value, entry.getValue());
                }
                Map.Entry entry = (Map.Entry)obj;
                Object key = entry.getKey();
                Object value = entry.getValue();
                return key instanceof Integer && this.key == (Integer)key && Objects.equals(this.value, value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        public String toString() {
            return Integer.toString(this.key) + "=" + Objects.toString(this.value);
        }
    }
}

