/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.ints.functions;

import java.util.Comparator;
import java.util.Objects;

public interface IntComparator
extends Comparator<Integer> {
    @Override
    public int compare(int var1, int var2);

    @Override
    @Deprecated
    default public int compare(Integer o1, Integer o2) {
        return this.compare((int)o1, (int)o2);
    }

    public static IntComparator of(Comparator<Integer> c) {
        Objects.requireNonNull(c);
        return (K, V) -> c.compare(K, V);
    }

    default public IntComparator reversed() {
        return new Reversed(this);
    }

    public static class Reversed
    implements IntComparator {
        IntComparator original;

        public Reversed(IntComparator original) {
            this.original = original;
        }

        @Override
        public int compare(int o1, int o2) {
            return this.original.compare(o2, o1);
        }

        @Override
        public IntComparator reversed() {
            return this.original;
        }
    }
}

