/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.mixins.common.core;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.embeddedt.archaicfix.config.ArchaicConfig;
import org.embeddedt.archaicfix.recipe.IFasterCraftingManager;
import org.embeddedt.archaicfix.recipe.LastMatchedInfo;
import org.embeddedt.archaicfix.recipe.RecipeCacheLoader;
import org.embeddedt.archaicfix.recipe.RecipeWeigher;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftingManager.class})
public class MixinCraftingManager
implements IFasterCraftingManager {
    private final LoadingCache<Set<Item>, IRecipe[]> potentialRecipes = CacheBuilder.newBuilder().maximumWeight(500000L).weigher((Weigher)new RecipeWeigher()).build((CacheLoader)new RecipeCacheLoader());
    private volatile LastMatchedInfo lastMatchedInfo = null;

    @Inject(method={"findMatchingRecipe"}, at={@At(value="INVOKE", target="Ljava/util/List;size()I")}, cancellable=true)
    private void fasterRecipeSearch(InventoryCrafting inventory, World world, CallbackInfoReturnable<ItemStack> cir) {
        if (!ArchaicConfig.cacheRecipes) {
            return;
        }
        LastMatchedInfo retInfo = this.lastMatchedInfo;
        if (retInfo == null || !retInfo.matches(inventory)) {
            IRecipe[] recipes;
            ImmutableSet stacks = new HashSet();
            for (int x = 0; x < inventory.func_70302_i_(); ++x) {
                ItemStack stack = inventory.func_70301_a(x);
                if (stack == null) continue;
                stacks.add(stack.func_77973_b());
            }
            stacks = ImmutableSet.copyOf(stacks);
            IRecipe result = null;
            try {
                recipes = (IRecipe[])this.potentialRecipes.get((Object)stacks);
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                ArchaicLogger.LOGGER.error("An error occured while attempting to cache recipes!", e);
                return;
            }
            for (IRecipe r : recipes) {
                if (!r.func_77569_a(inventory, world)) continue;
                result = r;
                break;
            }
            this.lastMatchedInfo = retInfo = new LastMatchedInfo(result, inventory);
        }
        cir.setReturnValue((Object)retInfo.getCraftingResult(inventory));
    }

    @Override
    public void clearRecipeCache() {
        this.potentialRecipes.invalidateAll();
        this.lastMatchedInfo = null;
    }
}

