/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.highlighter;

import appeng.api.util.DimensionalCoord;
import appeng.api.util.WorldCoord;
import appeng.client.render.highlighter.IHighlighter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class BlockPosHighlighter
implements IHighlighter {
    static final BlockPosHighlighter INSTANCE = new BlockPosHighlighter();
    protected final List<DimensionalCoord> highlightedBlocks = new ArrayList<DimensionalCoord>();
    protected long expireHighlightTime;
    protected final int MIN_TIME = 3000;
    protected final int MAX_TIME = 30000;
    protected int dimension;
    protected double doubleX;
    protected double doubleY;
    protected double doubleZ;

    BlockPosHighlighter() {
    }

    public static void highlightBlocks(EntityPlayer player, List<DimensionalCoord> interfaces, String deviceName, String foundMsg, String wrongDimMsg) {
        INSTANCE.clear();
        int highlightDuration = BlockPosHighlighter.INSTANCE.MIN_TIME;
        for (DimensionalCoord coord : interfaces) {
            BlockPosHighlighter.INSTANCE.highlightedBlocks.add(coord);
            highlightDuration = Math.max(highlightDuration, MathHelper.func_76125_a((int)(500 * WorldCoord.getTaxicabDistance((WorldCoord)coord, player)), (int)BlockPosHighlighter.INSTANCE.MIN_TIME, (int)BlockPosHighlighter.INSTANCE.MAX_TIME));
            if (player.field_70170_p.field_73011_w.field_76574_g == coord.getDimension()) {
                if (foundMsg == null) continue;
                if (deviceName.isEmpty()) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation(foundMsg, new Object[]{coord.x, coord.y, coord.z}));
                    continue;
                }
                player.func_145747_a((IChatComponent)new ChatComponentTranslation(foundMsg, new Object[]{deviceName, coord.x, coord.y, coord.z}));
                continue;
            }
            if (wrongDimMsg == null) continue;
            if (deviceName.isEmpty()) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation(wrongDimMsg, new Object[]{coord.getDimension()}));
                continue;
            }
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(wrongDimMsg, new Object[]{deviceName, coord.getDimension()}));
        }
        BlockPosHighlighter.INSTANCE.expireHighlightTime = System.currentTimeMillis() + (long)highlightDuration;
    }

    public static void highlightBlocks(EntityPlayer player, List<DimensionalCoord> interfaces, String foundMsg, String wrongDimMsg) {
        BlockPosHighlighter.highlightBlocks(player, interfaces, "", foundMsg, wrongDimMsg);
    }

    @Override
    public void clear() {
        this.highlightedBlocks.clear();
        this.expireHighlightTime = -1L;
    }

    @Override
    public boolean noWork() {
        return this.highlightedBlocks.isEmpty();
    }

    @Override
    public void renderHighlightedBlocks(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        this.dimension = mc.field_71441_e.field_73011_w.field_76574_g;
        EntityClientPlayerMP p = mc.field_71439_g;
        this.doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)event.partialTicks;
        this.doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)event.partialTicks;
        this.doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)event.partialTicks;
        for (DimensionalCoord c : this.highlightedBlocks) {
            if (this.dimension != c.getDimension()) continue;
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            GL11.glLineWidth((float)3.0f);
            GL11.glTranslated((double)(-this.doubleX), (double)(-this.doubleY), (double)(-this.doubleZ));
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            this.renderHighLightedBlocksOutline(c.x, c.y, c.z);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    void renderHighLightedBlocksOutline(double x, double y, double z) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(3);
        tess.func_78369_a(1.0f, 0.0f, 0.0f, 1.0f);
        tess.func_78377_a(x, y, z);
        tess.func_78377_a(x, y + 1.0, z);
        tess.func_78377_a(x, y + 1.0, z + 1.0);
        tess.func_78377_a(x, y, z + 1.0);
        tess.func_78377_a(x, y, z);
        tess.func_78377_a(x + 1.0, y, z);
        tess.func_78377_a(x + 1.0, y + 1.0, z);
        tess.func_78377_a(x + 1.0, y + 1.0, z + 1.0);
        tess.func_78377_a(x + 1.0, y, z + 1.0);
        tess.func_78377_a(x + 1.0, y, z);
        tess.func_78377_a(x, y, z);
        tess.func_78377_a(x + 1.0, y, z);
        tess.func_78377_a(x + 1.0, y, z + 1.0);
        tess.func_78377_a(x, y, z + 1.0);
        tess.func_78377_a(x, y + 1.0, z + 1.0);
        tess.func_78377_a(x + 1.0, y + 1.0, z + 1.0);
        tess.func_78377_a(x + 1.0, y + 1.0, z);
        tess.func_78377_a(x + 1.0, y, z);
        tess.func_78377_a(x, y, z);
        tess.func_78377_a(x + 1.0, y, z);
        tess.func_78377_a(x + 1.0, y + 1.0, z);
        tess.func_78377_a(x, y + 1.0, z);
        tess.func_78377_a(x, y + 1.0, z + 1.0);
        tess.func_78377_a(x + 1.0, y + 1.0, z + 1.0);
        tess.func_78377_a(x + 1.0, y, z + 1.0);
        tess.func_78377_a(x, y, z + 1.0);
        tess.func_78381_a();
    }

    @Override
    public long getExpireTime() {
        return this.expireHighlightTime;
    }
}

