/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.AEApi;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.render.items.ItemEncodedPatternRenderer;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.helpers.PatternHelper;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.common.items.ItemIntegratedCircuit;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemEncodedPattern
extends AEBaseItem
implements ICraftingPatternItem {
    private static final Map<ItemStack, ItemStack> SIMPLE_CACHE = new WeakHashMap<ItemStack, ItemStack>();
    private static Item FLUID_DROP_ITEM;
    private static boolean checkedCache;
    private static final boolean isGTLoaded;
    private static final Locale locale;

    public ItemEncodedPattern() {
        this.setFeature(EnumSet.of(AEFeature.Patterns));
        this.func_77625_d(64);
        if (Platform.isClient()) {
            MinecraftForgeClient.registerItemRenderer((Item)this, (IItemRenderer)new ItemEncodedPatternRenderer());
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World w, EntityPlayer player) {
        this.clearPattern(stack, player);
        return stack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)stack, (int)1) <= 0) {
            return true;
        }
        return this.clearPattern(stack, player);
    }

    private boolean clearPattern(ItemStack stack, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (Platform.isClient()) {
                return false;
            }
            InventoryPlayer inv = player.field_71071_by;
            for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
                if (inv.func_70301_a(s) != stack) continue;
                for (ItemStack blankPattern : AEApi.instance().definitions().materials().blankPattern().maybeStack(stack.field_77994_a).asSet()) {
                    inv.func_70299_a(s, blankPattern);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        IAEItemStack[] outItems;
        IAEItemStack[] inItems;
        NBTTagCompound encodedValue = stack.func_77978_p();
        if (encodedValue == null) {
            lines.add(EnumChatFormatting.RED + GuiText.InvalidPattern.getLocal());
            return;
        }
        ICraftingPatternDetails details = this.getPatternForItem(stack, player.field_70170_p);
        boolean substitute = encodedValue.func_74767_n("substitute");
        boolean beSubstitute = encodedValue.func_74767_n("beSubstitute");
        String author = encodedValue.func_74779_i("author");
        if (details == null) {
            ItemStack unknownItem = new ItemStack((Block)Blocks.field_150480_ab);
            unknownItem.func_151001_c(GuiText.UnknownItem.getLocal());
            inItems = PatternHelper.convertToCondensedList(PatternHelper.loadIAEItemStackFromNBT(encodedValue.func_150295_c("in", 10), false, unknownItem));
            outItems = PatternHelper.convertToCondensedList(PatternHelper.loadIAEItemStackFromNBT(encodedValue.func_150295_c("out", 10), false, unknownItem));
        } else {
            inItems = details.getCondensedInputs();
            outItems = details.getCondensedOutputs();
        }
        boolean recipeIsBroken = details == null;
        ArrayList<String> in = new ArrayList<String>();
        ArrayList<String> out = new ArrayList<String>();
        String substitutionLabel = EnumChatFormatting.YELLOW + GuiText.Substitute.getLocal() + " " + EnumChatFormatting.RESET;
        String beSubstitutionLabel = EnumChatFormatting.YELLOW + GuiText.BeSubstitute.getLocal() + " " + EnumChatFormatting.RESET;
        String canSubstitute = substitute ? EnumChatFormatting.RED + GuiText.Yes.getLocal() : GuiText.No.getLocal();
        String canBeSubstitute = beSubstitute ? EnumChatFormatting.RED + GuiText.Yes.getLocal() : GuiText.No.getLocal();
        String result = (outItems.length > 1 ? EnumChatFormatting.DARK_AQUA + GuiText.Results.getLocal() : EnumChatFormatting.DARK_AQUA + GuiText.Result.getLocal()) + ":" + EnumChatFormatting.RESET;
        String ingredients = (inItems.length > 1 ? EnumChatFormatting.DARK_GREEN + GuiText.Ingredients.getLocal() : EnumChatFormatting.DARK_GREEN + GuiText.Ingredient.getLocal()) + ": " + EnumChatFormatting.RESET;
        String holdShift = EnumChatFormatting.GRAY + GuiText.HoldShift.getLocal() + EnumChatFormatting.RESET;
        recipeIsBroken = this.addInformation(player, inItems, in, ingredients, displayMoreInfo, EnumChatFormatting.GREEN) || recipeIsBroken;
        boolean bl = recipeIsBroken = this.addInformation(player, outItems, out, result, displayMoreInfo, EnumChatFormatting.AQUA) || recipeIsBroken;
        if (recipeIsBroken) {
            lines.add(EnumChatFormatting.RED + GuiText.InvalidPattern.getLocal());
        } else {
            lines.addAll(out);
            if (GuiScreen.func_146272_n()) {
                lines.addAll(in);
            } else {
                lines.add(holdShift);
            }
            lines.add(substitutionLabel + canSubstitute);
            lines.add(beSubstitutionLabel + canBeSubstitute);
            if (!StringUtils.func_151246_b((String)author)) {
                lines.add(EnumChatFormatting.LIGHT_PURPLE + GuiText.EncodedBy.getLocal(author) + EnumChatFormatting.RESET);
            }
        }
    }

    @Override
    public ICraftingPatternDetails getPatternForItem(ItemStack is, World w) {
        try {
            return new PatternHelper(is, w);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public ItemStack getOutput(ItemStack item) {
        ItemStack out = SIMPLE_CACHE.get(item);
        if (out != null) {
            return out;
        }
        World w = CommonHelper.proxy.getWorld();
        if (w == null) {
            return null;
        }
        ICraftingPatternDetails details = this.getPatternForItem(item, w);
        if (details == null) {
            return null;
        }
        out = details.getCondensedOutputs()[0].getItemStack();
        SIMPLE_CACHE.put(item, out);
        return out;
    }

    private boolean addInformation(EntityPlayer player, IAEItemStack[] items, List<String> lines, String label, boolean displayMoreInfo, EnumChatFormatting color) {
        ItemStack unknownItem = new ItemStack((Block)Blocks.field_150480_ab);
        boolean recipeIsBroken = false;
        boolean first = true;
        EnumChatFormatting oldColor = color;
        Item fluidDropItem = ItemEncodedPattern.getFluidDropItem();
        for (IAEItemStack item : items) {
            boolean isFluid;
            Long itemCount = item.getStackSize();
            if (!recipeIsBroken && item.equals(unknownItem)) {
                recipeIsBroken = true;
            }
            if (fluidDropItem != null && item.getItemStack().func_77973_b() == fluidDropItem) {
                color = EnumChatFormatting.GOLD;
                isFluid = true;
            } else {
                color = oldColor;
                isFluid = false;
            }
            String itemCountText = NumberFormat.getNumberInstance(locale).format(itemCount);
            String itemText = isGTLoaded ? (isFluid ? Platform.getItemDisplayName(item).replace("drop of", "") : (item.getItem() instanceof ItemIntegratedCircuit ? Platform.getItemDisplayName(item) + " " + item.getItemStack().func_77960_j() : Platform.getItemDisplayName(item))) : (isFluid ? Platform.getItemDisplayName(item).replace("drop of", "") : Platform.getItemDisplayName(item));
            String fullText = "   " + EnumChatFormatting.WHITE + itemCountText + EnumChatFormatting.RESET + (isFluid ? EnumChatFormatting.WHITE + "L" : " ") + EnumChatFormatting.RESET + color + itemText;
            if (first) {
                lines.add(label);
            }
            lines.add(fullText);
            first = false;
        }
        return recipeIsBroken;
    }

    private static Item getFluidDropItem() {
        if (!checkedCache) {
            FLUID_DROP_ITEM = GameRegistry.findItem((String)"ae2fc", (String)"fluid_drop");
            checkedCache = true;
        }
        return FLUID_DROP_ITEM;
    }

    static {
        checkedCache = false;
        isGTLoaded = IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.GT);
        locale = Locale.getDefault();
    }
}

