/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.util.AEColor;
import appeng.helpers.Splotch;
import appeng.items.misc.ItemPaintBall;
import appeng.tile.AEBaseTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePaint
extends AEBaseTile {
    private static final int LIGHT_PER_DOT = 12;
    private int isLit = 0;
    private List<Splotch> dots = null;

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TilePaint(NBTTagCompound data) {
        ByteBuf myDat = Unpooled.buffer();
        this.writeBuffer(myDat);
        if (myDat.hasArray()) {
            data.func_74773_a("dots", myDat.array());
        }
    }

    private void writeBuffer(ByteBuf out) {
        if (this.dots == null) {
            out.writeByte(0);
            return;
        }
        out.writeByte(this.dots.size());
        for (Splotch s : this.dots) {
            s.writeToStream(out);
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TilePaint(NBTTagCompound data) {
        if (data.func_74764_b("dots")) {
            this.readBuffer(Unpooled.copiedBuffer((byte[])data.func_74770_j("dots")));
        }
    }

    private void readBuffer(ByteBuf in) {
        int howMany = in.readByte();
        if (howMany == 0) {
            this.isLit = 0;
            this.dots = null;
            return;
        }
        this.dots = new ArrayList<Splotch>(howMany);
        for (int x = 0; x < howMany; ++x) {
            this.dots.add(new Splotch(in));
        }
        this.isLit = 0;
        for (Splotch s : this.dots) {
            if (!s.isLumen()) continue;
            this.isLit += 12;
        }
        this.maxLit();
    }

    private void maxLit() {
        if (this.isLit > 14) {
            this.isLit = 14;
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TilePaint(ByteBuf data) {
        this.writeBuffer(data);
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TilePaint(ByteBuf data) {
        this.readBuffer(data);
        return true;
    }

    public void onNeighborBlockChange() {
        if (this.dots == null) {
            return;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (this.isSideValid(side)) continue;
            this.removeSide(side);
        }
        this.updateData();
    }

    public boolean isSideValid(ForgeDirection side) {
        Block blk = this.field_145850_b.func_147439_a(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
        return blk.isSideSolid((IBlockAccess)this.field_145850_b, this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ, side.getOpposite());
    }

    private void removeSide(ForgeDirection side) {
        Iterator<Splotch> i = this.dots.iterator();
        while (i.hasNext()) {
            Splotch s = i.next();
            if (s.getSide() != side) continue;
            i.remove();
        }
        this.markForUpdate();
        this.func_70296_d();
    }

    private void updateData() {
        this.isLit = 0;
        for (Splotch s : this.dots) {
            if (!s.isLumen()) continue;
            this.isLit += 12;
        }
        this.maxLit();
        if (this.dots.isEmpty()) {
            this.dots = null;
        }
        if (this.dots == null) {
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a);
        }
    }

    public void cleanSide(ForgeDirection side) {
        if (this.dots == null) {
            return;
        }
        this.removeSide(side);
        this.updateData();
    }

    public int getLightLevel() {
        return this.isLit;
    }

    public void addBlot(ItemStack type, ForgeDirection side, Vec3 hitVec) {
        Block blk = this.field_145850_b.func_147439_a(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
        if (blk.isSideSolid((IBlockAccess)this.field_145850_b, this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ, side.getOpposite())) {
            ItemPaintBall ipb = (ItemPaintBall)type.func_77973_b();
            AEColor col = ipb.getColor(type);
            boolean lit = ipb.isLumen(type);
            if (this.dots == null) {
                this.dots = new ArrayList<Splotch>();
            }
            if (this.dots.size() > 20) {
                this.dots.remove(0);
            }
            this.dots.add(new Splotch(col, lit, side, hitVec));
            if (lit) {
                this.isLit += 12;
            }
            this.maxLit();
            this.markForUpdate();
            this.func_70296_d();
        }
    }

    public Collection<Splotch> getDots() {
        if (this.dots == null) {
            return ImmutableList.of();
        }
        return this.dots;
    }
}

