/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.core.AEConfig;
import appeng.me.GridAccessException;
import appeng.parts.p2p.IPartGT5Power;
import appeng.parts.p2p.PartP2PTunnel;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.util.GT_Utility;
import ic2.api.energy.tile.IEnergySink;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PartP2PGT5Power
extends PartP2PTunnel<PartP2PGT5Power>
implements IPartGT5Power {
    private TileEntity cachedTarget;
    private boolean isCachedTargetValid;

    public PartP2PGT5Power(ItemStack is) {
        super(is);
    }

    private static IChatComponent chatComponent(String title, String value) {
        ChatComponentText cct = new ChatComponentText(title);
        cct.func_150256_b().func_150238_a(EnumChatFormatting.GOLD);
        ChatComponentText ccv = new ChatComponentText(value);
        ccv.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
        cct.func_150257_a((IChatComponent)ccv);
        return cct;
    }

    @Override
    public void onTunnelNetworkChange() {
        super.onTunnelNetworkChange();
        this.isCachedTargetValid = false;
        this.cachedTarget = null;
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.isCachedTargetValid = false;
        this.cachedTarget = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IIcon getTypeTexture() {
        return Blocks.field_150343_Z.func_149691_a(0, 0);
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (!super.onPartActivate(player, pos) && !player.field_70170_p.field_72995_K && player.field_71071_by.func_70448_g() == null) {
            String inputLoc;
            PartP2PGT5Power input = (PartP2PGT5Power)this.getInput();
            if (input == null) {
                inputLoc = "no input";
            } else {
                TileEntity te = input.getHost().getTile();
                inputLoc = "[" + te.func_145831_w().field_73011_w.field_76574_g + "](" + te.field_145851_c + ", " + te.field_145849_e + ", " + te.field_145849_e + ")";
            }
            player.func_145747_a(PartP2PGT5Power.chatComponent("------", ""));
            player.func_145747_a(PartP2PGT5Power.chatComponent("Input location: ", (input == this ? "this block " : "") + inputLoc));
            player.func_145747_a(PartP2PGT5Power.chatComponent("Name: ", input != null ? input.getCustomName() : this.getCustomName()));
            player.func_145747_a(PartP2PGT5Power.chatComponent("Freq: ", "" + this.getFrequency()));
            return true;
        }
        return false;
    }

    @Override
    public long injectEnergyUnits(long voltage, long amperage) {
        if (!this.isOutput() && this.isActive() && voltage > 0L && amperage > 0L) {
            long amperesUsed = 0L;
            long amperes = amperage;
            long outvoltage = (long)((double)voltage * (1.0 - AEConfig.TUNNEL_POWER_LOSS));
            try {
                for (PartP2PGT5Power t : this.getOutputs()) {
                    long received = t.doOutput(outvoltage, amperes);
                    amperesUsed += received;
                    if ((amperes -= received) > 0L) continue;
                    break;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return amperesUsed;
        }
        return 0L;
    }

    @Override
    public boolean inputEnergy() {
        return !this.isOutput();
    }

    @Override
    public boolean outputsEnergy() {
        return this.isOutput();
    }

    @Nullable
    private TileEntity getTarget() {
        TileEntity te;
        if (this.isCachedTargetValid && ((te = this.cachedTarget) == null || !te.func_145837_r())) {
            return te;
        }
        this.isCachedTargetValid = true;
        te = this.getTile();
        ForgeDirection side = this.getSide();
        this.cachedTarget = te.func_145831_w().func_147438_o(te.field_145851_c + side.offsetX, te.field_145848_d + side.offsetY, te.field_145849_e + side.offsetZ);
        return this.cachedTarget;
    }

    private long doOutput(long aVoltage, long aAmperage) {
        if (!this.isOutput()) {
            return 0L;
        }
        TileEntity te = this.getTarget();
        if (te == null) {
            return 0L;
        }
        ForgeDirection oppositeSide = this.getSide().getOpposite();
        if (te instanceof IEnergyConnected) {
            return ((IEnergyConnected)te).injectEnergyUnits((byte)oppositeSide.ordinal(), aVoltage, aAmperage);
        }
        if (te instanceof IEnergySink) {
            if (((IEnergySink)te).acceptsEnergyFrom(this.getTile(), oppositeSide)) {
                long rUsedAmperes;
                for (rUsedAmperes = 0L; aAmperage > rUsedAmperes && ((IEnergySink)te).getDemandedEnergy() > 0.0 && ((IEnergySink)te).injectEnergy(oppositeSide, (double)aVoltage, (double)aVoltage) < (double)aVoltage; ++rUsedAmperes) {
                }
                return rUsedAmperes;
            }
        } else if (GregTech_API.mOutputRF && te instanceof IEnergyReceiver) {
            int rfOut = (int)(aVoltage * (long)GregTech_API.mEUtoRF / 100L);
            if (((IEnergyReceiver)te).receiveEnergy(oppositeSide, rfOut, true) == rfOut) {
                ((IEnergyReceiver)te).receiveEnergy(oppositeSide, rfOut, false);
                return 1L;
            }
            if (GregTech_API.mRFExplosions && GregTech_API.sMachineExplosions && ((IEnergyReceiver)te).getMaxEnergyStored(oppositeSide) < rfOut * 600 && rfOut > 32 * GregTech_API.mEUtoRF / 100) {
                float tStrength = (long)rfOut < GT_Values.V[0] ? 1.0f : ((long)rfOut < GT_Values.V[1] ? 2.0f : ((long)rfOut < GT_Values.V[2] ? 3.0f : ((long)rfOut < GT_Values.V[3] ? 4.0f : ((long)rfOut < GT_Values.V[4] ? 5.0f : ((long)rfOut < GT_Values.V[4] * 2L ? 6.0f : ((long)rfOut < GT_Values.V[5] ? 7.0f : ((long)rfOut < GT_Values.V[6] ? 8.0f : ((long)rfOut < GT_Values.V[7] ? 9.0f : 10.0f))))))));
                int tX = te.field_145851_c;
                int tY = te.field_145848_d;
                int tZ = te.field_145849_e;
                World tWorld = te.func_145831_w();
                GT_Utility.sendSoundToPlayers((World)tWorld, (String)((String)GregTech_API.sSoundList.get(209)), (float)1.0f, (float)-1.0f, (int)tX, (int)tY, (int)tZ);
                tWorld.func_147449_b(tX, tY, tZ, Blocks.field_150350_a);
                if (GregTech_API.sMachineExplosions) {
                    tWorld.func_72876_a(null, (double)tX + 0.5, (double)tY + 0.5, (double)tZ + 0.5, tStrength, true);
                }
            }
        }
        return 0L;
    }
}

