/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.tiles.ICraftingMachine;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.core.settings.TickRates;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.IPriorityHost;
import appeng.helpers.MultiCraftingTracker;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.storage.MEMonitorIInventory;
import appeng.me.storage.MEMonitorPassThrough;
import appeng.me.storage.NullInventory;
import appeng.parts.automation.StackUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorIInventory;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import appeng.util.inv.WrapperInvSlot;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DualityInterface
implements IGridTickable,
IStorageMonitorable,
IInventoryDestination,
IAEAppEngInventory,
IConfigManagerHost,
ICraftingProvider,
IUpgradeableHost,
IPriorityHost {
    public static final int NUMBER_OF_STORAGE_SLOTS = 9;
    public static final int NUMBER_OF_CONFIG_SLOTS = 9;
    public static final int NUMBER_OF_PATTERN_SLOTS = 9;
    private static final Collection<Block> BAD_BLOCKS = new HashSet<Block>(100);
    private final int[] sides = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private final IAEItemStack[] requireWork = new IAEItemStack[]{null, null, null, null, null, null, null, null, null};
    private final MultiCraftingTracker craftingTracker;
    private final AENetworkProxy gridProxy;
    private final IInterfaceHost iHost;
    private final BaseActionSource mySource;
    private final BaseActionSource interfaceRequestSource;
    private final ConfigManager cm = new ConfigManager(this);
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 9);
    private final AppEngInternalInventory storage = new AppEngInternalInventory(this, 9);
    private final AppEngInternalInventory patterns = new AppEngInternalInventory(this, 36);
    private final WrapperInvSlot slotInv = new WrapperInvSlot(this.storage);
    private final MEMonitorPassThrough<IAEItemStack> items = new MEMonitorPassThrough(new NullInventory(), StorageChannel.ITEMS);
    private final MEMonitorPassThrough<IAEFluidStack> fluids = new MEMonitorPassThrough(new NullInventory(), StorageChannel.FLUIDS);
    private final UpgradeInventory upgrades;
    private boolean hasConfig = false;
    private int priority;
    private List<ICraftingPatternDetails> craftingList = null;
    private List<ItemStack> waitingToSend = null;
    private IMEInventory<IAEItemStack> destination;
    private boolean isWorking = false;

    public DualityInterface(AENetworkProxy networkProxy, IInterfaceHost ih) {
        this.gridProxy = networkProxy;
        this.gridProxy.setFlags(GridFlags.REQUIRE_CHANNEL);
        this.upgrades = new StackUpgradeInventory(this.gridProxy.getMachineRepresentation(), this, 4);
        this.cm.registerSetting(Settings.BLOCK, (Enum)YesNo.NO);
        this.cm.registerSetting(Settings.INTERFACE_TERMINAL, (Enum)YesNo.YES);
        this.iHost = ih;
        this.craftingTracker = new MultiCraftingTracker(this.iHost, 9);
        MachineSource actionSource = new MachineSource(this.iHost);
        this.mySource = actionSource;
        this.fluids.setChangeSource(actionSource);
        this.items.setChangeSource(actionSource);
        this.interfaceRequestSource = new InterfaceRequestSource(this.iHost);
    }

    @Override
    public void saveChanges() {
        this.iHost.saveChanges();
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.isWorking) {
            return;
        }
        if (inv == this.config) {
            this.readConfig();
        } else if (inv == this.patterns && (removed != null || added != null)) {
            this.updateCraftingList();
        } else if (inv == this.storage && slot >= 0) {
            boolean had = this.hasWorkToDo();
            this.updatePlan(slot);
            boolean now = this.hasWorkToDo();
            if (had != now) {
                try {
                    if (now) {
                        this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
                    } else {
                        this.gridProxy.getTick().sleepDevice(this.gridProxy.getNode());
                    }
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        this.config.writeToNBT(data, "config");
        this.patterns.writeToNBT(data, "patterns");
        this.storage.writeToNBT(data, "storage");
        this.upgrades.writeToNBT(data, "upgrades");
        this.cm.writeToNBT(data);
        this.craftingTracker.writeToNBT(data);
        data.func_74768_a("priority", this.priority);
        NBTTagList waitingToSend = new NBTTagList();
        if (this.waitingToSend != null) {
            for (ItemStack is : this.waitingToSend) {
                NBTTagCompound item = new NBTTagCompound();
                is.func_77955_b(item);
                waitingToSend.func_74742_a((NBTBase)item);
            }
        }
        data.func_74782_a("waitingToSend", (NBTBase)waitingToSend);
    }

    public void readFromNBT(NBTTagCompound data) {
        this.waitingToSend = null;
        NBTTagList waitingList = data.func_150295_c("waitingToSend", 10);
        if (waitingList != null) {
            for (int x = 0; x < waitingList.func_74745_c(); ++x) {
                NBTTagCompound c = waitingList.func_150305_b(x);
                if (c == null) continue;
                ItemStack is = ItemStack.func_77949_a((NBTTagCompound)c);
                this.addToSendList(is);
            }
        }
        this.craftingTracker.readFromNBT(data);
        this.upgrades.readFromNBT(data, "upgrades");
        this.config.readFromNBT(data, "config");
        this.patterns.readFromNBT(data, "patterns");
        this.storage.readFromNBT(data, "storage");
        this.priority = data.func_74762_e("priority");
        this.cm.readFromNBT(data);
        this.readConfig();
        this.updateCraftingList();
    }

    private void addToSendList(ItemStack is) {
        if (is == null) {
            return;
        }
        if (this.waitingToSend == null) {
            this.waitingToSend = new LinkedList<ItemStack>();
        }
        this.waitingToSend.add(is);
        try {
            this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void readConfig() {
        this.hasConfig = false;
        for (ItemStack p : this.config) {
            if (p == null) continue;
            this.hasConfig = true;
            break;
        }
        boolean had = this.hasWorkToDo();
        for (int x = 0; x < 9; ++x) {
            this.updatePlan(x);
        }
        boolean has = this.hasWorkToDo();
        if (had != has) {
            try {
                if (has) {
                    this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
                } else {
                    this.gridProxy.getTick().sleepDevice(this.gridProxy.getNode());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        this.notifyNeighbors();
    }

    private void updateCraftingList() {
        boolean[] accountedFor = new boolean[this.patterns.func_70302_i_()];
        if (!this.gridProxy.isReady()) {
            return;
        }
        if (this.craftingList != null) {
            Iterator<ICraftingPatternDetails> i = this.craftingList.iterator();
            while (i.hasNext()) {
                ICraftingPatternDetails details = i.next();
                boolean found = false;
                for (int x = 0; x < accountedFor.length; ++x) {
                    ItemStack is = this.patterns.func_70301_a(x);
                    if (details.getPattern() != is) continue;
                    found = true;
                    accountedFor[x] = true;
                }
                if (found) continue;
                i.remove();
            }
        }
        for (int x = 0; x < accountedFor.length; ++x) {
            if (accountedFor[x]) continue;
            this.addToCraftingList(this.patterns.func_70301_a(x));
        }
        try {
            this.gridProxy.getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.gridProxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private boolean hasWorkToDo() {
        if (this.hasItemsToSend()) {
            return true;
        }
        for (IAEItemStack requiredWork : this.requireWork) {
            if (requiredWork == null) continue;
            return true;
        }
        return false;
    }

    private void updatePlan(int slot) {
        IAEItemStack req = this.config.getAEStackInSlot(slot);
        if (req != null && req.getStackSize() <= 0L) {
            this.config.func_70299_a(slot, null);
            req = null;
        }
        ItemStack Stored = this.storage.func_70301_a(slot);
        if (req == null && Stored != null) {
            IAEItemStack work = AEApi.instance().storage().createItemStack(Stored);
            this.requireWork[slot] = (IAEItemStack)work.setStackSize(-work.getStackSize());
            return;
        }
        if (req != null) {
            if (Stored == null) {
                this.requireWork[slot] = req.copy();
                return;
            }
            if (req.isSameType(Stored)) {
                if (req.getStackSize() != (long)Stored.field_77994_a) {
                    this.requireWork[slot] = req.copy();
                    this.requireWork[slot].setStackSize(req.getStackSize() - (long)Stored.field_77994_a);
                    return;
                }
            } else {
                IAEItemStack work = AEApi.instance().storage().createItemStack(Stored);
                this.requireWork[slot] = (IAEItemStack)work.setStackSize(-work.getStackSize());
                return;
            }
        }
        this.requireWork[slot] = null;
    }

    public void notifyNeighbors() {
        TileEntity te;
        if (this.gridProxy.isActive()) {
            try {
                this.gridProxy.getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.gridProxy.getNode()));
                this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if ((te = this.iHost.getTileEntity()) != null && te.func_145831_w() != null) {
            Platform.notifyBlocksOfNeighbors(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }
    }

    private void addToCraftingList(ItemStack is) {
        ICraftingPatternItem cpi;
        ICraftingPatternDetails details;
        if (is == null) {
            return;
        }
        if (is.func_77973_b() instanceof ICraftingPatternItem && (details = (cpi = (ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.iHost.getTileEntity().func_145831_w())) != null) {
            if (this.craftingList == null) {
                this.craftingList = new LinkedList<ICraftingPatternDetails>();
            }
            this.craftingList.add(details);
        }
    }

    private boolean hasItemsToSend() {
        return this.waitingToSend != null && !this.waitingToSend.isEmpty();
    }

    @Override
    public boolean canInsert(ItemStack stack) {
        IAEItemStack out = this.destination.injectItems(AEApi.instance().storage().createItemStack(stack), Actionable.SIMULATE, null);
        if (out == null) {
            return true;
        }
        return out.getStackSize() != (long)stack.field_77994_a;
    }

    public IInventory getConfig() {
        return this.config;
    }

    public IInventory getPatterns() {
        return this.patterns;
    }

    public void gridChanged() {
        try {
            this.items.setInternal(this.gridProxy.getStorage().getItemInventory());
            this.fluids.setInternal(this.gridProxy.getStorage().getFluidInventory());
        }
        catch (GridAccessException gae) {
            this.items.setInternal(new NullInventory());
            this.fluids.setInternal(new NullInventory());
        }
        this.notifyNeighbors();
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.iHost.getTileEntity());
    }

    public IInventory getInternalInventory() {
        return this.storage;
    }

    public void markDirty() {
        for (int slot = 0; slot < this.storage.func_70302_i_(); ++slot) {
            this.onChangeInventory(this.storage, slot, InvOperation.markDirty, null, null);
        }
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return this.sides;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Interface.getMin(), TickRates.Interface.getMax(), !this.hasWorkToDo(), true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.gridProxy.isActive()) {
            return TickRateModulation.SLEEP;
        }
        if (this.hasItemsToSend()) {
            this.pushItemsOut(this.iHost.getTargets());
        }
        boolean couldDoWork = this.updateStorage();
        return this.hasWorkToDo() ? (couldDoWork ? TickRateModulation.URGENT : TickRateModulation.SLOWER) : TickRateModulation.SLEEP;
    }

    private void pushItemsOut(EnumSet<ForgeDirection> possibleDirections) {
        if (!this.hasItemsToSend()) {
            return;
        }
        TileEntity tile = this.iHost.getTileEntity();
        World w = tile.func_145831_w();
        Iterator<ItemStack> i = this.waitingToSend.iterator();
        while (i.hasNext()) {
            ItemStack whatToSend = i.next();
            for (ForgeDirection s : possibleDirections) {
                InventoryAdaptor ad;
                TileEntity te = w.func_147438_o(tile.field_145851_c + s.offsetX, tile.field_145848_d + s.offsetY, tile.field_145849_e + s.offsetZ);
                if (te == null || (ad = InventoryAdaptor.getAdaptor(te, s.getOpposite())) == null) continue;
                ItemStack Result = ad.addItems(whatToSend);
                if (Result == null) {
                    whatToSend = null;
                } else {
                    whatToSend.field_77994_a -= whatToSend.field_77994_a - Result.field_77994_a;
                }
                if (whatToSend != null) continue;
                break;
            }
            if (whatToSend != null) continue;
            i.remove();
        }
        if (this.waitingToSend.isEmpty()) {
            this.waitingToSend = null;
        }
    }

    private boolean updateStorage() {
        boolean didSomething = false;
        for (int x = 0; x < 9; ++x) {
            if (this.requireWork[x] == null) continue;
            didSomething = this.usePlan(x, this.requireWork[x]) || didSomething;
        }
        return didSomething;
    }

    private boolean usePlan(int x, IAEItemStack itemStack) {
        InventoryAdaptor adaptor = this.getAdaptor(x);
        this.isWorking = true;
        boolean changed = false;
        try {
            this.destination = this.gridProxy.getStorage().getItemInventory();
            IEnergyGrid src = this.gridProxy.getEnergy();
            if (this.craftingTracker.isBusy(x)) {
                changed = this.handleCrafting(x, adaptor, itemStack);
            } else if (itemStack.getStackSize() > 0L) {
                if (adaptor.simulateAdd(itemStack.getItemStack()) != null) {
                    changed = true;
                    throw new GridAccessException();
                }
                IAEItemStack acquired = Platform.poweredExtraction(src, this.destination, itemStack, this.interfaceRequestSource);
                if (acquired != null) {
                    changed = true;
                    ItemStack issue = adaptor.addItems(acquired.getItemStack());
                    if (issue != null) {
                        throw new IllegalStateException("bad attempt at managing inventory. ( addItems )");
                    }
                } else {
                    changed = this.handleCrafting(x, adaptor, itemStack);
                }
            } else if (itemStack.getStackSize() < 0L) {
                IAEItemStack toStore = itemStack.copy();
                toStore.setStackSize(-toStore.getStackSize());
                long diff = toStore.getStackSize();
                ItemStack canExtract = adaptor.simulateRemove((int)diff, toStore.getItemStack(), null);
                if (canExtract == null || (long)canExtract.field_77994_a != diff) {
                    changed = true;
                    throw new GridAccessException();
                }
                if ((toStore = Platform.poweredInsert(src, this.destination, toStore, this.interfaceRequestSource)) != null) {
                    diff -= toStore.getStackSize();
                }
                if (diff != 0L) {
                    changed = true;
                    ItemStack removed = adaptor.removeItems((int)diff, null, null);
                    if (removed == null) {
                        throw new IllegalStateException("bad attempt at managing inventory. ( removeItems )");
                    }
                    if ((long)removed.field_77994_a != diff) {
                        throw new IllegalStateException("bad attempt at managing inventory. ( removeItems )");
                    }
                }
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (changed) {
            this.updatePlan(x);
        }
        this.isWorking = false;
        return changed;
    }

    private InventoryAdaptor getAdaptor(int slot) {
        return new AdaptorIInventory(this.slotInv.getWrapper(slot));
    }

    private boolean handleCrafting(int x, InventoryAdaptor d, IAEItemStack itemStack) {
        try {
            if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0 && itemStack != null) {
                return this.craftingTracker.handleCrafting(x, itemStack.getStackSize(), itemStack, d, this.iHost.getTileEntity().func_145831_w(), this.gridProxy.getGrid(), this.gridProxy.getCrafting(), this.mySource);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        if (this.upgrades == null) {
            return 0;
        }
        return this.upgrades.getInstalledUpgrades(u);
    }

    @Override
    public TileEntity getTile() {
        return (TileEntity)(this.iHost instanceof TileEntity ? this.iHost : null);
    }

    @Override
    public IMEMonitor<IAEItemStack> getItemInventory() {
        if (this.hasConfig()) {
            return new InterfaceInventory(this);
        }
        return this.items;
    }

    private boolean hasConfig() {
        return this.hasConfig;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("storage")) {
            return this.storage;
        }
        if (name.equals("patterns")) {
            return this.patterns;
        }
        if (name.equals("config")) {
            return this.config;
        }
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    public IInventory getStorage() {
        return this.storage;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) == 0) {
            this.cancelCrafting();
        }
        this.markDirty();
    }

    @Override
    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        if (this.hasConfig()) {
            return null;
        }
        return this.fluids;
    }

    private void cancelCrafting() {
        this.craftingTracker.cancel();
    }

    public IStorageMonitorable getMonitorable(ForgeDirection side, BaseActionSource src, IStorageMonitorable myInterface) {
        if (Platform.canAccess(this.gridProxy, src)) {
            return myInterface;
        }
        final DualityInterface di = this;
        return new IStorageMonitorable(){

            @Override
            public IMEMonitor<IAEItemStack> getItemInventory() {
                return new InterfaceInventory(di);
            }

            @Override
            public IMEMonitor<IAEFluidStack> getFluidInventory() {
                return null;
            }
        };
    }

    private boolean gtMachineHasOnlyCircuit(InventoryAdaptor ad) {
        for (ItemSlot i : ad) {
            ItemStack is = i.getItemStack();
            if (is == null || is.func_77973_b().func_77658_a().equals("gt.integrated_circuit")) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.hasItemsToSend() || !this.gridProxy.isActive() || !this.craftingList.contains(patternDetails)) {
            return false;
        }
        TileEntity tile = this.iHost.getTileEntity();
        World w = tile.func_145831_w();
        EnumSet<ForgeDirection> possibleDirections = this.iHost.getTargets();
        for (ForgeDirection s : possibleDirections) {
            ICraftingMachine cm;
            TileEntity te = w.func_147438_o(tile.field_145851_c + s.offsetX, tile.field_145848_d + s.offsetY, tile.field_145849_e + s.offsetZ);
            if (te instanceof IInterfaceHost) {
                try {
                    if (((IInterfaceHost)te).getInterfaceDuality().sameGrid(this.gridProxy.getGrid())) {
                    }
                }
                catch (GridAccessException e) {}
                continue;
            }
            if (te instanceof ICraftingMachine && (cm = (ICraftingMachine)te).acceptsPlans()) {
                if (!cm.pushPattern(patternDetails, table, s.getOpposite())) continue;
                return true;
            }
            InventoryAdaptor ad = InventoryAdaptor.getAdaptor(te, s.getOpposite());
            if (ad == null || this.isBlocking() && ad.containsItems() && (!te.func_145838_q().func_149739_a().equals("gt.blockmachines") || !this.gtMachineHasOnlyCircuit(ad)) || !this.acceptsItems(ad, table)) continue;
            for (int x = 0; x < table.func_70302_i_(); ++x) {
                ItemStack is = table.func_70301_a(x);
                if (is == null) continue;
                ItemStack added = ad.addItems(is);
                this.addToSendList(added);
            }
            this.pushItemsOut(possibleDirections);
            return true;
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        if (this.hasItemsToSend()) {
            return true;
        }
        boolean busy = false;
        if (this.isBlocking()) {
            EnumSet<ForgeDirection> possibleDirections = this.iHost.getTargets();
            TileEntity tile = this.iHost.getTileEntity();
            World w = tile.func_145831_w();
            boolean allAreBusy = true;
            for (ForgeDirection s : possibleDirections) {
                TileEntity te = w.func_147438_o(tile.field_145851_c + s.offsetX, tile.field_145848_d + s.offsetY, tile.field_145849_e + s.offsetZ);
                InventoryAdaptor ad = InventoryAdaptor.getAdaptor(te, s.getOpposite());
                if (ad == null || ad.simulateRemove(1, null, null) != null) continue;
                allAreBusy = false;
                break;
            }
            busy = allAreBusy;
        }
        return busy;
    }

    private boolean sameGrid(IGrid grid) throws GridAccessException {
        return grid == this.gridProxy.getGrid();
    }

    private boolean isBlocking() {
        return this.cm.getSetting(Settings.BLOCK) == YesNo.YES;
    }

    private boolean acceptsItems(InventoryAdaptor ad, InventoryCrafting table) {
        for (int x = 0; x < table.func_70302_i_(); ++x) {
            ItemStack is = table.func_70301_a(x);
            if (is == null || ad.simulateAdd(is.func_77946_l()) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.gridProxy.isActive() && this.craftingList != null) {
            for (ICraftingPatternDetails details : this.craftingList) {
                details.setPriority(this.priority);
                craftingTracker.addCraftingOption(this, details);
            }
        }
    }

    public void addDrops(List<ItemStack> drops) {
        if (this.waitingToSend != null) {
            for (ItemStack is : this.waitingToSend) {
                if (is == null) continue;
                drops.add(is);
            }
        }
        for (ItemStack is : this.upgrades) {
            if (is == null) continue;
            drops.add(is);
        }
        for (ItemStack is : this.storage) {
            if (is == null) continue;
            drops.add(is);
        }
        for (ItemStack is : this.patterns) {
            if (is == null) continue;
            drops.add(is);
        }
    }

    public IUpgradeableHost getHost() {
        if (this.getPart() != null) {
            return (IUpgradeableHost)((Object)this.getPart());
        }
        if (this.getTile() instanceof IUpgradeableHost) {
            return (IUpgradeableHost)this.getTile();
        }
        return null;
    }

    private IPart getPart() {
        return (IPart)((Object)(this.iHost instanceof IPart ? this.iHost : null));
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.craftingTracker.getRequestedJobs();
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack acquired, Actionable mode) {
        int slot = this.craftingTracker.getSlot(link);
        if (acquired != null && slot >= 0 && slot <= this.requireWork.length) {
            InventoryAdaptor adaptor = this.getAdaptor(slot);
            if (mode == Actionable.SIMULATE) {
                return AEItemStack.create(adaptor.simulateAdd(acquired.getItemStack()));
            }
            AEItemStack is = AEItemStack.create(adaptor.addItems(acquired.getItemStack()));
            this.updatePlan(slot);
            return is;
        }
        return acquired;
    }

    public void jobStateChange(ICraftingLink link) {
        this.craftingTracker.jobStateChange(link);
    }

    public String getTermName() {
        TileEntity hostTile = this.iHost.getTileEntity();
        World hostWorld = hostTile.func_145831_w();
        if (((ICustomNameObject)((Object)this.iHost)).hasCustomName()) {
            return ((ICustomNameObject)((Object)this.iHost)).getCustomName();
        }
        EnumSet<ForgeDirection> possibleDirections = this.iHost.getTargets();
        for (ForgeDirection direction : possibleDirections) {
            int[] sides;
            int xPos = hostTile.field_145851_c + direction.offsetX;
            int yPos = hostTile.field_145848_d + direction.offsetY;
            int zPos = hostTile.field_145849_e + direction.offsetZ;
            TileEntity directedTile = hostWorld.func_147438_o(xPos, yPos, zPos);
            if (directedTile == null) continue;
            if (directedTile instanceof IInterfaceHost) {
                try {
                    if (((IInterfaceHost)directedTile).getInterfaceDuality().sameGrid(this.gridProxy.getGrid())) {
                    }
                }
                catch (GridAccessException e) {}
                continue;
            }
            InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor(directedTile, direction.getOpposite());
            if (!(directedTile instanceof ICraftingMachine) && adaptor == null || directedTile instanceof IInventory && ((IInventory)directedTile).func_70302_i_() == 0 || directedTile instanceof ISidedInventory && ((sides = ((ISidedInventory)directedTile).func_94128_d(direction.getOpposite().ordinal())) == null || sides.length == 0)) continue;
            Block directedBlock = hostWorld.func_147439_a(xPos, yPos, zPos);
            ItemStack what = new ItemStack(directedBlock, 1, directedBlock.func_149643_k(hostWorld, xPos, yPos, zPos));
            try {
                ItemStack g;
                Vec3 from = Vec3.func_72443_a((double)((double)hostTile.field_145851_c + 0.5), (double)((double)hostTile.field_145848_d + 0.5), (double)((double)hostTile.field_145849_e + 0.5));
                from = from.func_72441_c((double)direction.offsetX * 0.501, (double)direction.offsetY * 0.501, (double)direction.offsetZ * 0.501);
                Vec3 to = from.func_72441_c((double)direction.offsetX, (double)direction.offsetY, (double)direction.offsetZ);
                MovingObjectPosition mop = hostWorld.func_72901_a(from, to, true);
                if (mop != null && !BAD_BLOCKS.contains(directedBlock) && mop.field_72311_b == directedTile.field_145851_c && mop.field_72312_c == directedTile.field_145848_d && mop.field_72309_d == directedTile.field_145849_e && (g = directedBlock.getPickBlock(mop, hostWorld, directedTile.field_145851_c, directedTile.field_145848_d, directedTile.field_145849_e, null)) != null) {
                    what = g;
                }
            }
            catch (Throwable t) {
                BAD_BLOCKS.add(directedBlock);
            }
            if (what.func_77973_b() != null) {
                return what.func_77977_a();
            }
            Item item = Item.func_150898_a((Block)directedBlock);
            if (item != null) continue;
            return directedBlock.func_149739_a();
        }
        return "Nothing";
    }

    public long getSortValue() {
        TileEntity te = this.iHost.getTileEntity();
        return te.field_145849_e << 24 ^ te.field_145851_c << 8 ^ te.field_145848_d;
    }

    public void initialize() {
        this.updateCraftingList();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.markDirty();
        try {
            this.gridProxy.getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.gridProxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private class InterfaceInventory
    extends MEMonitorIInventory {
        public InterfaceInventory(DualityInterface tileInterface) {
            super(new AdaptorIInventory(tileInterface.storage));
            this.setActionSource(new MachineSource(DualityInterface.this.iHost));
        }

        @Override
        public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
            if (src instanceof InterfaceRequestSource) {
                return input;
            }
            return super.injectItems(input, type, src);
        }

        @Override
        public IAEItemStack extractItems(IAEItemStack request, Actionable type, BaseActionSource src) {
            if (src instanceof InterfaceRequestSource) {
                return null;
            }
            return super.extractItems(request, type, src);
        }
    }

    private static class InterfaceRequestSource
    extends MachineSource {
        public InterfaceRequestSource(IActionHost v) {
            super(v);
        }
    }
}

