/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.cache.SecurityCache;
import appeng.util.ItemSorters;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class NetworkInventoryHandler<T extends IAEStack<T>>
implements IMEInventoryHandler<T> {
    private static final ThreadLocal<LinkedList> DEPTH_MOD = new ThreadLocal();
    private static final ThreadLocal<LinkedList> DEPTH_SIM = new ThreadLocal();
    private static final Comparator<Integer> PRIORITY_SORTER = (o1, o2) -> ItemSorters.compareInt(o2, o1);
    private static int currentPass = 0;
    private final StorageChannel myChannel;
    private final SecurityCache security;
    private final NavigableMap<Integer, List<IMEInventoryHandler<T>>> priorityInventory;
    private final NavigableMap<Integer, List<IMEInventoryHandler<T>>> stickyPriorityInventory;
    private int myPass = 0;

    public NetworkInventoryHandler(StorageChannel chan, SecurityCache security) {
        this.myChannel = chan;
        this.security = security;
        this.priorityInventory = new TreeMap<Integer, List<IMEInventoryHandler<T>>>(PRIORITY_SORTER);
        this.stickyPriorityInventory = new TreeMap<Integer, List<IMEInventoryHandler<T>>>(PRIORITY_SORTER);
    }

    public void addNewStorage(IMEInventoryHandler<T> h) {
        int priority = h.getPriority();
        if (!h.getSticky()) {
            List list = this.priorityInventory.computeIfAbsent(priority, k -> new ArrayList());
            list.add(h);
        } else {
            List listSticky = this.stickyPriorityInventory.computeIfAbsent(priority, k -> new ArrayList());
            listSticky.add(h);
        }
    }

    @Override
    public T injectItems(T input, Actionable type, BaseActionSource src) {
        IMEInventoryHandler inv;
        Iterator ii;
        if (this.diveList(this, type)) {
            return input;
        }
        if (this.testPermission(src, SecurityPermissions.INJECT)) {
            this.surface(this, type);
            return input;
        }
        boolean stickyInventoryFound = false;
        for (List stickyInvList : this.stickyPriorityInventory.values()) {
            ii = stickyInvList.iterator();
            while (ii.hasNext() && input != null) {
                inv = (IMEInventoryHandler)ii.next();
                if (!inv.validForPass(1) || !inv.canAccept(input) || !inv.isPrioritized(input) && inv.extractItems(input, Actionable.SIMULATE, src) == null) continue;
                input = inv.injectItems(input, type, src);
                stickyInventoryFound = true;
            }
        }
        if (stickyInventoryFound) {
            this.surface(this, type);
            return input;
        }
        for (List invList : this.priorityInventory.values()) {
            ii = invList.iterator();
            while (ii.hasNext() && input != null) {
                inv = (IMEInventoryHandler)ii.next();
                if (!inv.validForPass(1) || !inv.canAccept(input) || !inv.isPrioritized(input) && inv.extractItems(input, Actionable.SIMULATE, src) == null) continue;
                input = inv.injectItems(input, type, src);
            }
            ii = invList.iterator();
            while (ii.hasNext() && input != null) {
                inv = (IMEInventoryHandler)ii.next();
                if (!inv.validForPass(2) || !inv.canAccept(input) || inv.isPrioritized(input)) continue;
                input = inv.injectItems(input, type, src);
            }
        }
        this.surface(this, type);
        return input;
    }

    private boolean diveList(NetworkInventoryHandler<T> networkInventoryHandler, Actionable type) {
        LinkedList cDepth = this.getDepth(type);
        if (cDepth.contains(networkInventoryHandler)) {
            return true;
        }
        cDepth.push(this);
        return false;
    }

    private boolean testPermission(BaseActionSource src, SecurityPermissions permission) {
        if (src.isPlayer()) {
            if (!this.security.hasPermission(((PlayerSource)src).player, permission)) {
                return true;
            }
        } else if (src.isMachine() && this.security.isAvailable()) {
            IGridNode n = ((MachineSource)src).via.getActionableNode();
            if (n == null) {
                return true;
            }
            IGrid gn = n.getGrid();
            if (gn != this.security.getGrid()) {
                int playerID;
                ISecurityGrid sg = (ISecurityGrid)gn.getCache(ISecurityGrid.class);
                int n2 = playerID = sg.isAvailable() ? sg.getOwner() : n.getPlayerID();
                if (!this.security.hasPermission(playerID, permission)) {
                    return true;
                }
            }
        }
        return false;
    }

    private void surface(NetworkInventoryHandler<T> networkInventoryHandler, Actionable type) {
        if (this.getDepth(type).pop() != this) {
            throw new IllegalStateException("Invalid Access to Networked Storage API detected.");
        }
    }

    private LinkedList getDepth(Actionable type) {
        ThreadLocal<LinkedList> depth = type == Actionable.MODULATE ? DEPTH_MOD : DEPTH_SIM;
        LinkedList s = depth.get();
        if (s == null) {
            s = new LinkedList();
            depth.set(s);
        }
        return s;
    }

    @Override
    public T extractItems(T request, Actionable mode, BaseActionSource src) {
        if (this.diveList(this, mode)) {
            return null;
        }
        if (this.testPermission(src, SecurityPermissions.EXTRACT)) {
            this.surface(this, mode);
            return null;
        }
        Iterator i = this.priorityInventory.descendingMap().values().iterator();
        Object output = request.copy();
        request = request.copy();
        output.setStackSize(0L);
        long req = request.getStackSize();
        while (i.hasNext()) {
            List invList = (List)i.next();
            Iterator ii = invList.iterator();
            while (ii.hasNext() && output.getStackSize() < req) {
                IMEInventoryHandler inv = (IMEInventoryHandler)ii.next();
                request.setStackSize(req - output.getStackSize());
                output.add((Object)inv.extractItems(request, mode, src));
            }
        }
        for (List invList : this.stickyPriorityInventory.descendingMap().values()) {
            Iterator jj = invList.iterator();
            while (jj.hasNext() && output.getStackSize() < req) {
                IMEInventoryHandler inv = (IMEInventoryHandler)jj.next();
                request.setStackSize(req - output.getStackSize());
                output.add((Object)inv.extractItems(request, mode, src));
            }
        }
        this.surface(this, mode);
        if (output.getStackSize() <= 0L) {
            return null;
        }
        return (T)output;
    }

    @Override
    public IItemList<T> getAvailableItems(IItemList out) {
        if (this.diveIteration(this, Actionable.SIMULATE)) {
            return out;
        }
        out = this.iterateInventories(out, this.priorityInventory);
        out = this.iterateInventories(out, this.stickyPriorityInventory);
        this.surface(this, Actionable.SIMULATE);
        return out;
    }

    private IItemList<T> iterateInventories(IItemList out, NavigableMap<Integer, List<IMEInventoryHandler<T>>> map) {
        for (List i : map.values()) {
            for (IMEInventoryHandler j : i) {
                out = j.getAvailableItems(out);
            }
        }
        return out;
    }

    @Override
    public T getAvailableItem(@Nonnull T request) {
        long count = 0L;
        if (this.diveIteration(this, Actionable.SIMULATE)) {
            return null;
        }
        block0: for (List i : this.priorityInventory.values()) {
            for (IMEInventoryHandler j : i) {
                T stack = j.getAvailableItem(request);
                if (stack == null || stack.getStackSize() <= 0L || (count += stack.getStackSize()) >= 0L) continue;
                count = Long.MAX_VALUE;
                continue block0;
            }
        }
        this.surface(this, Actionable.SIMULATE);
        return count == 0L ? null : (T)request.copy().setStackSize(count);
    }

    private boolean diveIteration(NetworkInventoryHandler<T> networkInventoryHandler, Actionable type) {
        LinkedList cDepth = this.getDepth(type);
        if (cDepth.isEmpty()) {
            this.myPass = ++currentPass;
        } else {
            if (currentPass == this.myPass) {
                return true;
            }
            this.myPass = currentPass;
        }
        cDepth.push(this);
        return false;
    }

    @Override
    public StorageChannel getChannel() {
        return this.myChannel;
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(T input) {
        return false;
    }

    @Override
    public boolean canAccept(T input) {
        return true;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }
}

