/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import appeng.core.worlddata.CompassData;
import appeng.core.worlddata.DimensionData;
import appeng.core.worlddata.IOnWorldStartable;
import appeng.core.worlddata.IOnWorldStoppable;
import appeng.core.worlddata.IWorldCompassData;
import appeng.core.worlddata.IWorldData;
import appeng.core.worlddata.IWorldDimensionData;
import appeng.core.worlddata.IWorldGridStorageData;
import appeng.core.worlddata.IWorldPlayerData;
import appeng.core.worlddata.IWorldSpawnData;
import appeng.core.worlddata.PlayerData;
import appeng.core.worlddata.SpawnData;
import appeng.core.worlddata.StorageData;
import appeng.services.CompassService;
import appeng.services.compass.CompassThreadFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;

public final class WorldData
implements IWorldData {
    private static final String AE2_DIRECTORY_NAME = "AE2";
    private static final String SETTING_FILE_NAME = "settings.cfg";
    private static final String SPAWNDATA_DIR_NAME = "spawndata";
    private static final String COMPASS_DIR_NAME = "compass";
    @Nullable
    private static IWorldData instance;
    private final IWorldPlayerData playerData;
    private final IWorldDimensionData dimensionData;
    private final IWorldGridStorageData storageData;
    private final IWorldCompassData compassData;
    private final IWorldSpawnData spawnData;
    private final List<IOnWorldStartable> startables;
    private final List<IOnWorldStoppable> stoppables;
    private final File ae2directory;
    private final File spawnDirectory;
    private final File compassDirectory;
    private final Configuration sharedConfig;

    private WorldData(@Nonnull File worldDirectory) {
        Preconditions.checkNotNull((Object)worldDirectory);
        Preconditions.checkArgument((boolean)worldDirectory.isDirectory());
        this.ae2directory = new File(worldDirectory, AE2_DIRECTORY_NAME);
        this.spawnDirectory = new File(this.ae2directory, SPAWNDATA_DIR_NAME);
        this.compassDirectory = new File(this.ae2directory, COMPASS_DIR_NAME);
        File settingsFile = new File(this.ae2directory, SETTING_FILE_NAME);
        this.sharedConfig = new Configuration(settingsFile, "rv3-beta-292-GTNH");
        PlayerData playerData = new PlayerData(this.sharedConfig);
        DimensionData dimensionData = new DimensionData(this.sharedConfig);
        StorageData storageData = new StorageData(this.sharedConfig);
        CompassThreadFactory compassThreadFactory = new CompassThreadFactory();
        CompassService compassService = new CompassService(this.compassDirectory, compassThreadFactory);
        CompassData compassData = new CompassData(this.compassDirectory, compassService);
        SpawnData spawnData = new SpawnData(this.spawnDirectory);
        this.playerData = playerData;
        this.dimensionData = dimensionData;
        this.storageData = storageData;
        this.compassData = compassData;
        this.spawnData = spawnData;
        this.startables = Lists.newArrayList((Object[])new IOnWorldStartable[]{playerData, dimensionData, storageData});
        this.stoppables = Lists.newArrayList((Object[])new IOnWorldStoppable[]{playerData, dimensionData, storageData, compassData});
    }

    @Deprecated
    @Nonnull
    public static IWorldData instance() {
        return instance;
    }

    public static void onServerAboutToStart() {
        File worldDirectory = DimensionManager.getCurrentSaveRootDirectory();
        WorldData newInstance = new WorldData(worldDirectory);
        instance = newInstance;
        newInstance.onServerStarting();
    }

    private void onServerStarting() {
        if (!this.ae2directory.isDirectory() && !this.ae2directory.mkdir()) {
            throw new IllegalStateException("Failed to create " + this.ae2directory.getAbsolutePath());
        }
        if (!this.compassDirectory.isDirectory() && !this.compassDirectory.mkdir()) {
            throw new IllegalStateException("Failed to create " + this.compassDirectory.getAbsolutePath());
        }
        if (!this.spawnDirectory.isDirectory() && !this.spawnDirectory.mkdir()) {
            throw new IllegalStateException("Failed to create " + this.spawnDirectory.getAbsolutePath());
        }
        for (IOnWorldStartable startable : this.startables) {
            startable.onWorldStart();
        }
        this.startables.clear();
    }

    @Override
    public void onServerStopping() {
        for (IOnWorldStoppable stoppable : this.stoppables) {
            stoppable.onWorldStop();
        }
    }

    @Override
    public void onServerStoppped() {
        Preconditions.checkNotNull((Object)instance);
        this.stoppables.clear();
        instance = null;
    }

    @Override
    @Nonnull
    public IWorldGridStorageData storageData() {
        return this.storageData;
    }

    @Override
    @Nonnull
    public IWorldPlayerData playerData() {
        return this.playerData;
    }

    @Override
    @Nonnull
    public IWorldDimensionData dimensionData() {
        return this.dimensionData;
    }

    @Override
    @Nonnull
    public IWorldCompassData compassData() {
        return this.compassData;
    }

    @Override
    @Nonnull
    public IWorldSpawnData spawnData() {
        return this.spawnData;
    }
}

