/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.client.gui.IInterfaceTerminalPostUpdate;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketInterfaceTerminalUpdate
extends AppEngPacket {
    public static final int CLEAR_ALL_BIT = 1;
    public static final int DISCONNECT_BIT = 2;
    private final List<PacketEntry> commands = new ArrayList<PacketEntry>();
    private int statusFlags;

    public PacketInterfaceTerminalUpdate(ByteBuf buf) throws IOException {
        this.decode(buf);
    }

    public PacketInterfaceTerminalUpdate() {
    }

    private void decode(ByteBuf buf) {
        this.statusFlags = buf.readByte();
        int numEntries = buf.readInt();
        for (int i = 0; i < numEntries; ++i) {
            try {
                byte packetType = buf.readByte();
                PacketType type = PacketType.valueOf(packetType);
                switch (type) {
                    case ADD: {
                        this.commands.add(new PacketAdd(buf));
                        break;
                    }
                    case REMOVE: {
                        this.commands.add(new PacketRemove(buf));
                        break;
                    }
                    case OVERWRITE: {
                        this.commands.add(new PacketOverwrite(buf));
                        break;
                    }
                    case RENAME: {
                        this.commands.add(new PacketRename(buf));
                    }
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (AEConfig.instance.isFeatureEnabled(AEFeature.PacketLogging)) {
                    AELog.info("Corrupted packet commands: (" + i + ") of (" + numEntries + ") -> " + this.commands.size() + " : " + this.commands.stream().map(packetEntry -> packetEntry.getClass().getSimpleName()).collect(Collectors.groupingBy(String::new, Collectors.counting())), new Object[0]);
                    if (AEConfig.instance.isFeatureEnabled(AEFeature.DebugLogging)) {
                        AELog.info(" <- Parsed content: " + this.commands, new Object[0]);
                    }
                }
                AELog.debug(e);
                return;
            }
            catch (IOException e) {
                AELog.error(e);
                break;
            }
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.PacketLogging)) {
            AELog.info(" <- Received commands " + this.commands.size() + " : " + this.commands.stream().map(packetEntry -> packetEntry.getClass().getSimpleName()).collect(Collectors.groupingBy(String::new, Collectors.counting())), new Object[0]);
        }
    }

    public void encode() {
        try {
            if (AEConfig.instance.isFeatureEnabled(AEFeature.PacketLogging)) {
                AELog.info(" -> Sent commands " + this.commands.size() + " : " + this.commands.stream().map(packetEntry -> packetEntry.getClass().getSimpleName()).collect(Collectors.groupingBy(String::new, Collectors.counting())), new Object[0]);
                if (AEConfig.instance.isFeatureEnabled(AEFeature.DebugLogging)) {
                    AELog.info(" -> Sent commands: " + this.commands, new Object[0]);
                }
            }
            ByteBuf buf = Unpooled.buffer((int)2048);
            buf.writeInt(this.getPacketID());
            buf.writeByte(this.statusFlags);
            buf.writeInt(this.commands.size());
            for (PacketEntry entry : this.commands) {
                entry.write(buf);
            }
            super.configureWrite(buf);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setClear() {
        this.statusFlags |= 1;
    }

    public void setDisconnect() {
        this.statusFlags |= 2;
    }

    public PacketAdd addNewEntry(long id, String name, boolean online) {
        PacketAdd packet = new PacketAdd(id, name, online);
        this.commands.add(packet);
        return packet;
    }

    public void addRemovalEntry(long id) {
        this.commands.add(new PacketRemove(id));
    }

    public void addRenamedEntry(long id, String newName) {
        this.commands.add(new PacketRename(id, newName));
    }

    public PacketOverwrite addOverwriteEntry(long id) {
        PacketOverwrite packet = new PacketOverwrite(id);
        this.commands.add(packet);
        return packet;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
        if (gs instanceof IInterfaceTerminalPostUpdate) {
            IInterfaceTerminalPostUpdate hasPostUpdate = (IInterfaceTerminalPostUpdate)gs;
            hasPostUpdate.postUpdate(this.commands, this.statusFlags);
        }
    }

    static enum PacketType {
        ADD,
        REMOVE,
        OVERWRITE,
        RENAME;

        public static final PacketType[] TYPES;

        public static PacketType valueOf(int idx) throws ArrayIndexOutOfBoundsException {
            return TYPES[idx];
        }

        static {
            TYPES = PacketType.values();
        }
    }

    public static class PacketAdd
    extends PacketEntry {
        public String name;
        public int x;
        public int y;
        public int z;
        public int dim;
        public int side;
        public int rows;
        public int rowSize;
        public boolean online;
        public ItemStack selfRep;
        public ItemStack dispRep;
        public NBTTagList items;

        PacketAdd(long id, String name, boolean online) {
            super(id);
            this.name = name;
            this.online = online;
        }

        PacketAdd(ByteBuf buf) throws IOException {
            super(buf);
        }

        public PacketAdd setLoc(int x, int y, int z, int dim, int side) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.dim = dim;
            this.side = side;
            return this;
        }

        public PacketAdd setItems(int rows, int rowSize, NBTTagList items) {
            this.rows = rows;
            this.rowSize = rowSize;
            this.items = items;
            return this;
        }

        public PacketAdd setReps(ItemStack selfRep, ItemStack dispRep) {
            this.selfRep = selfRep;
            this.dispRep = dispRep;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void write(ByteBuf buf) throws IOException {
            buf.writeByte(PacketType.ADD.ordinal());
            buf.writeLong(this.entryId);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
            buf.writeInt(this.dim);
            buf.writeByte(this.side);
            buf.writeInt(this.rows);
            buf.writeInt(this.rowSize);
            ByteBuf tempBuf = Unpooled.directBuffer((int)256);
            try {
                try (ByteBufOutputStream stream = new ByteBufOutputStream(tempBuf);){
                    NBTTagCompound wrapper = new NBTTagCompound();
                    if (this.selfRep != null) {
                        wrapper.func_74782_a("self", (NBTBase)this.selfRep.func_77955_b(new NBTTagCompound()));
                    }
                    if (this.dispRep != null) {
                        wrapper.func_74782_a("disp", (NBTBase)this.dispRep.func_77955_b(new NBTTagCompound()));
                    }
                    wrapper.func_74782_a("data", (NBTBase)this.items);
                    CompressedStreamTools.func_74799_a((NBTTagCompound)wrapper, (OutputStream)stream);
                }
                buf.writeInt(tempBuf.readableBytes());
                buf.writeBytes(tempBuf);
            }
            finally {
                tempBuf.release();
            }
        }

        @Override
        protected void read(ByteBuf buf) throws IOException {
            this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
            this.dim = buf.readInt();
            this.side = buf.readByte();
            this.rows = buf.readInt();
            this.rowSize = buf.readInt();
            int payloadSize = buf.readInt();
            try (ByteBufInputStream stream = new ByteBufInputStream(buf, payloadSize);){
                NBTTagCompound payload = CompressedStreamTools.func_74796_a((InputStream)stream);
                int available = stream.available();
                if (available > 0) {
                    byte[] left = new byte[available];
                    int read = stream.read(left);
                    if (AEConfig.instance.isFeatureEnabled(AEFeature.PacketLogging)) {
                        AELog.info("Unread bytes detected (" + read + "): " + Arrays.toString(left) + " at " + this.dim + "#(" + this.x + ":" + this.y + ":" + this.z + ")@" + ForgeDirection.getOrientation((int)this.side), new Object[0]);
                    }
                }
                if (payload.func_150297_b("self", 10)) {
                    this.selfRep = ItemStack.func_77949_a((NBTTagCompound)payload.func_74775_l("self"));
                }
                if (payload.func_150297_b("disp", 10)) {
                    this.dispRep = ItemStack.func_77949_a((NBTTagCompound)payload.func_74775_l("disp"));
                }
                this.items = payload.func_150295_c("data", 10);
            }
        }

        public String toString() {
            return "PacketAdd{name='" + this.name + '\'' + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", dim=" + this.dim + ", side=" + this.side + ", rows=" + this.rows + ", rowSize=" + this.rowSize + ", online=" + this.online + ", selfRep=" + this.selfRep + ", dispRep=" + this.dispRep + ", items=" + this.items + ", entryId=" + this.entryId + '}';
        }
    }

    public static class PacketRemove
    extends PacketEntry {
        PacketRemove(long id) {
            super(id);
        }

        PacketRemove(ByteBuf buf) throws IOException {
            super(buf);
        }

        @Override
        protected void write(ByteBuf buf) {
            buf.writeByte(PacketType.REMOVE.ordinal());
            buf.writeLong(this.entryId);
        }

        @Override
        protected void read(ByteBuf buf) {
        }

        public String toString() {
            return "PacketRemove{entryId=" + this.entryId + '}';
        }
    }

    public static class PacketOverwrite
    extends PacketEntry {
        public static final int ONLINE_BIT = 1;
        public static final int ONLINE_VALID = 2;
        public static final int ITEMS_VALID = 4;
        public static final int ALL_ITEM_UPDATE_BIT = 8;
        public boolean onlineValid;
        public boolean online;
        public boolean itemsValid;
        public boolean allItemUpdate;
        public int[] validIndices;
        public NBTTagList items;

        protected PacketOverwrite(long id) {
            super(id);
        }

        protected PacketOverwrite(ByteBuf buf) throws IOException {
            super(buf);
        }

        public PacketOverwrite setOnline(boolean online) {
            this.onlineValid = true;
            this.online = online;
            return this;
        }

        public PacketOverwrite setItems(int[] validIndices, NBTTagList items) {
            this.itemsValid = true;
            this.allItemUpdate = validIndices == null || validIndices.length == 0;
            this.validIndices = validIndices;
            this.items = items;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void write(ByteBuf buf) throws IOException {
            buf.writeByte(PacketType.OVERWRITE.ordinal());
            buf.writeLong(this.entryId);
            int flags = 0;
            if (this.onlineValid) {
                flags |= 2;
                flags |= this.online ? 1 : 0;
            }
            if (this.itemsValid) {
                flags |= 4;
                if (this.allItemUpdate) {
                    buf.writeByte(flags |= 8);
                } else {
                    buf.writeByte(flags);
                    buf.writeInt(this.validIndices.length);
                    for (int validIndex : this.validIndices) {
                        buf.writeInt(validIndex);
                    }
                }
                ByteBuf tempBuf = Unpooled.directBuffer((int)256);
                try {
                    try (ByteBufOutputStream stream = new ByteBufOutputStream(tempBuf);){
                        NBTTagCompound wrapper = new NBTTagCompound();
                        wrapper.func_74782_a("data", (NBTBase)this.items);
                        CompressedStreamTools.func_74799_a((NBTTagCompound)wrapper, (OutputStream)stream);
                    }
                    buf.writeInt(tempBuf.readableBytes());
                    buf.writeBytes(tempBuf);
                }
                finally {
                    tempBuf.release();
                }
            }
            buf.writeByte(flags);
        }

        @Override
        protected void read(ByteBuf buf) throws IOException {
            byte flags = buf.readByte();
            if ((flags & 2) == 2) {
                this.onlineValid = true;
                boolean bl = this.online = (flags & 1) == 1;
            }
            if ((flags & 4) == 4) {
                if ((flags & 8) == 8) {
                    this.allItemUpdate = true;
                } else {
                    int numItems = buf.readInt();
                    this.itemsValid = true;
                    this.validIndices = new int[numItems];
                    for (int i = 0; i < numItems; ++i) {
                        this.validIndices[i] = buf.readInt();
                    }
                }
                int payloadSize = buf.readInt();
                try (ByteBufInputStream stream = new ByteBufInputStream(buf, payloadSize);){
                    this.items = CompressedStreamTools.func_74796_a((InputStream)stream).func_150295_c("data", 10);
                    int available = stream.available();
                    if (available > 0) {
                        byte[] left = new byte[available];
                        int read = stream.read(left);
                        if (AEConfig.instance.isFeatureEnabled(AEFeature.PacketLogging)) {
                            AELog.info("Unread bytes detected (" + read + "): " + Arrays.toString(left), new Object[0]);
                        }
                    }
                }
            }
        }

        public String toString() {
            return "PacketOverwrite{onlineValid=" + this.onlineValid + ", online=" + this.online + ", itemsValid=" + this.itemsValid + ", allItemUpdate=" + this.allItemUpdate + ", validIndices=" + Arrays.toString(this.validIndices) + ", items=" + this.items + ", entryId=" + this.entryId + '}';
        }
    }

    public static class PacketRename
    extends PacketEntry {
        public String newName;

        protected PacketRename(long id, String newName) {
            super(id);
            this.newName = newName;
        }

        protected PacketRename(ByteBuf buf) throws IOException {
            super(buf);
        }

        @Override
        protected void write(ByteBuf buf) {
            buf.writeByte(PacketType.RENAME.ordinal());
            buf.writeLong(this.entryId);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.newName);
        }

        @Override
        protected void read(ByteBuf buf) {
            this.newName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        public String toString() {
            return "PacketRename{newName='" + this.newName + '\'' + ", entryId=" + this.entryId + '}';
        }
    }

    public static abstract class PacketEntry {
        public final long entryId;

        protected PacketEntry(long entryId) {
            this.entryId = entryId;
        }

        protected PacketEntry(ByteBuf buf) throws IOException {
            this.entryId = buf.readLong();
            this.read(buf);
        }

        protected abstract void write(ByteBuf var1) throws IOException;

        protected abstract void read(ByteBuf var1) throws IOException;
    }
}

