/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.IGuiTooltipHandler;
import appeng.client.gui.widgets.GuiCraftingCPUTable;
import appeng.client.gui.widgets.GuiCraftingTree;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.GuiSimpleImgButton;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.client.gui.widgets.ICraftingCPUTableHolder;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.container.implementations.CraftingCPUStatus;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.crafting.v2.CraftingJobV2;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.integration.modules.NEI;
import appeng.parts.reporting.PartCraftingTerminal;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.parts.reporting.PartPatternTerminalEx;
import appeng.parts.reporting.PartTerminal;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import com.google.common.base.Joiner;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiCraftConfirm
extends AEBaseGui
implements ICraftingCPUTableHolder,
IGuiTooltipHandler {
    public static final int TREE_VIEW_TEXTURE_WIDTH = 238;
    public static final int TREE_VIEW_TEXTURE_HEIGHT = 238;
    public static final int LIST_VIEW_TEXTURE_WIDTH = 238;
    public static final int LIST_VIEW_TEXTURE_HEIGHT = 206;
    public static final int LIST_VIEW_TEXTURE_BELOW_TOP_ROW_Y = 41;
    public static final int LIST_VIEW_TEXTURE_ABOVE_BOTTOM_ROW_Y = 110;
    public static final int LIST_VIEW_TEXTURE_ROW_HEIGHT = 23;
    public static final int LIST_VIEW_TEXTURE_NONROW_HEIGHT = 91;
    private final ContainerCraftConfirm ccc;
    private final GuiCraftingCPUTable cpuTable;
    private final GuiCraftingTree craftingTree;
    private int rows = 5;
    private final IItemList<IAEItemStack> storage = AEApi.instance().storage().createItemList();
    private final IItemList<IAEItemStack> pending = AEApi.instance().storage().createItemList();
    private final IItemList<IAEItemStack> missing = AEApi.instance().storage().createItemList();
    private CraftingJobV2 jobTree = null;
    private final List<IAEItemStack> visual = new ArrayList<IAEItemStack>();
    private DisplayMode displayMode = DisplayMode.LIST;
    private boolean tallMode;
    private GuiBridge OriginalGui;
    private GuiButton cancel;
    private GuiButton start;
    private GuiButton selectCPU;
    private GuiImgButton switchTallMode;
    private GuiSimpleImgButton takeScreenshot;
    private GuiTabButton switchDisplayMode;
    private int tooltip = -1;
    private ItemStack hoveredStack;
    final GuiScrollbar scrollbar;
    Comparator<IAEItemStack> comparator = (i1, i2) -> {
        if (this.missing.findPrecise((IAEItemStack)i1) != null) {
            if (this.missing.findPrecise((IAEItemStack)i2) != null) {
                return 0;
            }
            return -1;
        }
        if (this.missing.findPrecise((IAEItemStack)i2) != null) {
            return 1;
        }
        return 0;
    };

    protected void recalculateScreenSize() {
        switch (this.displayMode) {
            case LIST: {
                int maxAvailableHeight = this.field_146295_m - 64;
                this.field_146999_f = 238;
                if (this.tallMode) {
                    this.rows = (maxAvailableHeight - 91) / 23;
                    this.field_147000_g = 91 + this.rows * 23;
                    break;
                }
                this.rows = 5;
                this.field_147000_g = 206;
                break;
            }
            case TREE: {
                this.field_146999_f = this.tallMode ? this.field_146294_l - 200 : 238;
                this.field_147000_g = this.tallMode ? this.field_146295_m - 64 : 238;
                this.craftingTree.widgetW = this.field_146999_f - 35;
                this.craftingTree.widgetH = this.field_147000_g - 46;
            }
        }
    }

    public GuiCraftConfirm(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(new ContainerCraftConfirm(inventoryPlayer, te));
        this.craftingTree = new GuiCraftingTree(this, 9, 19, 203, 192);
        this.tallMode = AEConfig.instance.getConfigManager().getSetting(Settings.TERMINAL_STYLE) == TerminalStyle.TALL;
        this.recalculateScreenSize();
        this.scrollbar = new GuiScrollbar();
        this.setScrollBar(this.scrollbar);
        this.cpuTable = new GuiCraftingCPUTable(this, ((ContainerCraftConfirm)this.field_147002_h).cpuTable);
        this.ccc = (ContainerCraftConfirm)this.field_147002_h;
        if (te instanceof WirelessTerminalGuiObject) {
            this.OriginalGui = GuiBridge.GUI_WIRELESS_TERM;
        }
        if (te instanceof PartTerminal) {
            this.OriginalGui = GuiBridge.GUI_ME;
        }
        if (te instanceof PartCraftingTerminal) {
            this.OriginalGui = GuiBridge.GUI_CRAFTING_TERMINAL;
        }
        if (te instanceof PartPatternTerminal) {
            this.OriginalGui = GuiBridge.GUI_PATTERN_TERMINAL;
        }
        if (te instanceof PartPatternTerminalEx) {
            this.OriginalGui = GuiBridge.GUI_PATTERN_TERMINAL_EX;
        }
    }

    @Override
    public GuiCraftingCPUTable getCPUTable() {
        return this.cpuTable;
    }

    boolean isAutoStart() {
        return ((ContainerCraftConfirm)this.field_147002_h).isAutoStart();
    }

    @Override
    public void func_73866_w_() {
        this.recalculateScreenSize();
        super.func_73866_w_();
        this.setScrollBar();
        this.start = new GuiButton(0, this.field_147003_i + this.field_146999_f - 76, this.field_147009_r + this.field_147000_g - 25, 50, 20, GuiText.Start.getLocal());
        this.start.field_146124_l = false;
        this.field_146292_n.add(this.start);
        this.selectCPU = new GuiButton(0, this.field_147003_i + 19, this.field_147009_r + this.field_147000_g - 68, 180, 20, GuiText.CraftingCPU.getLocal() + ": " + (Object)((Object)GuiText.Automatic));
        this.selectCPU.field_146124_l = false;
        this.field_146292_n.add(this.selectCPU);
        this.cancel = new GuiButton(0, this.field_147003_i + 6, this.field_147009_r + this.field_147000_g - 25, 50, 20, GuiText.Cancel.getLocal());
        this.field_146292_n.add(this.cancel);
        this.switchTallMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 166, Settings.TERMINAL_STYLE, this.tallMode ? TerminalStyle.TALL : TerminalStyle.SMALL);
        this.field_146292_n.add(this.switchTallMode);
        this.takeScreenshot = new GuiSimpleImgButton(this.field_147003_i - 18, this.field_147009_r + 184, 144, ButtonToolTips.SaveAsImage.getLocal());
        this.field_146292_n.add(this.takeScreenshot);
        this.switchDisplayMode = new GuiTabButton(this.field_147003_i + this.field_146999_f - 25, this.field_147009_r - 4, 211, GuiText.SwitchCraftingSimulationDisplayMode.getLocal(), field_146296_j);
        this.switchDisplayMode.setHideEdge(1);
        this.field_146292_n.add(this.switchDisplayMode);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float btn) {
        CraftingCPUStatus selected;
        this.updateCPUButtonText();
        this.cpuTable.drawScreen();
        boolean bl = this.start.field_146124_l = !this.ccc.hasNoCPU() && !this.isSimulation();
        if (this.start.field_146124_l && ((selected = this.cpuTable.getContainer().getSelectedCPU()) == null || selected.getStorage() < this.ccc.getUsedBytes() || selected.isBusy())) {
            this.start.field_146124_l = false;
        }
        this.selectCPU.field_146124_l = this.displayMode == DisplayMode.LIST && !this.isSimulation();
        this.selectCPU.field_146125_m = this.displayMode == DisplayMode.LIST;
        this.takeScreenshot.field_146125_m = this.displayMode == DisplayMode.TREE;
        super.func_73863_a(mouseX, mouseY, btn);
        switch (this.displayMode) {
            case LIST: {
                this.drawListScreen(mouseX, mouseY, btn);
                break;
            }
            case TREE: {
                this.drawTreeScreen(mouseX, mouseY, btn);
            }
        }
    }

    private void drawListScreen(int mouseX, int mouseY, float btn) {
        int gx = (this.field_146294_l - this.field_146999_f) / 2;
        int gy = (this.field_146295_m - this.field_147000_g) / 2;
        this.tooltip = -1;
        int offY = 23;
        int y = 0;
        int x = 0;
        for (int z = 0; z <= 4 * this.rows; ++z) {
            int minX = gx + 9 + x * 67;
            int minY = gy + 22 + y * 23;
            if (minX < mouseX && minX + 67 > mouseX && minY < mouseY && minY + 23 - 2 > mouseY) {
                this.tooltip = z;
                break;
            }
            if (++x <= 2) continue;
            ++y;
            x = 0;
        }
    }

    private void drawTreeScreen(int mouseX, int mouseY, float btn) {
        this.craftingTree.drawTooltip(mouseX, mouseY);
    }

    private void updateCPUButtonText() {
        String btnTextText = GuiText.CraftingCPU.getLocal() + ": " + GuiText.Automatic.getLocal();
        if (this.ccc.getSelectedCpu() >= 0) {
            if (this.ccc.getName().length() > 0) {
                String name = this.ccc.getName().substring(0, Math.min(20, this.ccc.getName().length()));
                btnTextText = GuiText.CraftingCPU.getLocal() + ": " + name;
            } else {
                btnTextText = GuiText.CraftingCPU.getLocal() + ": #" + this.ccc.getSelectedCpu();
            }
        }
        if (this.ccc.hasNoCPU()) {
            btnTextText = GuiText.NoCraftingCPUs.getLocal();
        }
        this.selectCPU.field_146126_j = btnTextText;
    }

    private boolean isSimulation() {
        return ((ContainerCraftConfirm)this.field_147002_h).isSimulation();
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.cpuTable.drawFG(offsetX, offsetY, mouseX, mouseY, this.field_147003_i, this.field_147009_r);
        long BytesUsed = this.ccc.getUsedBytes();
        String byteUsed = NumberFormat.getInstance().format(BytesUsed);
        String bannerText = this.jobTree != null && !this.jobTree.getErrorMessage().isEmpty() ? StatCollector.func_74838_a((String)this.jobTree.getErrorMessage()) : (BytesUsed > 0L ? byteUsed + ' ' + GuiText.BytesUsed.getLocal() : GuiText.CalculatingWait.getLocal());
        this.field_146289_q.func_78276_b(GuiText.CraftingPlan.getLocal() + " - " + bannerText, 8, 7, GuiColors.CraftConfirmCraftingPlan.getColor());
        switch (this.displayMode) {
            case LIST: {
                this.drawListFG(offsetX, offsetY, mouseX, mouseY);
                break;
            }
            case TREE: {
                this.drawTreeFG(offsetX, offsetY, mouseX, mouseY);
            }
        }
    }

    private void drawListFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        String dsp = null;
        dsp = this.isSimulation() ? GuiText.Simulation.getLocal() : (this.ccc.getCpuAvailableBytes() > 0L ? GuiText.Bytes.getLocal() + ": " + NumberFormat.getInstance().format(this.ccc.getCpuAvailableBytes()) + " : " + GuiText.CoProcessors.getLocal() + ": " + NumberFormat.getInstance().format(this.ccc.getCpuCoProcessors()) : GuiText.Bytes.getLocal() + ": N/A : " + GuiText.CoProcessors.getLocal() + ": N/A");
        int offset = (219 - this.field_146289_q.func_78256_a(dsp)) / 2;
        this.field_146289_q.func_78276_b(dsp, offset, this.field_147000_g - 41, GuiColors.CraftConfirmSimulation.getColor());
        int sectionLength = 67;
        int x = 0;
        int y = 0;
        int xo = 9;
        int yo = 22;
        int viewStart = this.getScrollBar().getCurrentScroll() * 3;
        int viewEnd = viewStart + 3 * this.rows;
        String dspToolTip = "";
        LinkedList<String> lineList = new LinkedList<String>();
        int toolPosX = 0;
        int toolPosY = 0;
        this.hoveredStack = null;
        int offY = 23;
        for (int z = viewStart; z < Math.min(viewEnd, this.visual.size()); ++z) {
            int w;
            IAEItemStack refStack = this.visual.get(z);
            if (refStack == null) continue;
            GL11.glPushMatrix();
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            IAEItemStack stored = this.storage.findPrecise(refStack);
            IAEItemStack pendingStack = this.pending.findPrecise(refStack);
            IAEItemStack missingStack = this.missing.findPrecise(refStack);
            int lines = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                ++lines;
            }
            if (missingStack != null && missingStack.getStackSize() > 0L) {
                ++lines;
            }
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                lines += 2;
            }
            int negY = (lines - 1) * 5 / 2;
            int downY = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                String str = GuiText.FromStorage.getLocal() + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(stored.getStackSize());
                int w2 = 4 + this.field_146289_q.func_78256_a(str);
                this.field_146289_q.func_78276_b(str, (int)(((double)(x * 68 + 9 + 67 - 19) - (double)w2 * 0.5) * 2.0), (y * 23 + 22 + 6 - negY + downY) * 2, GuiColors.CraftConfirmFromStorage.getColor());
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.FromStorage.getLocal() + ": " + NumberFormat.getInstance().format(stored.getStackSize()));
                }
                downY += 5;
            }
            boolean red = false;
            if (missingStack != null && missingStack.getStackSize() > 0L) {
                String str = GuiText.Missing.getLocal() + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(missingStack.getStackSize());
                w = 4 + this.field_146289_q.func_78256_a(str);
                this.field_146289_q.func_78276_b(str, (int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0), (y * 23 + 22 + 6 - negY + downY) * 2, GuiColors.CraftConfirmMissing.getColor());
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.Missing.getLocal() + ": " + NumberFormat.getInstance().format(missingStack.getStackSize()));
                }
                red = true;
                downY += 5;
            }
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                String str = GuiText.ToCraft.getLocal() + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(pendingStack.getStackSize());
                w = 4 + this.field_146289_q.func_78256_a(str);
                this.field_146289_q.func_78276_b(str, (int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0), (y * 23 + 22 + 6 - negY + downY) * 2, GuiColors.CraftConfirmToCraft.getColor());
                str = GuiText.ToCraftRequests.getLocal() + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(pendingStack.getCountRequestableCrafts());
                w = 4 + this.field_146289_q.func_78256_a(str);
                this.field_146289_q.func_78276_b(str, (int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0), (y * 23 + 22 + 6 - negY + (downY += 5)) * 2, GuiColors.CraftConfirmToCraft.getColor());
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.ToCraft.getLocal() + ": " + NumberFormat.getInstance().format(pendingStack.getStackSize()));
                    lineList.add(GuiText.ToCraftRequests.getLocal() + ": " + NumberFormat.getInstance().format(pendingStack.getCountRequestableCrafts()));
                }
            }
            GL11.glPopMatrix();
            int posX = x * 68 + 9 + 67 - 19;
            int posY = y * 23 + 22;
            ItemStack is = refStack.copy().getItemStack();
            if (this.tooltip == z - viewStart) {
                dspToolTip = Platform.getItemDisplayName(is);
                if (lineList.size() > 0) {
                    this.addItemTooltip(is, lineList);
                    dspToolTip = dspToolTip + '\n' + Joiner.on((String)"\n").join(lineList);
                }
                toolPosX = x * 68 + 9 + 67 - 8;
                toolPosY = y * 23 + 22;
                this.hoveredStack = is;
            }
            this.drawItem(posX, posY, is);
            if (red) {
                int startX = x * 68 + 9;
                int startY = posY - 4;
                GuiCraftConfirm.func_73734_a((int)startX, (int)startY, (int)(startX + 67), (int)(startY + 23), (int)GuiColors.CraftConfirmMissingItem.getColor());
            }
            if (++x <= 2) continue;
            ++y;
            x = 0;
        }
        if (this.tooltip >= 0 && dspToolTip.length() > 0) {
            this.drawTooltip(toolPosX, toolPosY + 10, 0, dspToolTip);
        }
    }

    private void drawTreeFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        CraftingJobV2 jobTree = this.jobTree;
        if (jobTree == null) {
            this.drawTooltip(16, 48, 0, GuiText.NoCraftingTreeReceived.getLocal());
            return;
        }
        if (jobTree.getOutput() == null) {
            this.drawTooltip(16, 48, 0, GuiText.Nothing.getLocal());
            return;
        }
        this.craftingTree.setRequest(jobTree.originalRequest);
        this.craftingTree.draw(mouseX, mouseY);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.cpuTable.drawBG(offsetX, offsetY);
        this.setScrollBar();
        switch (this.displayMode) {
            case LIST: {
                this.bindTexture("guis/craftingreport.png");
                if (this.tallMode) {
                    this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, 41);
                    int y = 41;
                    for (int row = 1; row < this.rows - 1; ++row) {
                        this.func_73729_b(offsetX, offsetY + y, 0, 41, this.field_146999_f, 23);
                        y += 23;
                    }
                    this.func_73729_b(offsetX, offsetY + y, 0, 110, this.field_146999_f, 96);
                    break;
                }
                this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
                break;
            }
            case TREE: {
                this.bindTexture("guis/craftingtree.png");
                this.drawTextured9PatchRect(offsetX, offsetY, this.field_146999_f, this.field_147000_g, 0, 0, 238, 238);
            }
        }
    }

    private void setScrollBar() {
        switch (this.displayMode) {
            case LIST: {
                if (this.getScrollBar() == null) {
                    this.setScrollBar(this.scrollbar);
                }
                int size = this.visual.size();
                this.getScrollBar().setTop(19).setLeft(218).setHeight(this.field_147000_g - 92);
                this.getScrollBar().setRange(0, (size + 2) / 3 - this.rows, 1);
                break;
            }
            case TREE: {
                if (this.getScrollBar() == null) break;
                this.setScrollBar(null);
            }
        }
    }

    public void postUpdate(List<IAEItemStack> list, byte ref) {
        switch (ref) {
            case 0: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.storage, l);
                }
                break;
            }
            case 1: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.pending, l);
                }
                break;
            }
            case 2: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.missing, l);
                }
                break;
            }
        }
        for (IAEItemStack l : list) {
            long amt = this.getTotal(l);
            if (amt <= 0L) {
                this.deleteVisualStack(l);
                continue;
            }
            IAEItemStack is = this.findVisualStack(l);
            is.setStackSize(amt);
        }
        this.sortItems();
        this.setScrollBar();
    }

    public void setJobTree(CraftingJobV2 jobTree) {
        this.jobTree = jobTree;
    }

    private void sortItems() {
        if (!this.missing.isEmpty()) {
            this.visual.sort(this.comparator);
        }
    }

    private void handleInput(IItemList<IAEItemStack> s, IAEItemStack l) {
        IAEItemStack a = s.findPrecise(l);
        if (l.getStackSize() <= 0L) {
            if (a != null) {
                a.reset();
            }
        } else {
            if (a == null) {
                s.add(l.copy());
                a = s.findPrecise(l);
            }
            if (a != null) {
                a.setStackSize(l.getStackSize());
            }
        }
    }

    @Override
    protected boolean mouseWheelEvent(int x, int y, int wheel) {
        if (this.displayMode == DisplayMode.TREE && this.craftingTree != null && this.craftingTree.isPointInWidget(x - this.field_147003_i, y - this.field_147009_r)) {
            this.craftingTree.onMouseWheel(x - this.field_147003_i, y - this.field_147009_r, wheel);
            return true;
        }
        return super.mouseWheelEvent(x, y, wheel);
    }

    private long getTotal(IAEItemStack is) {
        IAEItemStack a = this.storage.findPrecise(is);
        IAEItemStack c = this.pending.findPrecise(is);
        IAEItemStack m = this.missing.findPrecise(is);
        long total = 0L;
        if (a != null) {
            total += a.getStackSize();
        }
        if (c != null) {
            total += c.getStackSize();
        }
        if (m != null) {
            total += m.getStackSize();
        }
        return total;
    }

    private void deleteVisualStack(IAEItemStack l) {
        Iterator<IAEItemStack> i = this.visual.iterator();
        while (i.hasNext()) {
            IAEItemStack o = i.next();
            if (!o.equals(l)) continue;
            i.remove();
            return;
        }
    }

    private IAEItemStack findVisualStack(IAEItemStack l) {
        for (IAEItemStack o : this.visual) {
            if (!o.equals(l)) continue;
            return o;
        }
        IAEItemStack stack = l.copy();
        this.visual.add(stack);
        return stack;
    }

    protected void func_73869_a(char character, int key) {
        if (!this.func_146983_a(key)) {
            if (key == 28 || key == 156) {
                this.func_146284_a(this.start);
            }
            super.func_73869_a(character, key);
        }
    }

    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        if (btn == this.selectCPU) {
            this.cpuTable.cycleCPU(backwards);
        } else if (btn == this.cancel) {
            this.addMissingItemsToBookMark();
            this.switchToOriginalGUI();
        } else if (btn == this.switchDisplayMode) {
            this.displayMode = this.displayMode.next();
            this.recalculateScreenSize();
            this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        } else if (btn == this.switchTallMode) {
            this.tallMode = !this.tallMode;
            this.switchTallMode.set(this.tallMode ? TerminalStyle.TALL : TerminalStyle.SMALL);
            this.recalculateScreenSize();
            this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        } else if (btn == this.takeScreenshot) {
            if (this.craftingTree != null) {
                this.craftingTree.saveScreenshot();
            }
        } else if (btn == this.start) {
            try {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("Terminal.Start", "Start"));
            }
            catch (Throwable e) {
                AELog.debug(e);
            }
        }
    }

    public void switchToOriginalGUI() {
        if (this.OriginalGui != null) {
            NetworkHandler.instance.sendToServer(new PacketSwitchGuis(this.OriginalGui));
        }
    }

    @Override
    public ItemStack getHoveredStack() {
        return this.hoveredStack;
    }

    public GuiButton getCancelButton() {
        return this.cancel;
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        super.func_73864_a(xCoord, yCoord, btn);
        this.cpuTable.mouseClicked(xCoord - this.field_147003_i, yCoord - this.field_147009_r, btn);
    }

    @Override
    protected void func_146273_a(int x, int y, int c, long d) {
        super.func_146273_a(x, y, c, d);
        this.cpuTable.mouseClickMove(x - this.field_147003_i, y - this.field_147009_r);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
    }

    @Override
    public void func_146274_d() {
        if (this.cpuTable.handleMouseInput(this.field_147003_i, this.field_147009_r)) {
            return;
        }
        super.func_146274_d();
    }

    public boolean hideItemPanelSlot(int x, int y, int w, int h) {
        return this.cpuTable.hideItemPanelSlot(x - this.field_147003_i, y - this.field_147009_r, w, h);
    }

    protected void addMissingItemsToBookMark() {
        if (!this.missing.isEmpty() && GuiCraftConfirm.func_146272_n()) {
            for (IAEItemStack iaeItemStack : this.missing) {
                NEI.instance.addItemToBookMark(iaeItemStack.getItemStack());
            }
        }
    }

    public IItemList<IAEItemStack> getStorage() {
        return this.storage;
    }

    public IItemList<IAEItemStack> getPending() {
        return this.pending;
    }

    public IItemList<IAEItemStack> getMissing() {
        return this.missing;
    }

    public static enum DisplayMode {
        LIST,
        TREE;


        public DisplayMode next() {
            DisplayMode displayMode;
            switch (this) {
                case LIST: {
                    displayMode = TREE;
                    break;
                }
                case TREE: {
                    displayMode = LIST;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(this.toString());
                }
            }
            return displayMode;
        }
    }
}

