/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.NEIHelpers;

import appeng.api.AEApi;
import appeng.api.features.IGrinderEntry;
import appeng.client.gui.implementations.GuiGrinder;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class NEIGrinderRecipeHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "grindstone", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("grindstone") && ((Object)((Object)this)).getClass() == NEIGrinderRecipeHandler.class) {
            for (IGrinderEntry recipe : AEApi.instance().registries().grinder().getRecipes()) {
                CachedGrindStoneRecipe cachedRecipe = new CachedGrindStoneRecipe(recipe);
                cachedRecipe.computeVisuals();
                this.arecipes.add(cachedRecipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IGrinderEntry recipe : AEApi.instance().registries().grinder().getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            CachedGrindStoneRecipe cachedRecipe = new CachedGrindStoneRecipe(recipe);
            cachedRecipe.computeVisuals();
            this.arecipes.add(cachedRecipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IGrinderEntry recipe : AEApi.instance().registries().grinder().getRecipes()) {
            CachedGrindStoneRecipe cachedRecipe = new CachedGrindStoneRecipe(recipe);
            if (!cachedRecipe.contains(cachedRecipe.ingredients, ingredient.func_77973_b())) continue;
            cachedRecipe.computeVisuals();
            if (!cachedRecipe.contains(cachedRecipe.ingredients, ingredient)) continue;
            cachedRecipe.setIngredientPermutation(cachedRecipe.ingredients, ingredient);
            this.arecipes.add(cachedRecipe);
        }
    }

    public String getGuiTexture() {
        ResourceLocation loc = new ResourceLocation("appliedenergistics2", "textures/guis/grinder.png");
        return loc.toString();
    }

    public String getOverlayIdentifier() {
        return "grindstone";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiGrinder.class;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)40, (int)10, (int)75, (int)26, (int)90, (int)66);
    }

    public void drawForeground(int recipe) {
        TemplateRecipeHandler.CachedRecipe cr;
        super.drawForeground(recipe);
        if (this.arecipes.size() > recipe && (cr = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)) instanceof CachedGrindStoneRecipe) {
            CachedGrindStoneRecipe cachedRecipe = (CachedGrindStoneRecipe)cr;
            if (cachedRecipe.hasOptional) {
                FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                int width = fr.func_78256_a(cachedRecipe.displayChance);
                fr.func_78276_b(cachedRecipe.displayChance, (168 - width) / 2, 5, GuiColors.NEIGrindstoneRecipeChance.getColor());
            } else {
                FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                int width = fr.func_78256_a(GuiText.NoSecondOutput.getLocal());
                fr.func_78276_b(GuiText.NoSecondOutput.getLocal(), (168 - width) / 2, 5, GuiColors.NEIGrindstoneNoSecondOutput.getColor());
            }
        }
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        return null;
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        return null;
    }

    public String getRecipeName() {
        return GuiText.GrindStone.getLocal();
    }

    private class CachedGrindStoneRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> ingredients;
        private final PositionedStack result;
        private String displayChance;
        private boolean hasOptional;

        public CachedGrindStoneRecipe(IGrinderEntry recipe) {
            super((TemplateRecipeHandler)NEIGrinderRecipeHandler.this);
            this.hasOptional = false;
            this.result = new PositionedStack((Object)recipe.getOutput(), 77, 47);
            this.ingredients = new ArrayList<PositionedStack>();
            ItemStack optionalOutput = recipe.getOptionalOutput();
            int optionalChancePercent = (int)(recipe.getOptionalChance() * 100.0f);
            if (optionalOutput != null) {
                this.hasOptional = true;
                this.displayChance = String.format(GuiText.OfSecondOutput.getLocal(), optionalChancePercent);
                this.ingredients.add(new PositionedStack((Object)optionalOutput, 95, 47));
            }
            ItemStack secondOptionalOutput = recipe.getSecondOptionalOutput();
            int secondOptionalChancePercent = (int)(recipe.getSecondOptionalChance() * 100.0f);
            if (secondOptionalOutput != null) {
                this.hasOptional = true;
                this.displayChance = String.format(GuiText.MultipleOutputs.getLocal(), optionalChancePercent, secondOptionalChancePercent);
                this.ingredients.add(new PositionedStack((Object)secondOptionalOutput, 113, 47));
            }
            if (recipe.getInput() != null) {
                this.ingredients.add(new PositionedStack((Object)recipe.getInput(), 45, 24));
            }
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIGrinderRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        private void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
            this.result.generatePermutations();
        }
    }
}

