/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.v2;

import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AELog;
import appeng.crafting.MECraftingInventory;
import appeng.crafting.v2.CraftingContext;
import appeng.crafting.v2.CraftingRequest;
import appeng.crafting.v2.resolvers.CraftingTask;
import appeng.hooks.TickHandler;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class CraftingJobV2
implements ICraftingJob,
Future<ICraftingJob> {
    protected volatile long totalByteCost = -1L;
    protected CraftingContext context;
    protected final CraftingRequest<IAEItemStack> originalRequest;
    protected ICraftingCallback callback;
    protected State state = State.RUNNING;

    public CraftingJobV2(World world, IGrid meGrid, BaseActionSource actionSource, IAEItemStack what, ICraftingCallback callback) {
        this.context = new CraftingContext(world, meGrid, actionSource);
        this.callback = callback;
        this.originalRequest = new CraftingRequest<IAEItemStack>(what, CraftingRequest.SubstitutionMode.PRECISE_FRESH, IAEItemStack.class, true);
        this.context.addRequest(this.originalRequest);
        this.context.itemModel.ignore(what);
    }

    @Override
    public boolean isSimulation() {
        return this.context.wasSimulated;
    }

    @Override
    public long getByteTotal() {
        long byteCost = this.totalByteCost;
        if (byteCost < 0L) {
            byteCost = 0L;
            for (CraftingContext.RequestInProcessing<?> request : this.context.getLiveRequests()) {
                byteCost += request.request.getByteCost();
            }
            this.totalByteCost = byteCost;
        }
        return byteCost;
    }

    @Override
    public void populatePlan(IItemList<IAEItemStack> plan) {
        for (CraftingTask task : this.context.getResolvedTasks()) {
            task.populatePlan(plan);
        }
    }

    @Override
    public IAEItemStack getOutput() {
        return (IAEItemStack)this.originalRequest.stack;
    }

    @Override
    public boolean simulateFor(int milli) {
        if (this.state != State.RUNNING) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        long finishTime = startTime + (long)milli;
        CraftingTask.State taskState = CraftingTask.State.NEEDS_MORE_WORK;
        try {
            do {
                taskState = this.context.doWork();
                this.totalByteCost = -1L;
            } while (taskState.needsMoreWork && System.currentTimeMillis() < finishTime && this.state == State.RUNNING);
        }
        catch (Exception e) {
            AELog.error(e, "Error while simulating crafting for " + this.originalRequest);
            this.state = State.CANCELLED;
            if (this.callback != null) {
                this.callback.calculationComplete(this);
            }
            return false;
        }
        if (!taskState.needsMoreWork) {
            this.getByteTotal();
            this.state = State.FINISHED;
            if (AELog.isCraftingDebugLogEnabled()) {
                AELog.log(Level.INFO, "Crafting job for %s finished with resolved steps:", this.originalRequest.toString());
                AELog.logSimple(Level.INFO, this.context.toString());
            }
            if (this.callback != null) {
                this.callback.calculationComplete(this);
            }
        }
        return taskState.needsMoreWork;
    }

    @Override
    public Future<ICraftingJob> schedule() {
        TickHandler.INSTANCE.registerCraftingSimulation(this.context.world, this);
        return this;
    }

    @Override
    public boolean supportsCPUCluster(ICraftingCPU cluster) {
        return cluster instanceof CraftingCPUCluster;
    }

    @Override
    public void startCrafting(MECraftingInventory storage, ICraftingCPU rawCluster, BaseActionSource src) {
        if (this.state == State.RUNNING) {
            throw new IllegalStateException("Trying to start crafting a not fully calculated job for " + this.originalRequest.toString());
        }
        CraftingCPUCluster cluster = (CraftingCPUCluster)rawCluster;
        this.context.actionSource = src;
        List<CraftingTask> resolvedTasks = this.context.getResolvedTasks();
        for (CraftingTask task : resolvedTasks) {
            task.startOnCpu(this.context, cluster, storage);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.state != State.RUNNING) {
            return false;
        }
        this.state = State.CANCELLED;
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.state == State.CANCELLED;
    }

    @Override
    public boolean isDone() {
        return this.state != State.RUNNING;
    }

    @Override
    public CraftingJobV2 get() throws InterruptedException, ExecutionException {
        this.simulateFor(Integer.MAX_VALUE);
        return this;
    }

    @Override
    public CraftingJobV2 get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            this.simulateFor((int)unit.convert(timeout, TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        switch (this.state) {
            case RUNNING: {
                throw new TimeoutException();
            }
            case CANCELLED: {
                throw new InterruptedException();
            }
            case FINISHED: {
                return this;
            }
        }
        throw new IllegalStateException();
    }

    protected static enum State {
        RUNNING,
        FINISHED,
        CANCELLED;

    }
}

