/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.powersink;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.integration.IntegrationType;
import appeng.tile.powersink.AERootPoweredTile;
import appeng.transformer.annotations.Integration;
import gregtech.api.interfaces.tileentity.IEnergyConnected;

@Integration.Interface(iname=IntegrationType.GT, iface="gregtech.api.interfaces.tileentity.IEnergyConnected")
public abstract class GTPowerSink
extends AERootPoweredTile
implements IEnergyConnected {
    public long injectEnergyUnits(byte side, long voltage, long amperage) {
        double e = PowerUnits.EU.convertTo(PowerUnits.AE, voltage * amperage);
        double overflow = this.funnelPowerIntoStorage(e, Actionable.SIMULATE);
        if (overflow >= e) {
            return 0L;
        }
        long used = amperage - (long)((int)Math.ceil(PowerUnits.AE.convertTo(PowerUnits.EU, overflow) / (double)voltage));
        if (used > 0L) {
            e = PowerUnits.EU.convertTo(PowerUnits.AE, voltage * used);
            this.funnelPowerIntoStorage(e, Actionable.MODULATE);
        } else if (used < 0L) {
            used = 0L;
        }
        return used;
    }

    public boolean inputEnergyFrom(byte b) {
        return true;
    }

    public boolean outputsEnergyTo(byte b) {
        return false;
    }

    public byte getColorization() {
        return -1;
    }

    public byte setColorization(byte b) {
        return -1;
    }
}

