/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.texture.CableBusTextures;
import appeng.core.sync.GuiBridge;
import appeng.helpers.PatternHelper;
import appeng.parts.reporting.AbstractPartTerminal;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.BiggerAppEngInventory;
import appeng.tile.inventory.InvOperation;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PartPatternTerminalEx
extends AbstractPartTerminal {
    private static final CableBusTextures FRONT_BRIGHT_ICON = CableBusTextures.PartPatternTerm_Bright;
    private static final CableBusTextures FRONT_DARK_ICON = CableBusTextures.PartPatternTerm_Dark;
    private static final CableBusTextures FRONT_COLORED_ICON = CableBusTextures.PartPatternTerm_Colored;
    private final AppEngInternalInventory crafting = new BiggerAppEngInventory(this, 32);
    private final AppEngInternalInventory output = new BiggerAppEngInventory(this, 32);
    private final AppEngInternalInventory pattern = new AppEngInternalInventory(this, 2);
    private boolean substitute = false;
    private boolean beSubstitute = false;
    private boolean inverted = false;
    private int activePage = 0;

    public PartPatternTerminalEx(ItemStack is) {
        super(is);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack is : this.pattern) {
            if (is == null) continue;
            drops.add(is);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.pattern.readFromNBT(data, "pattern");
        this.output.readFromNBT(data, "outputList");
        this.crafting.readFromNBT(data, "craftingGrid");
        this.setSubstitution(data.func_74767_n("substitute"));
        this.setCanBeSubstitution(data.func_74767_n("beSubstitute"));
        this.setInverted(data.func_74767_n("inverted"));
        this.setActivePage(data.func_74762_e("activePage"));
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.pattern.writeToNBT(data, "pattern");
        this.output.writeToNBT(data, "outputList");
        this.crafting.writeToNBT(data, "craftingGrid");
        data.func_74757_a("substitute", this.substitute);
        data.func_74757_a("beSubstitute", this.beSubstitute);
        data.func_74757_a("inverted", this.inverted);
        data.func_74768_a("activePage", this.activePage);
    }

    @Override
    public GuiBridge getGui(EntityPlayer p) {
        int x = (int)p.field_70165_t;
        int y = (int)p.field_70163_u;
        int z = (int)p.field_70161_v;
        if (this.getHost().getTile() != null) {
            x = this.getTile().field_145851_c;
            y = this.getTile().field_145848_d;
            z = this.getTile().field_145849_e;
        }
        if (GuiBridge.GUI_PATTERN_TERMINAL_EX.hasPermissions(this.getHost().getTile(), x, y, z, this.getSide(), p)) {
            return GuiBridge.GUI_PATTERN_TERMINAL_EX;
        }
        return GuiBridge.GUI_ME;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        ItemStack stack;
        if (inv == this.pattern && slot == 1 && (stack = this.pattern.func_70301_a(1)) != null && stack.func_77973_b() instanceof ICraftingPatternItem) {
            ICraftingPatternItem pattern = (ICraftingPatternItem)stack.func_77973_b();
            NBTTagCompound encodedValue = stack.func_77978_p();
            if (encodedValue != null) {
                int x;
                IAEItemStack[] outItems;
                IAEItemStack[] inItems;
                ICraftingPatternDetails details = pattern.getPatternForItem(stack, this.getHost().getTile().func_145831_w());
                boolean substitute = encodedValue.func_74767_n("substitute");
                int inputsCount = 0;
                int outputCount = 0;
                if (details == null) {
                    inItems = PatternHelper.loadIAEItemStackFromNBT(encodedValue.func_150295_c("in", 10), true, null);
                    outItems = PatternHelper.loadIAEItemStackFromNBT(encodedValue.func_150295_c("out", 10), false, null);
                } else {
                    inItems = details.getInputs();
                    outItems = details.getOutputs();
                }
                for (x = 0; x < inItems.length; ++x) {
                    if (inItems[x] == null) continue;
                    ++inputsCount;
                }
                for (x = 0; x < outItems.length; ++x) {
                    if (outItems[x] == null) continue;
                    ++outputCount;
                }
                this.setSubstitution(substitute);
                this.setInverted(inputsCount <= 8 && outputCount >= 8);
                this.setActivePage(0);
                for (x = 0; x < this.crafting.func_70302_i_(); ++x) {
                    this.crafting.func_70299_a(x, null);
                }
                for (x = 0; x < this.output.func_70302_i_(); ++x) {
                    this.output.func_70299_a(x, null);
                }
                for (x = 0; x < this.crafting.func_70302_i_() && x < inItems.length; ++x) {
                    if (inItems[x] == null) continue;
                    this.crafting.func_70299_a(x, inItems[x].getItemStack());
                }
                if (this.inverted) {
                    for (x = 0; x < this.output.func_70302_i_() && x < outItems.length; ++x) {
                        if (outItems[x] == null) continue;
                        this.output.func_70299_a(x, outItems[x].getItemStack());
                    }
                } else {
                    for (x = 0; x < outItems.length && x < 8; ++x) {
                        this.output.func_70299_a(x >= 4 ? 12 + x : x, outItems[x].getItemStack());
                    }
                }
            }
        }
        this.getHost().markForSave();
    }

    public boolean isSubstitution() {
        return this.substitute;
    }

    public boolean canBeSubstitution() {
        return this.beSubstitute;
    }

    public void setSubstitution(boolean canSubstitute) {
        this.substitute = canSubstitute;
    }

    public void setCanBeSubstitution(boolean beSubstitute) {
        this.beSubstitute = beSubstitute;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.crafting;
        }
        if (name.equals("output")) {
            return this.output;
        }
        if (name.equals("pattern")) {
            return this.pattern;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public CableBusTextures getFrontBright() {
        return FRONT_BRIGHT_ICON;
    }

    @Override
    public CableBusTextures getFrontColored() {
        return FRONT_COLORED_ICON;
    }

    @Override
    public CableBusTextures getFrontDark() {
        return FRONT_DARK_ICON;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public int getActivePage() {
        return this.activePage;
    }

    public void setActivePage(int activePage) {
        this.activePage = activePage;
    }
}

