/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.layers;

import appeng.api.parts.IPart;
import appeng.api.parts.LayerBase;
import appeng.integration.IntegrationType;
import appeng.parts.p2p.IPartGT5Power;
import appeng.transformer.annotations.Integration;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@Integration.Interface(iname=IntegrationType.GT, iface="gregtech.api.interfaces.tileentity.IEnergyConnected")
public class LayerIEnergyConnected
extends LayerBase
implements IEnergyConnected {
    public long injectEnergyUnits(byte side, long voltage, long amperage) {
        TileEntity source;
        IPart part = this.getPart(ForgeDirection.getOrientation((int)side));
        if (part instanceof IPartGT5Power) {
            return ((IPartGT5Power)((Object)part)).injectEnergyUnits(voltage, amperage);
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        if (part instanceof IEnergySink && (source = this.getTileEntityAtSide(side)) != null && ((IEnergySink)part).acceptsEnergyFrom(source, dir)) {
            long rUsedAmperes;
            for (rUsedAmperes = 0L; amperage > rUsedAmperes && ((IEnergySink)part).getDemandedEnergy() > 0.0 && ((IEnergySink)part).injectEnergy(dir, (double)voltage, (double)voltage) < (double)voltage; ++rUsedAmperes) {
            }
            return rUsedAmperes;
        }
        return 0L;
    }

    public boolean inputEnergyFrom(byte side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        IPart part = this.getPart(dir);
        if (part instanceof IPartGT5Power) {
            return ((IPartGT5Power)((Object)part)).inputEnergy();
        }
        if (!(part instanceof IEnergySink)) {
            return false;
        }
        TileEntity source = this.getTileEntityAtSide(side);
        return source != null && ((IEnergySink)part).acceptsEnergyFrom(source, dir);
    }

    public boolean inputEnergyFrom(byte side, boolean q) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        IPart part = this.getPart(dir);
        if (part instanceof IPartGT5Power) {
            return ((IPartGT5Power)((Object)part)).inputEnergy();
        }
        if (!(part instanceof IEnergySink)) {
            return false;
        }
        TileEntity source = this.getTileEntityAtSide(side);
        return source != null && ((IEnergySink)part).acceptsEnergyFrom(source, dir);
    }

    public boolean outputsEnergyTo(byte side) {
        IPart part = this.getPart(ForgeDirection.getOrientation((int)side));
        return part instanceof IPartGT5Power && ((IPartGT5Power)((Object)part)).outputsEnergy();
    }

    public boolean outputsEnergyTo(byte side, boolean q) {
        IPart part = this.getPart(ForgeDirection.getOrientation((int)side));
        return part instanceof IPartGT5Power && ((IPartGT5Power)((Object)part)).outputsEnergy();
    }

    public byte getColorization() {
        return -1;
    }

    public byte setColorization(byte b) {
        return -1;
    }

    private int getOffsetX(byte aSide, int aMultiplier) {
        return this.field_145851_c + ForgeDirection.getOrientation((int)aSide).offsetX * aMultiplier;
    }

    private short getOffsetY(byte aSide, int aMultiplier) {
        return (short)(this.field_145848_d + ForgeDirection.getOrientation((int)aSide).offsetY * aMultiplier);
    }

    private int getOffsetZ(byte aSide, int aMultiplier) {
        return this.field_145849_e + ForgeDirection.getOrientation((int)aSide).offsetZ * aMultiplier;
    }

    private boolean crossedChunkBorder(int aX, int aZ) {
        return aX >> 4 != this.field_145851_c >> 4 || aZ >> 4 != this.field_145849_e >> 4;
    }

    private final TileEntity getTileEntityAtSide(byte aSide) {
        int tX = this.getOffsetX(aSide, 1);
        short tY = this.getOffsetY(aSide, 1);
        int tZ = this.getOffsetZ(aSide, 1);
        return this.crossedChunkBorder(tX, tZ) && !this.field_145850_b.func_72899_e(tX, (int)tY, tZ) ? null : this.field_145850_b.func_147438_o(tX, (int)tY, tZ);
    }
}

