/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.me.storage.VoidCellInventory;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ItemVoidStorageCell
extends AEBaseItem
implements ICellWorkbenchItem {
    public ItemVoidStorageCell() {
        this.setFeature(EnumSet.of(AEFeature.StorageCells));
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        lines.add(GuiText.VoidCellTooltip.getLocal());
        lines.add("0 " + GuiText.Of.getLocal() + " \u00a7k9999\u00a77 " + GuiText.BytesUsed.getLocal());
        VoidCellInventory inv = (VoidCellInventory)VoidCellInventory.getCell(stack);
        if (inv != null && stack.func_77973_b() instanceof ItemVoidStorageCell) {
            ItemVoidStorageCell cell = (ItemVoidStorageCell)stack.func_77973_b();
            if (inv.isPreformatted()) {
                String filter = cell.getOreFilter(stack);
                if (filter.isEmpty()) {
                    String list = (inv.getWhitelist() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
                    if (inv.isFuzzy()) {
                        lines.add(GuiText.Partitioned.getLocal() + " - " + list + ' ' + GuiText.Fuzzy.getLocal());
                    } else {
                        lines.add(GuiText.Partitioned.getLocal() + " - " + list + ' ' + GuiText.Precise.getLocal());
                    }
                    if (GuiScreen.func_146272_n()) {
                        lines.add(GuiText.Filter.getLocal() + ": ");
                        for (int i = 0; i < cell.getConfigInventory(stack).func_70302_i_(); ++i) {
                            ItemStack s = cell.getConfigInventory(stack).func_70301_a(i);
                            if (s == null) continue;
                            lines.add(s.func_82833_r());
                        }
                    }
                } else {
                    lines.add(GuiText.PartitionedOre.getLocal() + " : " + filter);
                }
            }
        }
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData(is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData(is).func_74778_a("FuzzyMode", fzMode.name());
    }

    @Override
    public String getOreFilter(ItemStack is) {
        return Platform.openNbtData(is).func_74779_i("OreFilter");
    }

    @Override
    public void setOreFilter(ItemStack is, String filter) {
        Platform.openNbtData(is).func_74778_a("OreFilter", filter);
    }
}

