/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.exceptions.MissingDefinition;
import appeng.core.features.AEFeature;
import appeng.items.materials.MaterialType;
import appeng.items.storage.ItemBasicStorageCell;
import com.google.common.base.Optional;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.item.ItemStack;

public class ItemAdvancedStorageCell
extends ItemBasicStorageCell {
    public ItemAdvancedStorageCell(MaterialType whichCell, long kilobytes) {
        super((Optional<String>)Optional.of((Object)(kilobytes + "k")));
        this.setFeature(EnumSet.of(AEFeature.StorageCells));
        this.func_77625_d(1);
        this.totalBytes = kilobytes * 1024L;
        this.component = whichCell;
        switch (this.component) {
            case Cell256kPart: {
                this.idleDrain = 2.5;
                this.perType = 2048;
                break;
            }
            case Cell1024kPart: {
                this.idleDrain = 3.0;
                this.perType = 8192;
                break;
            }
            case Cell4096kPart: {
                this.idleDrain = 3.5;
                this.perType = 32768;
                break;
            }
            case Cell16384kPart: {
                this.idleDrain = 4.0;
                this.perType = 131072;
                break;
            }
            default: {
                this.idleDrain = 0.0;
                this.perType = 8;
            }
        }
    }

    @Override
    protected IItemDefinition getStorageCellCase() {
        return AEApi.instance().definitions().materials().emptyAdvancedStorageCell();
    }

    @Override
    public ItemStack getContainerItem(ItemStack itemStack) {
        Iterator iterator = AEApi.instance().definitions().materials().emptyAdvancedStorageCell().maybeStack(1).asSet().iterator();
        if (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            return stack;
        }
        throw new MissingDefinition("Tried to use empty storage cells while basic storage cells are defined.");
    }
}

