/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.networking.IGridHost;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.client.gui.implementations.GuiCraftingCPU;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftingStatus;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.core.sync.network.NetworkHandler;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketCraftingRemainingOperations
extends AppEngPacket {
    private int remainingOperations;

    public PacketCraftingRemainingOperations(ByteBuf stream) throws IOException {
        this.remainingOperations = stream.readInt();
    }

    public PacketCraftingRemainingOperations(int remainingOperations) throws IOException {
        this.remainingOperations = remainingOperations;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(remainingOperations);
        this.configureWrite(data);
    }

    public PacketCraftingRemainingOperations() throws IOException {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(0);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        ICraftingCPU cpu;
        ContainerOpenContext context;
        ContainerCraftingStatus cpv;
        Object target;
        if (player.field_71070_bA instanceof ContainerCraftingStatus && (target = (cpv = (ContainerCraftingStatus)player.field_71070_bA).getTarget()) instanceof IGridHost && (context = cpv.getOpenContext()) != null && (cpu = cpv.getCPUTable().getSelectedCPU().getServerCluster()) instanceof CraftingCPUCluster) {
            try {
                NetworkHandler.instance.sendTo(new PacketCraftingRemainingOperations(((CraftingCPUCluster)cpu).getRemainingOperations()), (EntityPlayerMP)player);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
        if (gs instanceof GuiCraftingCPU) {
            ((GuiCraftingCPU)gs).postUpdate(this.remainingOperations);
        }
    }
}

