/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.integration.IntegrationType;
import appeng.integration.modules.helpers.NullRFHandler;
import appeng.me.GridAccessException;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.transformer.annotations.Integration;
import appeng.util.Platform;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Stack;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@Integration.InterfaceList(value={@Integration.Interface(iface="cofh.api.energy.IEnergyReceiver", iname=IntegrationType.RF)})
public final class PartP2PRFPower
extends PartP2PTunnel<PartP2PRFPower>
implements IEnergyReceiver {
    private static final ThreadLocal<Stack<PartP2PRFPower>> THREAD_STACK = new ThreadLocal();
    private static final IEnergyReceiver NULL_HANDLER = new NullRFHandler();
    private boolean cachedTarget = false;
    private IEnergyReceiver outputTarget;

    public PartP2PRFPower(ItemStack is) {
        super(is);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTypeTexture() {
        return Blocks.field_150339_S.func_149733_h(0);
    }

    @Override
    public void onTunnelNetworkChange() {
        this.getHost().notifyNeighbors();
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.cachedTarget = false;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.isOutput()) {
            return 0;
        }
        if (this.isActive()) {
            Stack<PartP2PRFPower> stack = this.getDepth();
            for (PartP2PRFPower t : stack) {
                if (t != this) continue;
                return 0;
            }
            stack.push(this);
            int total = 0;
            try {
                int receiver;
                for (PartP2PRFPower t : this.getOutputs()) {
                    if (Platform.getRandomInt() % 2 <= 0) continue;
                    receiver = t.getOutput().receiveEnergy(t.getSide().getOpposite(), maxReceive, simulate);
                    total += receiver;
                    if ((maxReceive -= receiver) > 0) continue;
                    break;
                }
                if (maxReceive > 0) {
                    for (PartP2PRFPower t : this.getOutputs()) {
                        receiver = t.getOutput().receiveEnergy(t.getSide().getOpposite(), maxReceive, simulate);
                        total += receiver;
                        if ((maxReceive -= receiver) > 0) continue;
                        break;
                    }
                }
                this.queueTunnelDrain(PowerUnits.RF, total);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            if (stack.pop() != this) {
                throw new IllegalStateException("Invalid Recursion detected.");
            }
            return total;
        }
        return 0;
    }

    private Stack<PartP2PRFPower> getDepth() {
        Stack<PartP2PRFPower> s = THREAD_STACK.get();
        if (s == null) {
            s = new Stack();
            THREAD_STACK.set(s);
        }
        return s;
    }

    private IEnergyReceiver getOutput() {
        if (this.isOutput()) {
            if (!this.cachedTarget) {
                TileEntity self = this.getTile();
                TileEntity te = self.func_145831_w().func_147438_o(self.field_145851_c + this.getSide().offsetX, self.field_145848_d + this.getSide().offsetY, self.field_145849_e + this.getSide().offsetZ);
                this.outputTarget = te instanceof IEnergyReceiver ? (IEnergyReceiver)te : null;
                this.cachedTarget = true;
            }
            if (this.outputTarget == null || !this.outputTarget.canConnectEnergy(this.getSide().getOpposite())) {
                return NULL_HANDLER;
            }
            return this.outputTarget;
        }
        return NULL_HANDLER;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (this.isOutput() || !this.isActive()) {
            return 0;
        }
        Stack<PartP2PRFPower> stack = this.getDepth();
        for (PartP2PRFPower partP2PRFPower : stack) {
            if (partP2PRFPower != this) continue;
            return 0;
        }
        stack.push(this);
        int total = 0;
        try {
            for (PartP2PRFPower t : this.getOutputs()) {
                total += t.getOutput().getEnergyStored(t.getSide().getOpposite());
            }
        }
        catch (GridAccessException gridAccessException) {
            return 0;
        }
        if (stack.pop() != this) {
            throw new IllegalStateException("Invalid Recursion detected.");
        }
        return total;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.isOutput() || !this.isActive()) {
            return 0;
        }
        Stack<PartP2PRFPower> stack = this.getDepth();
        for (PartP2PRFPower partP2PRFPower : stack) {
            if (partP2PRFPower != this) continue;
            return 0;
        }
        stack.push(this);
        int total = 0;
        try {
            for (PartP2PRFPower t : this.getOutputs()) {
                total += t.getOutput().getMaxEnergyStored(t.getSide().getOpposite());
            }
        }
        catch (GridAccessException gridAccessException) {
            return 0;
        }
        if (stack.pop() != this) {
            throw new IllegalStateException("Invalid Recursion detected.");
        }
        return total;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }
}

