/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.storage.ITerminalHost;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerMEMonitorable;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotRestrictedInput;
import appeng.helpers.IContainerCraftingPacket;
import appeng.parts.reporting.PartPatternTerminalEx;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ContainerPatternTermEx
extends ContainerMEMonitorable
implements IOptionalSlotHost,
IContainerCraftingPacket {
    private final PartPatternTerminalEx patternTerminal;
    private final OptionalSlotFake[] craftingSlots = new OptionalSlotFake[16];
    private final OptionalSlotFake[] outputSlots = new OptionalSlotFake[16];
    private final SlotRestrictedInput patternSlotIN;
    private final SlotRestrictedInput patternSlotOUT;
    @GuiSync(value=116)
    public boolean substitute = false;
    @GuiSync(value=120)
    public boolean inverted;
    public boolean initialUpdatePassed = false;

    public ContainerPatternTermEx(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable, false);
        this.patternTerminal = (PartPatternTerminalEx)monitorable;
        this.inverted = this.patternTerminal.isInverted();
        IInventory patternInv = this.getPatternTerminal().getInventoryByName("pattern");
        IInventory output = this.getPatternTerminal().getInventoryByName("output");
        IInventory crafting = this.getPatternTerminal().getInventoryByName("crafting");
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                OptionalSlotFake optionalSlotFake = new OptionalSlotFake(crafting, this, x + y * 4, 15, -83, x, y, x + 4);
                this.craftingSlots[x + y * 4] = optionalSlotFake;
                this.func_75146_a(optionalSlotFake);
                this.craftingSlots[x + y * 4].setRenderDisabled(false);
            }
        }
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                OptionalSlotFake optionalSlotFake = new OptionalSlotFake(output, this, x * 4 + y, 112, -83, -x, y, x);
                this.outputSlots[x * 4 + y] = optionalSlotFake;
                this.func_75146_a(optionalSlotFake);
                this.outputSlots[x * 4 + y].setRenderDisabled(false);
            }
        }
        this.patternSlotIN = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.BLANK_PATTERN, patternInv, 0, 147, -81, this.getInventoryPlayer());
        this.func_75146_a(this.patternSlotIN);
        this.patternSlotOUT = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, patternInv, 1, 147, -38, this.getInventoryPlayer());
        this.func_75146_a(this.patternSlotOUT);
        this.patternSlotOUT.setStackLimit(1);
        this.bindPlayerInventory(ip, 0, 0);
    }

    public void encode() {
        ItemStack output = this.patternSlotOUT.func_75211_c();
        ItemStack[] in = this.getInputs();
        ItemStack[] out = this.getOutputs();
        if (in == null || out == null) {
            return;
        }
        if (output != null && this.isNotPattern(output)) {
            return;
        }
        if (output == null) {
            output = this.patternSlotIN.func_75211_c();
            if (this.isNotPattern(output)) {
                return;
            }
            --output.field_77994_a;
            if (output.field_77994_a == 0) {
                this.patternSlotIN.func_75215_d(null);
            }
            Iterator iterator = AEApi.instance().definitions().items().encodedPattern().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                ItemStack encodedPatternStack;
                output = encodedPatternStack = (ItemStack)iterator.next();
                this.patternSlotOUT.func_75215_d(output);
            }
        }
        NBTTagCompound encodedValue = new NBTTagCompound();
        NBTTagList tagIn = new NBTTagList();
        NBTTagList tagOut = new NBTTagList();
        for (ItemStack i : in) {
            tagIn.func_74742_a(this.createItemTag(i));
        }
        for (ItemStack i : out) {
            tagOut.func_74742_a(this.createItemTag(i));
        }
        encodedValue.func_74782_a("in", (NBTBase)tagIn);
        encodedValue.func_74782_a("out", (NBTBase)tagOut);
        encodedValue.func_74757_a("crafting", false);
        encodedValue.func_74757_a("substitute", this.isSubstitute());
        output.func_77982_d(encodedValue);
    }

    private ItemStack[] getInputs() {
        ItemStack[] input = new ItemStack[16];
        boolean hasValue = false;
        for (int x = 0; x < this.craftingSlots.length; ++x) {
            input[x] = this.craftingSlots[x].func_75211_c();
            if (input[x] == null) continue;
            hasValue = true;
        }
        if (hasValue) {
            return input;
        }
        return null;
    }

    private ItemStack[] getOutputs() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(16);
        boolean hasValue = false;
        for (OptionalSlotFake outputSlot : this.outputSlots) {
            ItemStack out = outputSlot.func_75211_c();
            if (out == null || out.field_77994_a <= 0) continue;
            list.add(out);
            hasValue = true;
        }
        if (hasValue) {
            return list.toArray(new ItemStack[0]);
        }
        return null;
    }

    private boolean isNotPattern(ItemStack output) {
        if (output == null) {
            return true;
        }
        IDefinitions definitions = AEApi.instance().definitions();
        boolean isPattern = definitions.items().encodedPattern().isSameAs(output);
        return !(isPattern |= definitions.materials().blankPattern().isSameAs(output));
    }

    private NBTBase createItemTag(ItemStack i) {
        NBTTagCompound c = new NBTTagCompound();
        if (i != null) {
            i.func_77955_b(c);
        }
        return c;
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        if (idx < 4) {
            return this.inverted || idx == 0;
        }
        return !this.inverted || idx == 4;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (Platform.isServer()) {
            this.substitute = this.patternTerminal.isSubstitution();
            if (this.inverted != this.patternTerminal.isInverted()) {
                this.inverted = this.patternTerminal.isInverted();
                this.offsetSlots(!this.initialUpdatePassed);
                this.initialUpdatePassed = true;
            }
        }
    }

    private void offsetSlots(boolean initial) {
        int offset;
        int n = offset = this.inverted ? 9000 : -9000;
        if (!initial || this.inverted) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 1; x < 4; ++x) {
                    this.craftingSlots[x + y * 4].field_75223_e -= offset;
                }
            }
        }
        if (!initial || !this.inverted) {
            for (int x = 1; x < 4; ++x) {
                for (int y = 0; y < 4; ++y) {
                    this.outputSlots[x * 4 + y].field_75223_e += offset;
                }
            }
        }
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (field.equals("inverted")) {
            this.offsetSlots(!this.initialUpdatePassed);
            this.initialUpdatePassed = true;
        }
    }

    @Override
    public void onSlotChange(Slot s) {
        if (s == this.patternSlotOUT && Platform.isServer()) {
            for (Object crafter : this.field_75149_d) {
                ICrafting icrafting = (ICrafting)crafter;
                for (Object g : this.field_75151_b) {
                    if (!(g instanceof OptionalSlotFake) && !(g instanceof SlotFakeCraftingMatrix)) continue;
                    Slot sri = (Slot)g;
                    icrafting.func_71111_a((Container)this, sri.field_75222_d, sri.func_75211_c());
                }
                ((EntityPlayerMP)icrafting).field_71137_h = false;
            }
            this.func_75142_b();
        }
    }

    public void clear() {
        for (OptionalSlotFake s : this.craftingSlots) {
            s.func_75215_d(null);
        }
        for (OptionalSlotFake s : this.outputSlots) {
            s.func_75215_d(null);
        }
        this.func_75142_b();
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("player")) {
            return this.getInventoryPlayer();
        }
        return this.getPatternTerminal().getInventoryByName(name);
    }

    @Override
    public boolean useRealItems() {
        return false;
    }

    public PartPatternTerminalEx getPatternTerminal() {
        return this.patternTerminal;
    }

    private boolean isSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(boolean substitute) {
        this.substitute = substitute;
    }

    public void doubleStacks(boolean isShift) {
        if (ContainerPatternTerm.canDoubleStacks(this.craftingSlots) && ContainerPatternTerm.canDoubleStacks(this.outputSlots)) {
            ContainerPatternTerm.doubleStacksInternal(this.craftingSlots);
            ContainerPatternTerm.doubleStacksInternal(this.outputSlots);
            if (isShift) {
                while (ContainerPatternTerm.canDoubleStacks(this.craftingSlots) && ContainerPatternTerm.canDoubleStacks(this.outputSlots)) {
                    ContainerPatternTerm.doubleStacksInternal(this.craftingSlots);
                    ContainerPatternTerm.doubleStacksInternal(this.outputSlots);
                }
            }
            this.func_75142_b();
        }
    }
}

