/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.AEApi;
import appeng.api.exceptions.FailedConnection;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartHost;
import appeng.api.util.AECableType;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.settings.TickRates;
import appeng.hooks.TickHandler;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.Connections;
import appeng.me.cache.helpers.TunnelConnection;
import appeng.me.helpers.AENetworkProxy;
import appeng.parts.p2p.PartP2PTunnel;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PartP2PTunnelME
extends PartP2PTunnel<PartP2PTunnelME>
implements IGridTickable {
    private final Connections connection = new Connections(this);
    private final AENetworkProxy outerProxy = new AENetworkProxy(this, "outer", null, true);

    public PartP2PTunnelME(ItemStack is) {
        super(is);
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL, GridFlags.COMPRESSED_CHANNEL);
        if (AEConfig.instance.p2pBackboneTransfer) {
            this.outerProxy.setFlags(GridFlags.DENSE_CAPACITY, GridFlags.ULTRA_DENSE_CAPACITY, GridFlags.CANNOT_CARRY_COMPRESSED);
        } else {
            this.outerProxy.setFlags(GridFlags.DENSE_CAPACITY, GridFlags.CANNOT_CARRY_COMPRESSED);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.outerProxy.readFromNBT(extra);
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.outerProxy.writeToNBT(extra);
    }

    @Override
    public void onTunnelNetworkChange() {
        super.onTunnelNetworkChange();
        if (!this.isOutput()) {
            try {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.DENSE;
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        this.outerProxy.invalidate();
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.outerProxy.onReady();
    }

    @Override
    public void setPartHostInfo(ForgeDirection side, IPartHost host, TileEntity tile) {
        super.setPartHostInfo(side, host, tile);
        this.outerProxy.setValidSides(EnumSet.of(side));
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return this.outerProxy.getNode();
    }

    @Override
    public void onPlacement(EntityPlayer player, ItemStack held, ForgeDirection side) {
        super.onPlacement(player, held, side);
        this.outerProxy.setOwner(player);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.METunnel.getMin(), TickRates.METunnel.getMax(), true, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        try {
            if (!this.getProxy().getPath().isNetworkBooting()) {
                if (!this.getProxy().getEnergy().isNetworkPowered()) {
                    this.connection.markDestroy();
                    TickHandler.INSTANCE.addCallable(this.getTile().func_145831_w(), this.connection);
                } else if (this.getProxy().isActive()) {
                    this.connection.markCreate();
                    TickHandler.INSTANCE.addCallable(this.getTile().func_145831_w(), this.connection);
                } else {
                    this.connection.markDestroy();
                    TickHandler.INSTANCE.addCallable(this.getTile().func_145831_w(), this.connection);
                }
                return TickRateModulation.SLEEP;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return TickRateModulation.IDLE;
    }

    public void updateConnections(Connections connections) {
        if (connections.isDestroy()) {
            for (TunnelConnection cw : this.connection.getConnections().values()) {
                cw.getConnection().destroy();
            }
            this.connection.getConnections().clear();
        } else if (connections.isCreate()) {
            Iterator<TunnelConnection> i = this.connection.getConnections().values().iterator();
            while (i.hasNext()) {
                TunnelConnection cw = i.next();
                try {
                    if (cw.getTunnel().getProxy().getGrid() != this.getProxy().getGrid()) {
                        cw.getConnection().destroy();
                        i.remove();
                        continue;
                    }
                    if (cw.getTunnel().getProxy().isActive()) continue;
                    cw.getConnection().destroy();
                    i.remove();
                }
                catch (GridAccessException gridAccessException) {}
            }
            LinkedList<PartP2PTunnelME> newSides = new LinkedList<PartP2PTunnelME>();
            try {
                for (PartP2PTunnelME me : this.getOutputs()) {
                    if (!me.getProxy().isActive() || connections.getConnections().get(me.getGridNode()) != null) continue;
                    newSides.add(me);
                }
                for (PartP2PTunnelME me : newSides) {
                    try {
                        connections.getConnections().put(me.getGridNode(), new TunnelConnection(me, AEApi.instance().createGridConnection(this.outerProxy.getNode(), me.outerProxy.getNode())));
                    }
                    catch (FailedConnection e) {
                        TileEntity start = this.getTile();
                        TileEntity end = me.getTile();
                        AELog.warn("Failed to establish a ME P2P Tunnel between the tunnels at [x=%d, y=%d, z=%d, dim=%d] and [x=%d, y=%d, z=%d, dim=%d]", start.field_145851_c, start.field_145848_d, start.field_145849_e, start.func_145830_o() ? start.func_145831_w().field_73011_w.field_76574_g : Integer.MAX_VALUE, end.field_145851_c, end.field_145848_d, end.field_145849_e, end.func_145830_o() ? end.func_145831_w().field_73011_w.field_76574_g : Integer.MAX_VALUE);
                    }
                }
            }
            catch (GridAccessException e) {
                AELog.debug(e);
            }
        }
    }
}

