/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.exceptions.MissingDefinition;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.materials.MaterialType;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.Utility;
import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public final class ItemBasicStorageCell
extends AEBaseItem
implements IStorageCell,
IItemGroup {
    private final MaterialType component;
    private final int totalBytes;
    private final int perType;
    private final double idleDrain;

    public ItemBasicStorageCell(MaterialType whichCell, int kilobytes) {
        super((Optional<String>)Optional.of((Object)(kilobytes + "k")));
        this.setFeature(EnumSet.of(AEFeature.StorageCells));
        this.func_77625_d(1);
        this.totalBytes = kilobytes * 1024;
        this.component = whichCell;
        switch (this.component) {
            case Cell1kPart: {
                this.idleDrain = 0.5;
                this.perType = 8;
                break;
            }
            case Cell4kPart: {
                this.idleDrain = 1.0;
                this.perType = 32;
                break;
            }
            case Cell16kPart: {
                this.idleDrain = 1.5;
                this.perType = 128;
                break;
            }
            case Cell64kPart: {
                this.idleDrain = 2.0;
                this.perType = 512;
                break;
            }
            default: {
                this.idleDrain = 0.0;
                this.perType = 8;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        ICellInventoryHandler handler;
        ICellInventory cellInventory;
        IMEInventoryHandler inventory = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.ITEMS);
        if (inventory instanceof ICellInventoryHandler && (cellInventory = (handler = (ICellInventoryHandler)inventory).getCellInv()) != null) {
            lines.add(Utility.formatNumbers(cellInventory.getUsedBytes()) + " " + GuiText.Of.getLocal() + ' ' + Utility.formatNumbers(cellInventory.getTotalBytes()) + ' ' + GuiText.BytesUsed.getLocal());
            lines.add(Utility.formatNumbers(cellInventory.getStoredItemTypes()) + " " + GuiText.Of.getLocal() + ' ' + Utility.formatNumbers(cellInventory.getTotalItemTypes()) + ' ' + GuiText.Types.getLocal());
            if (handler.isPreformatted()) {
                String filter = cellInventory.getOreFilter();
                if (filter.isEmpty()) {
                    String list = (handler.getIncludeExcludeMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
                    if (handler.isFuzzy()) {
                        lines.add(GuiText.Partitioned.getLocal() + " - " + list + ' ' + GuiText.Fuzzy.getLocal());
                    } else {
                        lines.add(GuiText.Partitioned.getLocal() + " - " + list + ' ' + GuiText.Precise.getLocal());
                    }
                    if (GuiScreen.func_146272_n()) {
                        lines.add(GuiText.Filter.getLocal() + ": ");
                        for (int i = 0; i < cellInventory.getConfigInventory().func_70302_i_(); ++i) {
                            ItemStack s = cellInventory.getConfigInventory().func_70301_a(i);
                            if (s == null) continue;
                            lines.add(s.func_82833_r());
                        }
                    }
                } else {
                    lines.add(GuiText.PartitionedOre.getLocal() + " : " + filter);
                }
            }
        }
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return this.totalBytes;
    }

    @Override
    public int BytePerType(ItemStack cell) {
        return this.perType;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return this.perType;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 63;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requestedAddition) {
        return false;
    }

    @Override
    public boolean storableInStorageCell() {
        return false;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    @Override
    public String getUnlocalizedGroupName(Set<ItemStack> others, ItemStack is) {
        return GuiText.StorageCells.getUnlocalized();
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData(is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData(is).func_74778_a("FuzzyMode", fzMode.name());
    }

    @Override
    public String getOreFilter(ItemStack is) {
        return Platform.openNbtData(is).func_74779_i("OreFilter");
    }

    @Override
    public void setOreFilter(ItemStack is, String filter) {
        Platform.openNbtData(is).func_74778_a("OreFilter", filter);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        this.disassembleDrive(stack, world, player);
        return stack;
    }

    private boolean disassembleDrive(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (Platform.isClient()) {
                return false;
            }
            InventoryPlayer playerInventory = player.field_71071_by;
            IMEInventoryHandler inv = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.ITEMS);
            if (inv != null && playerInventory.func_70448_g() == stack) {
                InventoryAdaptor ia = InventoryAdaptor.getAdaptor(player, ForgeDirection.UNKNOWN);
                IItemList list = inv.getAvailableItems(StorageChannel.ITEMS.createList());
                if (list.isEmpty() && ia != null) {
                    playerInventory.func_70299_a(playerInventory.field_70461_c, null);
                    ItemStack extraB = ia.addItems(this.component.stack(1));
                    if (extraB != null) {
                        player.func_71019_a(extraB, false);
                    }
                    IInventory upgradesInventory = this.getUpgradesInventory(stack);
                    for (int upgradeIndex = 0; upgradeIndex < upgradesInventory.func_70302_i_(); ++upgradeIndex) {
                        ItemStack upgradeStack = upgradesInventory.func_70301_a(upgradeIndex);
                        ItemStack leftStack = ia.addItems(upgradeStack);
                        if (leftStack == null || !(upgradeStack.func_77973_b() instanceof IUpgradeModule)) continue;
                        player.func_71019_a(upgradeStack, false);
                    }
                    for (ItemStack storageCellStack : AEApi.instance().definitions().materials().emptyStorageCell().maybeStack(1).asSet()) {
                        ItemStack extraA = ia.addItems(storageCellStack);
                        if (extraA == null) continue;
                        player.func_71019_a(extraA, false);
                    }
                    if (player.field_71069_bz != null) {
                        player.field_71069_bz.func_75142_b();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)stack, (int)1) <= 0) {
            return true;
        }
        return this.disassembleDrive(stack, world, player);
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        Iterator iterator = AEApi.instance().definitions().materials().emptyStorageCell().maybeStack(1).asSet().iterator();
        if (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            return stack;
        }
        throw new MissingDefinition("Tried to use empty storage cells while basic storage cells are defined.");
    }

    public boolean hasContainerItem(ItemStack stack) {
        return AEConfig.instance.isFeatureEnabled(AEFeature.EnableDisassemblyCrafting);
    }
}

