/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.ContainerNull;
import appeng.util.ItemSorters;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class PatternHelper
implements ICraftingPatternDetails,
Comparable<PatternHelper> {
    private final ItemStack patternItem;
    private final InventoryCrafting crafting = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
    private final InventoryCrafting testFrame = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
    private final ItemStack correctOutput;
    private final IRecipe standardRecipe;
    private final IAEItemStack[] condensedInputs;
    private final IAEItemStack[] condensedOutputs;
    private final IAEItemStack[] inputs;
    private final IAEItemStack[] outputs;
    private final boolean isCrafting;
    private final boolean canSubstitute;
    private final Set<TestLookup> failCache = new HashSet<TestLookup>();
    private final Set<TestLookup> passCache = new HashSet<TestLookup>();
    private final IAEItemStack pattern;
    private int priority = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PatternHelper(ItemStack is, World w) {
        ItemStack gs;
        NBTTagCompound tag;
        int x;
        NBTTagCompound encodedValue = is.func_77978_p();
        if (encodedValue == null) {
            throw new IllegalArgumentException("No pattern here!");
        }
        NBTTagList inTag = encodedValue.func_150295_c("in", 10);
        NBTTagList outTag = encodedValue.func_150295_c("out", 10);
        this.isCrafting = encodedValue.func_74767_n("crafting");
        this.canSubstitute = encodedValue.func_74767_n("substitute");
        this.patternItem = is;
        this.pattern = AEItemStack.create(is);
        ArrayList<IAEItemStack> in = new ArrayList<IAEItemStack>();
        ArrayList<IAEItemStack> out = new ArrayList<IAEItemStack>();
        for (x = 0; x < inTag.func_74745_c(); ++x) {
            tag = inTag.func_150305_b(x);
            gs = Platform.loadItemStackFromNBT(tag);
            if (gs == null && !tag.func_82582_d()) {
                throw new IllegalStateException("No pattern here!");
            }
            if (this.isCrafting) {
                this.crafting.func_70299_a(x, gs);
            }
            if (!(gs == null || this.isCrafting && gs.func_77942_o())) {
                this.markItemAs(x, gs, TestStatus.ACCEPT);
            }
            in.add(AEApi.instance().storage().createItemStack(gs));
            if (!this.isCrafting) continue;
            this.testFrame.func_70299_a(x, gs);
        }
        if (this.isCrafting) {
            this.standardRecipe = Platform.findMatchingRecipe(this.crafting, w);
            if (this.standardRecipe == null) throw new IllegalStateException("No pattern here!");
            this.correctOutput = this.standardRecipe.func_77572_b(this.crafting);
            out.add(AEApi.instance().storage().createItemStack(this.correctOutput));
        } else {
            this.standardRecipe = null;
            this.correctOutput = null;
            for (x = 0; x < outTag.func_74745_c(); ++x) {
                tag = outTag.func_150305_b(x);
                gs = Platform.loadItemStackFromNBT(tag);
                if (gs != null) {
                    out.add(AEApi.instance().storage().createItemStack(gs));
                    continue;
                }
                if (tag.func_82582_d()) continue;
                throw new IllegalStateException("No pattern here!");
            }
        }
        this.outputs = out.toArray(new IAEItemStack[out.size()]);
        this.inputs = in.toArray(new IAEItemStack[in.size()]);
        this.condensedInputs = PatternHelper.convertToCondensedList(this.inputs);
        this.condensedOutputs = PatternHelper.convertToCondensedList(this.outputs);
        if (this.condensedInputs.length != 0 && this.condensedOutputs.length != 0) return;
        throw new IllegalStateException("No pattern here!");
    }

    private void markItemAs(int slotIndex, ItemStack i, TestStatus b) {
        if (b == TestStatus.TEST || i.func_77942_o()) {
            return;
        }
        (b == TestStatus.ACCEPT ? this.passCache : this.failCache).add(new TestLookup(slotIndex, i));
    }

    @Override
    public ItemStack getPattern() {
        return this.patternItem;
    }

    @Override
    public synchronized boolean isValidItemForSlot(int slotIndex, ItemStack i, World w) {
        if (!this.isCrafting) {
            throw new IllegalStateException("Only crafting recipes supported.");
        }
        TestStatus result = this.getStatus(slotIndex, i);
        switch (result) {
            case ACCEPT: {
                return true;
            }
            case DECLINE: {
                return false;
            }
        }
        for (int x = 0; x < this.crafting.func_70302_i_(); ++x) {
            this.testFrame.func_70299_a(x, this.crafting.func_70301_a(x));
        }
        this.testFrame.func_70299_a(slotIndex, i);
        if (this.standardRecipe.func_77569_a(this.testFrame, w)) {
            ItemStack testOutput = this.standardRecipe.func_77572_b(this.testFrame);
            if (Platform.isSameItemPrecise(this.correctOutput, testOutput)) {
                this.testFrame.func_70299_a(slotIndex, this.crafting.func_70301_a(slotIndex));
                this.markItemAs(slotIndex, i, TestStatus.ACCEPT);
                return true;
            }
        } else {
            ItemStack testOutput = CraftingManager.func_77594_a().func_82787_a(this.testFrame, w);
            if (Platform.isSameItemPrecise(this.correctOutput, testOutput)) {
                this.testFrame.func_70299_a(slotIndex, this.crafting.func_70301_a(slotIndex));
                this.markItemAs(slotIndex, i, TestStatus.ACCEPT);
                return true;
            }
        }
        this.markItemAs(slotIndex, i, TestStatus.DECLINE);
        return false;
    }

    @Override
    public boolean isCraftable() {
        return this.isCrafting;
    }

    @Override
    public IAEItemStack[] getInputs() {
        return this.inputs;
    }

    @Override
    public IAEItemStack[] getCondensedInputs() {
        return this.condensedInputs;
    }

    @Override
    public IAEItemStack[] getCondensedOutputs() {
        return this.condensedOutputs;
    }

    @Override
    public IAEItemStack[] getOutputs() {
        return this.outputs;
    }

    @Override
    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    @Override
    public ItemStack getOutput(InventoryCrafting craftingInv, World w) {
        if (!this.isCrafting) {
            throw new IllegalStateException("Only crafting recipes supported.");
        }
        for (int x = 0; x < craftingInv.func_70302_i_(); ++x) {
            if (this.isValidItemForSlot(x, craftingInv.func_70301_a(x), w)) continue;
            return null;
        }
        if (this.outputs != null && this.outputs.length > 0) {
            return this.outputs[0].getItemStack();
        }
        return null;
    }

    private TestStatus getStatus(int slotIndex, ItemStack i) {
        if (this.crafting.func_70301_a(slotIndex) == null) {
            return i == null ? TestStatus.ACCEPT : TestStatus.DECLINE;
        }
        if (i == null) {
            return TestStatus.DECLINE;
        }
        if (i.func_77942_o()) {
            return TestStatus.TEST;
        }
        if (this.passCache.contains(new TestLookup(slotIndex, i))) {
            return TestStatus.ACCEPT;
        }
        if (this.failCache.contains(new TestLookup(slotIndex, i))) {
            return TestStatus.DECLINE;
        }
        return TestStatus.TEST;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(PatternHelper o) {
        return ItemSorters.compareInt(o.priority, this.priority);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternHelper other = (PatternHelper)obj;
        if (this.pattern != null && other.pattern != null) {
            return this.pattern.equals(other.pattern);
        }
        return false;
    }

    public static IAEItemStack[] loadIAEItemStackFromNBT(NBTTagList tags, boolean saveOrder, ItemStack unknownItem) {
        ArrayList<IAEItemStack> items = new ArrayList<IAEItemStack>();
        for (int x = 0; x < tags.func_74745_c(); ++x) {
            IAEItemStack ae;
            NBTTagCompound tag = tags.func_150305_b(x);
            if (tag.func_82582_d()) continue;
            ItemStack gs = Platform.loadItemStackFromNBT(tag);
            if (gs == null && unknownItem != null) {
                gs = unknownItem.func_77946_l();
            }
            if ((ae = AEApi.instance().storage().createItemStack(gs)) == null && !saveOrder) continue;
            items.add(ae);
        }
        return items.toArray(new IAEItemStack[items.size()]);
    }

    public static IAEItemStack[] convertToCondensedList(IAEItemStack[] items) {
        HashMap<IAEItemStack, IAEItemStack> tmp = new HashMap<IAEItemStack, IAEItemStack>();
        for (IAEItemStack io : items) {
            if (io == null) continue;
            IAEItemStack g = (IAEItemStack)tmp.get(io);
            if (g == null) {
                tmp.put(io, io.copy());
                continue;
            }
            g.add(io);
        }
        return tmp.values().toArray(new IAEItemStack[tmp.size()]);
    }

    private static final class TestLookup {
        private final int slot;
        private final int ref;
        private final int hash;

        public TestLookup(int slot, ItemStack i) {
            this(slot, i.func_77973_b(), i.func_77960_j());
        }

        public TestLookup(int slot, Item item, int dmg) {
            this.slot = slot;
            this.ref = dmg << 16 | Item.func_150891_b((Item)item) & 0xFFFF;
            int offset = 3 * slot;
            this.hash = this.ref << offset | this.ref >> offset + 32;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            boolean equality;
            if (obj instanceof TestLookup) {
                TestLookup b = (TestLookup)obj;
                equality = b.slot == this.slot && b.ref == this.ref;
            } else {
                equality = false;
            }
            return equality;
        }
    }

    private static enum TestStatus {
        ACCEPT,
        DECLINE,
        TEST;

    }
}

