/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.api.config.AccessRestriction;
import appeng.api.config.ActionItems;
import appeng.api.config.CondenserOutput;
import appeng.api.config.CraftingStatus;
import appeng.api.config.FullnessMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.InsertionMode;
import appeng.api.config.ItemSubstitution;
import appeng.api.config.LevelType;
import appeng.api.config.OperationMode;
import appeng.api.config.PatternSlotConfig;
import appeng.api.config.PowerUnits;
import appeng.api.config.RedstoneMode;
import appeng.api.config.RelativeDirection;
import appeng.api.config.SchedulingMode;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.StorageFilter;
import appeng.api.config.TerminalStyle;
import appeng.api.config.ViewItems;
import appeng.api.config.YesNo;
import appeng.client.gui.widgets.ITooltip;
import appeng.client.texture.ExtraBlockTextures;
import appeng.core.localization.ButtonToolTips;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiImgButton
extends GuiButton
implements ITooltip {
    private static final Pattern COMPILE = Pattern.compile("%s");
    private static final Pattern PATTERN_NEW_LINE = Pattern.compile("\\n", 16);
    private static Map<EnumPair, ButtonAppearance> appearances;
    private final Enum buttonSetting;
    private boolean halfSize = false;
    private String fillVar;
    private Enum currentValue;

    public GuiImgButton(int x, int y, Enum idx, Enum val) {
        super(0, 0, 16, "");
        this.buttonSetting = idx;
        this.currentValue = val;
        this.field_146128_h = x;
        this.field_146129_i = y;
        this.field_146120_f = 16;
        this.field_146121_g = 16;
        if (appearances == null) {
            appearances = new HashMap<EnumPair, ButtonAppearance>();
            this.registerApp(112, Settings.CONDENSER_OUTPUT, CondenserOutput.TRASH, ButtonToolTips.CondenserOutput, (Object)ButtonToolTips.Trash);
            this.registerApp(113, Settings.CONDENSER_OUTPUT, CondenserOutput.MATTER_BALLS, ButtonToolTips.CondenserOutput, (Object)ButtonToolTips.MatterBalls);
            this.registerApp(114, Settings.CONDENSER_OUTPUT, CondenserOutput.SINGULARITY, ButtonToolTips.CondenserOutput, (Object)ButtonToolTips.Singularity);
            this.registerApp(145, Settings.ACCESS, AccessRestriction.READ, ButtonToolTips.IOMode, (Object)ButtonToolTips.Read);
            this.registerApp(144, Settings.ACCESS, AccessRestriction.WRITE, ButtonToolTips.IOMode, (Object)ButtonToolTips.Write);
            this.registerApp(146, Settings.ACCESS, AccessRestriction.READ_WRITE, ButtonToolTips.IOMode, (Object)ButtonToolTips.ReadWrite);
            this.registerApp(160, Settings.POWER_UNITS, PowerUnits.AE, ButtonToolTips.PowerUnits, PowerUnits.AE.unlocalizedName);
            this.registerApp(161, Settings.POWER_UNITS, PowerUnits.EU, ButtonToolTips.PowerUnits, PowerUnits.EU.unlocalizedName);
            this.registerApp(162, Settings.POWER_UNITS, PowerUnits.MK, ButtonToolTips.PowerUnits, PowerUnits.MK.unlocalizedName);
            this.registerApp(163, Settings.POWER_UNITS, PowerUnits.WA, ButtonToolTips.PowerUnits, PowerUnits.WA.unlocalizedName);
            this.registerApp(164, Settings.POWER_UNITS, PowerUnits.RF, ButtonToolTips.PowerUnits, PowerUnits.RF.unlocalizedName);
            this.registerApp(3, Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE, ButtonToolTips.RedstoneMode, (Object)ButtonToolTips.AlwaysActive);
            this.registerApp(0, Settings.REDSTONE_CONTROLLED, RedstoneMode.LOW_SIGNAL, ButtonToolTips.RedstoneMode, (Object)ButtonToolTips.ActiveWithoutSignal);
            this.registerApp(1, Settings.REDSTONE_CONTROLLED, RedstoneMode.HIGH_SIGNAL, ButtonToolTips.RedstoneMode, (Object)ButtonToolTips.ActiveWithSignal);
            this.registerApp(2, Settings.REDSTONE_CONTROLLED, RedstoneMode.SIGNAL_PULSE, ButtonToolTips.RedstoneMode, (Object)ButtonToolTips.ActiveOnPulse);
            this.registerApp(0, Settings.REDSTONE_EMITTER, RedstoneMode.LOW_SIGNAL, ButtonToolTips.RedstoneMode, (Object)ButtonToolTips.EmitLevelsBelow);
            this.registerApp(1, Settings.REDSTONE_EMITTER, RedstoneMode.HIGH_SIGNAL, ButtonToolTips.RedstoneMode, (Object)ButtonToolTips.EmitLevelAbove);
            this.registerApp(51, Settings.OPERATION_MODE, OperationMode.FILL, ButtonToolTips.TransferDirection, (Object)ButtonToolTips.TransferToStorageCell);
            this.registerApp(50, Settings.OPERATION_MODE, OperationMode.EMPTY, ButtonToolTips.TransferDirection, (Object)ButtonToolTips.TransferToNetwork);
            this.registerApp(51, Settings.IO_DIRECTION, RelativeDirection.LEFT, ButtonToolTips.TransferDirection, (Object)ButtonToolTips.TransferToStorageCell);
            this.registerApp(50, Settings.IO_DIRECTION, RelativeDirection.RIGHT, ButtonToolTips.TransferDirection, (Object)ButtonToolTips.TransferToNetwork);
            this.registerApp(48, Settings.SORT_DIRECTION, SortDir.ASCENDING, ButtonToolTips.SortOrder, (Object)ButtonToolTips.ToggleSortDirection);
            this.registerApp(49, Settings.SORT_DIRECTION, SortDir.DESCENDING, ButtonToolTips.SortOrder, (Object)ButtonToolTips.ToggleSortDirection);
            this.registerApp(35, Settings.SEARCH_MODE, SearchBoxMode.AUTOSEARCH, ButtonToolTips.SearchMode, (Object)ButtonToolTips.SearchMode_Auto);
            this.registerApp(36, Settings.SEARCH_MODE, SearchBoxMode.MANUAL_SEARCH, ButtonToolTips.SearchMode, (Object)ButtonToolTips.SearchMode_Standard);
            this.registerApp(37, Settings.SEARCH_MODE, SearchBoxMode.NEI_AUTOSEARCH, ButtonToolTips.SearchMode, (Object)ButtonToolTips.SearchMode_NEIAuto);
            this.registerApp(38, Settings.SEARCH_MODE, SearchBoxMode.NEI_MANUAL_SEARCH, ButtonToolTips.SearchMode, (Object)ButtonToolTips.SearchMode_NEIStandard);
            this.registerApp(39, Settings.SAVE_SEARCH, YesNo.YES, ButtonToolTips.SaveSearchString, (Object)ButtonToolTips.SaveSearchStringYes);
            this.registerApp(40, Settings.SAVE_SEARCH, YesNo.NO, ButtonToolTips.SaveSearchString, (Object)ButtonToolTips.SaveSearchStringNo);
            this.registerApp(83, Settings.LEVEL_TYPE, LevelType.ENERGY_LEVEL, ButtonToolTips.LevelType, (Object)ButtonToolTips.LevelType_Energy);
            this.registerApp(67, Settings.LEVEL_TYPE, LevelType.ITEM_LEVEL, ButtonToolTips.LevelType, (Object)ButtonToolTips.LevelType_Item);
            this.registerApp(208, Settings.TERMINAL_STYLE, TerminalStyle.TALL, ButtonToolTips.TerminalStyle, (Object)ButtonToolTips.TerminalStyle_Tall);
            this.registerApp(209, Settings.TERMINAL_STYLE, TerminalStyle.SMALL, ButtonToolTips.TerminalStyle, (Object)ButtonToolTips.TerminalStyle_Small);
            this.registerApp(210, Settings.TERMINAL_STYLE, TerminalStyle.FULL, ButtonToolTips.TerminalStyle, (Object)ButtonToolTips.TerminalStyle_Full);
            this.registerApp(64, Settings.SORT_BY, SortOrder.NAME, ButtonToolTips.SortBy, (Object)ButtonToolTips.ItemName);
            this.registerApp(65, Settings.SORT_BY, SortOrder.AMOUNT, ButtonToolTips.SortBy, (Object)ButtonToolTips.NumberOfItems);
            this.registerApp(68, Settings.SORT_BY, SortOrder.INVTWEAKS, ButtonToolTips.SortBy, (Object)ButtonToolTips.InventoryTweaks);
            this.registerApp(69, Settings.SORT_BY, SortOrder.MOD, ButtonToolTips.SortBy, (Object)ButtonToolTips.Mod);
            this.registerApp(66, Settings.ACTIONS, ActionItems.WRENCH, ButtonToolTips.PartitionStorage, (Object)ButtonToolTips.PartitionStorageHint);
            this.registerApp(6, Settings.ACTIONS, ActionItems.CLOSE, ButtonToolTips.Clear, (Object)ButtonToolTips.ClearSettings);
            this.registerApp(6, Settings.ACTIONS, ActionItems.STASH, ButtonToolTips.Stash, (Object)ButtonToolTips.StashDesc);
            this.registerApp(8, Settings.ACTIONS, ActionItems.ENCODE, ButtonToolTips.Encode, (Object)ButtonToolTips.EncodeDescription);
            this.registerApp(52, Settings.ACTIONS, ItemSubstitution.ENABLED, ButtonToolTips.Substitutions, (Object)ButtonToolTips.SubstitutionsDescEnabled);
            this.registerApp(55, Settings.ACTIONS, ItemSubstitution.DISABLED, ButtonToolTips.Substitutions, (Object)ButtonToolTips.SubstitutionsDescDisabled);
            this.registerApp(24, Settings.ACTIONS, PatternSlotConfig.C_16_4, ButtonToolTips.PatternSlotConfigTitle, (Object)ButtonToolTips.PatternSlotConfigInfo);
            this.registerApp(24, Settings.ACTIONS, PatternSlotConfig.C_4_16, ButtonToolTips.PatternSlotConfigTitle, (Object)ButtonToolTips.PatternSlotConfigInfo);
            this.registerApp(16, Settings.VIEW_MODE, ViewItems.STORED, ButtonToolTips.View, (Object)ButtonToolTips.StoredItems);
            this.registerApp(18, Settings.VIEW_MODE, ViewItems.ALL, ButtonToolTips.View, (Object)ButtonToolTips.StoredCraftable);
            this.registerApp(19, Settings.VIEW_MODE, ViewItems.CRAFTABLE, ButtonToolTips.View, (Object)ButtonToolTips.Craftable);
            this.registerApp(96, Settings.FUZZY_MODE, FuzzyMode.PERCENT_25, ButtonToolTips.FuzzyMode, (Object)ButtonToolTips.FZPercent_25);
            this.registerApp(97, Settings.FUZZY_MODE, FuzzyMode.PERCENT_50, ButtonToolTips.FuzzyMode, (Object)ButtonToolTips.FZPercent_50);
            this.registerApp(98, Settings.FUZZY_MODE, FuzzyMode.PERCENT_75, ButtonToolTips.FuzzyMode, (Object)ButtonToolTips.FZPercent_75);
            this.registerApp(99, Settings.FUZZY_MODE, FuzzyMode.PERCENT_99, ButtonToolTips.FuzzyMode, (Object)ButtonToolTips.FZPercent_99);
            this.registerApp(100, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL, ButtonToolTips.FuzzyMode, (Object)ButtonToolTips.FZIgnoreAll);
            this.registerApp(80, Settings.FULLNESS_MODE, FullnessMode.EMPTY, ButtonToolTips.OperationMode, (Object)ButtonToolTips.MoveWhenEmpty);
            this.registerApp(81, Settings.FULLNESS_MODE, FullnessMode.HALF, ButtonToolTips.OperationMode, (Object)ButtonToolTips.MoveWhenWorkIsDone);
            this.registerApp(82, Settings.FULLNESS_MODE, FullnessMode.FULL, ButtonToolTips.OperationMode, (Object)ButtonToolTips.MoveWhenFull);
            this.registerApp(21, Settings.BLOCK, YesNo.YES, ButtonToolTips.InterfaceBlockingMode, (Object)ButtonToolTips.Blocking);
            this.registerApp(20, Settings.BLOCK, YesNo.NO, ButtonToolTips.InterfaceBlockingMode, (Object)ButtonToolTips.NonBlocking);
            this.registerApp(19, Settings.CRAFT_ONLY, YesNo.YES, ButtonToolTips.Craft, (Object)ButtonToolTips.CraftOnly);
            this.registerApp(18, Settings.CRAFT_ONLY, YesNo.NO, ButtonToolTips.Craft, (Object)ButtonToolTips.CraftEither);
            this.registerApp(178, Settings.CRAFT_VIA_REDSTONE, YesNo.YES, ButtonToolTips.EmitterMode, (Object)ButtonToolTips.CraftViaRedstone);
            this.registerApp(177, Settings.CRAFT_VIA_REDSTONE, YesNo.NO, ButtonToolTips.EmitterMode, (Object)ButtonToolTips.EmitWhenCrafting);
            this.registerApp(53, Settings.STORAGE_FILTER, StorageFilter.EXTRACTABLE_ONLY, ButtonToolTips.ReportInaccessibleItems, (Object)ButtonToolTips.ReportInaccessibleItemsNo);
            this.registerApp(54, Settings.STORAGE_FILTER, StorageFilter.NONE, ButtonToolTips.ReportInaccessibleItems, (Object)ButtonToolTips.ReportInaccessibleItemsYes);
            this.registerApp(224, Settings.PLACE_BLOCK, YesNo.YES, ButtonToolTips.BlockPlacement, (Object)ButtonToolTips.BlockPlacementYes);
            this.registerApp(225, Settings.PLACE_BLOCK, YesNo.NO, ButtonToolTips.BlockPlacement, (Object)ButtonToolTips.BlockPlacementNo);
            this.registerApp(240, Settings.SCHEDULING_MODE, SchedulingMode.DEFAULT, ButtonToolTips.SchedulingMode, (Object)ButtonToolTips.SchedulingModeDefault);
            this.registerApp(241, Settings.SCHEDULING_MODE, SchedulingMode.ROUNDROBIN, ButtonToolTips.SchedulingMode, (Object)ButtonToolTips.SchedulingModeRoundRobin);
            this.registerApp(242, Settings.SCHEDULING_MODE, SchedulingMode.RANDOM, ButtonToolTips.SchedulingMode, (Object)ButtonToolTips.SchedulingModeRandom);
            this.registerApp(70, Settings.ACTIONS, ActionItems.ORE_FILTER, ButtonToolTips.OreFilter, (Object)ButtonToolTips.OreFilterHint);
            this.registerApp(71, Settings.ACTIONS, ActionItems.DOUBLE, ButtonToolTips.DoublePattern, (Object)ButtonToolTips.DoublePatternHint);
            this.registerApp(226, Settings.CRAFTING_STATUS, CraftingStatus.BUTTON, ButtonToolTips.CraftingStatus, (Object)ButtonToolTips.CraftingStatusDesc);
            this.registerApp(84, Settings.ACTIONS, ActionItems.TOGGLE_SHOW_ONLY_INVALID_PATTERN_ON, ButtonToolTips.ToggleShowOnlyInvalidInterface, (Object)ButtonToolTips.ToggleShowOnlyInvalidInterfaceOnDesc);
            this.registerApp(85, Settings.ACTIONS, ActionItems.TOGGLE_SHOW_ONLY_INVALID_PATTERN_OFF, ButtonToolTips.ToggleShowOnlyInvalidInterface, (Object)ButtonToolTips.ToggleShowOnlyInvalidInterfaceOffDesc);
            this.registerApp(86, Settings.ACTIONS, ActionItems.MOLECULAR_ASSEMBLEERS_ON, ButtonToolTips.ToggleMolecularAssemblers, (Object)ButtonToolTips.ToggleMolecularAssemblersDescOn);
            this.registerApp(87, Settings.ACTIONS, ActionItems.TOGGLE_SHOW_FULL_INTERFACES_ON, ButtonToolTips.ToggleShowFullInterfaces, (Object)ButtonToolTips.ToggleShowFullInterfacesOnDesc);
            this.registerApp(88, Settings.ACTIONS, ActionItems.TOGGLE_SHOW_FULL_INTERFACES_OFF, ButtonToolTips.ToggleShowFullInterfaces, (Object)ButtonToolTips.ToggleShowFullInterfacesOffDesc);
            this.registerApp(89, Settings.ACTIONS, ActionItems.MOLECULAR_ASSEMBLEERS_OFF, ButtonToolTips.ToggleMolecularAssemblers, (Object)ButtonToolTips.ToggleMolecularAssemblersDescOff);
            this.registerApp(102, Settings.ACTIONS, ActionItems.HIGHLIGHT_INTERFACE, ButtonToolTips.HighlightInterface, "");
            this.registerApp(147, Settings.INSERTION_MODE, InsertionMode.DEFAULT, ButtonToolTips.InsertionModeDefault, (Object)ButtonToolTips.InsertionModeDefaultDesc);
            this.registerApp(148, Settings.INSERTION_MODE, InsertionMode.PREFER_EMPTY, ButtonToolTips.InsertionModePreferEmpty, (Object)ButtonToolTips.InsertionModePreferEmptyDesc);
            this.registerApp(149, Settings.INSERTION_MODE, InsertionMode.ONLY_EMPTY, ButtonToolTips.InsertionModeOnlyEmpty, (Object)ButtonToolTips.InsertionModeOnlyEmptyDesc);
        }
    }

    private void registerApp(int iconIndex, Settings setting, Enum val, ButtonToolTips title, Object hint) {
        ButtonAppearance a = new ButtonAppearance();
        a.displayName = title.getUnlocalized();
        a.displayValue = (String)(hint instanceof String ? hint : ((ButtonToolTips)((Object)hint)).getUnlocalized());
        a.index = iconIndex;
        appearances.put(new EnumPair(setting, val), a);
    }

    public void setVisibility(boolean vis) {
        this.field_146125_m = vis;
        this.field_146124_l = vis;
    }

    public void func_146112_a(Minecraft par1Minecraft, int par2, int par3) {
        if (this.field_146125_m) {
            int iconIndex = this.getIconIndex();
            if (this.halfSize) {
                this.field_146120_f = 8;
                this.field_146121_g = 8;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)this.field_146128_h, (float)this.field_146129_i, (float)0.0f);
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                if (this.field_146124_l) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                }
                par1Minecraft.field_71446_o.func_110577_a(ExtraBlockTextures.GuiTexture("guis/states.png"));
                this.field_146123_n = par2 >= this.field_146128_h && par3 >= this.field_146129_i && par2 < this.field_146128_h + this.field_146120_f && par3 < this.field_146129_i + this.field_146121_g;
                int uv_y = (int)Math.floor(iconIndex / 16);
                int uv_x = iconIndex - uv_y * 16;
                this.func_73729_b(0, 0, 240, 240, 16, 16);
                this.func_73729_b(0, 0, uv_x * 16, uv_y * 16, 16, 16);
                this.func_146119_b(par1Minecraft, par2, par3);
                GL11.glPopMatrix();
            } else {
                if (this.field_146124_l) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                }
                par1Minecraft.field_71446_o.func_110577_a(ExtraBlockTextures.GuiTexture("guis/states.png"));
                this.field_146123_n = par2 >= this.field_146128_h && par3 >= this.field_146129_i && par2 < this.field_146128_h + this.field_146120_f && par3 < this.field_146129_i + this.field_146121_g;
                int uv_y = (int)Math.floor(iconIndex / 16);
                int uv_x = iconIndex - uv_y * 16;
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 240, 240, 16, 16);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, uv_x * 16, uv_y * 16, 16, 16);
                this.func_146119_b(par1Minecraft, par2, par3);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private int getIconIndex() {
        if (this.buttonSetting != null && this.currentValue != null) {
            ButtonAppearance app = appearances.get(new EnumPair(this.buttonSetting, this.currentValue));
            if (app == null) {
                return 255;
            }
            return app.index;
        }
        return 255;
    }

    public Settings getSetting() {
        return (Settings)this.buttonSetting;
    }

    public Enum getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public String getMessage() {
        String displayName = null;
        String displayValue = null;
        if (this.buttonSetting != null && this.currentValue != null) {
            ButtonAppearance buttonAppearance = appearances.get(new EnumPair(this.buttonSetting, this.currentValue));
            if (buttonAppearance == null) {
                return "No Such Message";
            }
            displayName = buttonAppearance.displayName;
            displayValue = buttonAppearance.displayValue;
        }
        if (displayName != null) {
            StringBuilder sb;
            int i;
            String name = StatCollector.func_74838_a(displayName);
            String value = StatCollector.func_74838_a(displayValue);
            if (name == null || name.isEmpty()) {
                name = displayName;
            }
            if (value == null || value.isEmpty()) {
                value = displayValue;
            }
            if (this.fillVar != null) {
                value = COMPILE.matcher(value).replaceFirst(this.fillVar);
            }
            if ((i = (sb = new StringBuilder(value = PATTERN_NEW_LINE.matcher(value).replaceAll("\n"))).lastIndexOf("\n")) <= 0) {
                i = 0;
            }
            while (i + 30 < sb.length() && (i = sb.lastIndexOf(" ", i + 30)) != -1) {
                sb.replace(i, i + 1, "\n");
            }
            return name + '\n' + sb;
        }
        return null;
    }

    @Override
    public int xPos() {
        return this.field_146128_h;
    }

    @Override
    public int yPos() {
        return this.field_146129_i;
    }

    @Override
    public int getWidth() {
        return this.halfSize ? 8 : 16;
    }

    @Override
    public int getHeight() {
        return this.halfSize ? 8 : 16;
    }

    @Override
    public boolean isVisible() {
        return this.field_146125_m;
    }

    public void set(Enum e) {
        if (this.currentValue != e) {
            this.currentValue = e;
        }
    }

    public boolean isHalfSize() {
        return this.halfSize;
    }

    public void setHalfSize(boolean halfSize) {
        this.halfSize = halfSize;
    }

    public String getFillVar() {
        return this.fillVar;
    }

    public void setFillVar(String fillVar) {
        this.fillVar = fillVar;
    }

    private static class ButtonAppearance {
        public int index;
        public String displayName;
        public String displayValue;

        private ButtonAppearance() {
        }
    }

    private static final class EnumPair {
        final Enum setting;
        final Enum value;

        EnumPair(Enum a, Enum b) {
            this.setting = a;
            this.value = b;
        }

        public int hashCode() {
            return this.setting.hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumPair other = (EnumPair)obj;
            return other.setting == this.setting && other.value == this.value;
        }
    }
}

