/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.container.implementations.ContainerCPUTable;
import appeng.container.implementations.CraftingCPUStatus;
import appeng.core.AELog;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketValueConfig;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiCraftingCPUTable {
    private final AEBaseGui parent;
    private final ContainerCPUTable container;
    public static final int CPU_TABLE_WIDTH = 94;
    public static final int CPU_TABLE_HEIGHT = 164;
    public static final int CPU_TABLE_SLOTS = 6;
    public static final int CPU_TABLE_SLOT_XOFF = 100;
    public static final int CPU_TABLE_SLOT_YOFF = 0;
    public static final int CPU_TABLE_SLOT_WIDTH = 67;
    public static final int CPU_TABLE_SLOT_HEIGHT = 23;
    private final GuiScrollbar cpuScrollbar;
    private String selectedCPUName = "";

    public GuiCraftingCPUTable(AEBaseGui parent, ContainerCPUTable container) {
        this.parent = parent;
        this.container = container;
        this.cpuScrollbar = new GuiScrollbar();
        this.cpuScrollbar.setLeft(-16);
        this.cpuScrollbar.setTop(19);
        this.cpuScrollbar.setWidth(12);
        this.cpuScrollbar.setHeight(137);
    }

    public ContainerCPUTable getContainer() {
        return this.container;
    }

    public String getSelectedCPUName() {
        return this.selectedCPUName;
    }

    public void drawScreen() {
        List<CraftingCPUStatus> cpus = this.container.getCPUs();
        int selectedCpuSerial = this.container.selectedCpuSerial;
        this.selectedCPUName = null;
        this.cpuScrollbar.setRange(0, Integer.max(0, cpus.size() - 6), 1);
        for (CraftingCPUStatus cpu : cpus) {
            if (cpu.getSerial() != selectedCpuSerial) continue;
            this.selectedCPUName = cpu.getName();
        }
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY, int guiLeft, int guiTop) {
        if (this.cpuScrollbar != null) {
            this.cpuScrollbar.draw(this.parent);
        }
        List<CraftingCPUStatus> cpus = this.container.getCPUs();
        int selectedCpuSerial = this.container.selectedCpuSerial;
        int firstCpu = this.cpuScrollbar.getCurrentScroll();
        CraftingCPUStatus hoveredCpu = this.hitCpu(mouseX - guiLeft, mouseY - guiTop);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        for (int i = firstCpu; i < firstCpu + 6; ++i) {
            int uv_x;
            int uv_y;
            int iconIndex;
            CraftingCPUStatus cpu;
            if (i < 0 || i >= cpus.size() || (cpu = cpus.get(i)) == null) continue;
            int x = -85;
            int y = 19 + (i - firstCpu) * 23;
            if (cpu.getSerial() == selectedCpuSerial) {
                if (!this.container.getCpuFilter().test(cpu)) {
                    GL11.glColor4f((float)1.0f, (float)0.25f, (float)0.25f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.0f, (float)0.8352f, (float)1.0f, (float)1.0f);
                }
            } else if (hoveredCpu != null && hoveredCpu.getSerial() == cpu.getSerial()) {
                GL11.glColor4f((float)0.65f, (float)0.9f, (float)1.0f, (float)1.0f);
            } else if (!this.container.getCpuFilter().test(cpu)) {
                GL11.glColor4f((float)0.9f, (float)0.65f, (float)0.65f, (float)1.0f);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.parent.bindTexture("guis/cpu_selector.png");
            this.parent.func_73729_b(x, y, 100, 0, 67, 23);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String name = cpu.getName();
            if (name == null || name.isEmpty()) {
                name = GuiText.CPUs.getLocal() + " #" + cpu.getSerial();
            }
            if (name.length() > 12) {
                name = name.substring(0, 11) + "..";
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x + 3), (float)(y + 3), (float)0.0f);
            GL11.glScalef((float)0.8f, (float)0.8f, (float)1.0f);
            font.func_78276_b(name, 0, 0, GuiColors.CraftingStatusCPUName.getColor());
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x + 3), (float)(y + 11), (float)0.0f);
            IAEItemStack craftingStack = cpu.getCrafting();
            if (craftingStack != null) {
                iconIndex = 178;
                this.parent.bindTexture("guis/states.png");
                uv_y = 11;
                uv_x = 2;
                GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.parent.func_73729_b(0, 0, 32, 176, 16, 16);
                GL11.glTranslatef((float)18.0f, (float)2.0f, (float)0.0f);
                String amount = Long.toString(craftingStack.getStackSize());
                if (amount.length() > 5) {
                    amount = amount.substring(0, 5) + "..";
                }
                GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                font.func_78276_b(amount, 0, 0, GuiColors.CraftingStatusCPUAmount.getColor());
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(x + 67 - 19), (float)(y + 3), (float)0.0f);
                this.parent.drawItem(0, 0, craftingStack.getItemStack());
            } else {
                iconIndex = 67;
                this.parent.bindTexture("guis/states.png");
                uv_y = 4;
                uv_x = 3;
                GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.parent.func_73729_b(0, 0, 48, 64, 16, 16);
                GL11.glTranslatef((float)18.0f, (float)2.0f, (float)0.0f);
                GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                font.func_78276_b(cpu.formatStorage(), 0, 0, GuiColors.CraftingStatusCPUStorage.getColor());
            }
            GL11.glPopMatrix();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (hoveredCpu != null) {
            StringBuilder tooltip = new StringBuilder();
            String name = hoveredCpu.getName();
            if (name != null && !name.isEmpty()) {
                tooltip.append(name);
                tooltip.append('\n');
            } else {
                tooltip.append(GuiText.CPUs.getLocal());
                tooltip.append(" #");
                tooltip.append(hoveredCpu.getSerial());
                tooltip.append('\n');
            }
            IAEItemStack crafting = hoveredCpu.getCrafting();
            if (crafting != null && crafting.getStackSize() > 0L) {
                tooltip.append(GuiText.Crafting.getLocal());
                tooltip.append(": ");
                tooltip.append(crafting.getStackSize());
                tooltip.append(' ');
                tooltip.append(crafting.getItemStack().func_82833_r());
                tooltip.append('\n');
                tooltip.append(hoveredCpu.getRemainingItems());
                tooltip.append(" / ");
                tooltip.append(hoveredCpu.getTotalItems());
                tooltip.append('\n');
            }
            if (hoveredCpu.getStorage() > 0L) {
                tooltip.append(GuiText.Bytes.getLocal());
                tooltip.append(": ");
                tooltip.append(hoveredCpu.formatStorage());
                tooltip.append('\n');
            }
            if (hoveredCpu.getCoprocessors() > 0L) {
                tooltip.append(GuiText.CoProcessors.getLocal());
                tooltip.append(": ");
                tooltip.append(hoveredCpu.getCoprocessors());
                tooltip.append('\n');
            }
            if (tooltip.length() > 0) {
                this.parent.drawTooltip(mouseX - offsetX, mouseY - offsetY, 0, tooltip.toString());
            }
        }
    }

    public void drawBG(int offsetX, int offsetY) {
        this.parent.bindTexture("guis/cpu_selector.png");
        this.parent.func_73729_b(offsetX - 94, offsetY, 0, 0, 94, 164);
    }

    public CraftingCPUStatus hitCpu(int x, int y) {
        if ((x += 94) < 9 || x >= 76 || y < 19 || y >= 157) {
            return null;
        }
        int scrollOffset = this.cpuScrollbar != null ? this.cpuScrollbar.getCurrentScroll() : 0;
        int cpuId = scrollOffset + (y - 19) / 23;
        List<CraftingCPUStatus> cpus = this.container.getCPUs();
        return cpuId >= 0 && cpuId < cpus.size() ? cpus.get(cpuId) : null;
    }

    public void mouseClicked(int xCoord, int yCoord, int btn) {
        CraftingCPUStatus hit;
        if (this.cpuScrollbar != null) {
            this.cpuScrollbar.click(this.parent, xCoord, yCoord);
        }
        if ((hit = this.hitCpu(xCoord, yCoord)) != null) {
            this.sendCPUSwitch(hit.getSerial());
        }
    }

    public void sendCPUSwitch(int serial) {
        try {
            NetworkHandler.instance.sendToServer(new PacketValueConfig("CPUTable.Cpu.Set", Integer.toString(serial)));
        }
        catch (IOException e) {
            AELog.warn(e);
        }
    }

    public void mouseClickMove(int xCoord, int yCoord) {
        if (this.cpuScrollbar != null) {
            this.cpuScrollbar.click(this.parent, xCoord, yCoord);
        }
    }

    public boolean handleMouseInput(int guiLeft, int guiTop) {
        int x = Mouse.getEventX() * this.parent.field_146294_l / this.parent.field_146297_k.field_71443_c;
        int y = this.parent.field_146295_m - Mouse.getEventY() * this.parent.field_146295_m / this.parent.field_146297_k.field_71440_d - 1;
        int dwheel = Mouse.getEventDWheel();
        if ((x -= guiLeft - 94) >= 9 && x < 76 && (y -= guiTop) >= 19 && y < 157 && this.cpuScrollbar != null && dwheel != 0) {
            this.cpuScrollbar.wheel(dwheel);
            return true;
        }
        return false;
    }

    public boolean hideItemPanelSlot(int x, int y, int w, int h) {
        boolean xInside = (x += 94) >= 0 && x < 76 || x + w >= 0 && x + w < 76 || x <= 0 && x + w >= 76;
        boolean yInside = y >= 0 && y < 157 || y + h >= 0 && y + h < 157 || y < 0 && y + h >= 157;
        return xInside && yInside;
    }

    public void cycleCPU(boolean backwards) {
        CraftingCPUStatus cpu;
        int next_increment;
        int current = this.container.selectedCpuSerial;
        List<CraftingCPUStatus> cpus = this.container.getCPUs();
        int n = next_increment = backwards ? cpus.size() - 1 : 1;
        if (cpus.isEmpty()) {
            return;
        }
        int next = 0;
        for (int i = 0; i < cpus.size(); ++i) {
            if (cpus.get(i).getSerial() != current) continue;
            next = i + next_increment;
            break;
        }
        boolean preferBusy = this.container.isBusyCPUsPreferred();
        for (int i = 0; !(i >= cpus.size() || (cpu = cpus.get(next %= cpus.size())).isBusy() == preferBusy && this.container.getCpuFilter().test(cpu)); ++i) {
            next += next_increment;
        }
        this.sendCPUSwitch(cpus.get(next %= cpus.size()).getSerial());
        if (next < this.cpuScrollbar.getCurrentScroll() || next >= this.cpuScrollbar.getCurrentScroll() + 6) {
            this.cpuScrollbar.setCurrentScroll(next);
        }
    }
}

