/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr;

import com.gtnewhorizons.angelica.compat.mojang.AutoClosableAbstractTexture;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.coderbot.iris.Iris;
import net.coderbot.iris.texture.pbr.PBRAtlasHolder;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.texture.pbr.TextureAtlasExtension;
import net.coderbot.iris.texture.util.TextureExporter;
import net.coderbot.iris.texture.util.TextureManipulationUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PBRAtlasTexture
extends AutoClosableAbstractTexture {
    protected final TextureMap texMap;
    protected final PBRType type;
    protected final ResourceLocation id;
    protected final Map<ResourceLocation, TextureAtlasSprite> sprites = new HashMap<ResourceLocation, TextureAtlasSprite>();
    protected final Set<TextureAtlasSprite> animatedSprites = new HashSet<TextureAtlasSprite>();

    public PBRAtlasTexture(TextureMap textureMap, PBRType type) {
        this.texMap = textureMap;
        this.type = type;
        this.id = type.appendToFileLocation(TextureMap.field_110575_b);
    }

    public ResourceLocation getAtlasId() {
        return this.id;
    }

    public void addSprite(TextureAtlasSprite sprite) {
        this.sprites.put(this.texMap.func_147634_a(new ResourceLocation(sprite.func_94215_i()), 0), sprite);
        if (sprite.func_130098_m()) {
            this.animatedSprites.add(sprite);
        }
    }

    @Nullable
    public TextureAtlasSprite getSprite(ResourceLocation id) {
        return this.sprites.get(id);
    }

    public void clear() {
        this.sprites.clear();
        this.animatedSprites.clear();
    }

    public void upload(int atlasWidth, int atlasHeight, int mipLevel, float anisotropicFiltering) {
        int glId = this.func_110552_b();
        TextureUtil.func_147946_a((int)glId, (int)mipLevel, (int)atlasWidth, (int)atlasHeight, (float)anisotropicFiltering);
        TextureManipulationUtil.fillWithColor(glId, mipLevel, this.type.getDefaultValue());
        for (TextureAtlasSprite sprite : this.sprites.values()) {
            try {
                this.uploadSprite(sprite);
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a((Throwable)throwable, (String)"Stitching texture atlas");
                CrashReportCategory crashReportCategory = crashReport.func_85058_a("Texture being stitched together");
                crashReportCategory.func_71507_a("Atlas path", (Object)this.id);
                crashReportCategory.func_71507_a("Sprite", (Object)sprite);
                throw new ReportedException(crashReport);
            }
        }
        if (!this.animatedSprites.isEmpty()) {
            PBRAtlasHolder pbrHolder = ((TextureAtlasExtension)this.texMap).getOrCreatePBRHolder();
            switch (this.type) {
                case NORMAL: {
                    pbrHolder.setNormalAtlas(this);
                    break;
                }
                case SPECULAR: {
                    pbrHolder.setSpecularAtlas(this);
                }
            }
        }
        if (AngelicaConfig.enablePBRDebug) {
            TextureExporter.exportTextures("pbr_debug/atlas", this.id.func_110624_b() + "_" + this.id.func_110623_a().replaceAll("/", "_"), glId, mipLevel, atlasWidth, atlasHeight);
        }
    }

    public boolean tryUpload(int atlasWidth, int atlasHeight, int mipLevel, float anisotropicFiltering) {
        try {
            this.upload(atlasWidth, atlasHeight, mipLevel, anisotropicFiltering);
            return true;
        }
        catch (Throwable t) {
            Iris.logger.error("Could not upload PBR texture", t);
            return false;
        }
    }

    public void func_110551_a(IResourceManager manager) throws IOException {
    }

    protected void uploadSprite(TextureAtlasSprite sprite) {
        if (sprite.field_110982_k.func_110473_c() > 1) {
            AnimationMetadataSection metadata = sprite.field_110982_k;
            int frameCount = sprite.func_110970_k();
            for (int frame = sprite.field_110973_g; frame >= 0; --frame) {
                int frameIndex = metadata.func_110468_c(frame);
                if (frameIndex < 0 || frameIndex >= frameCount) continue;
                TextureUtil.func_147955_a((int[][])sprite.func_147965_a(frameIndex), (int)sprite.func_94211_a(), (int)sprite.func_94216_b(), (int)sprite.func_130010_a(), (int)sprite.func_110967_i(), (boolean)false, (boolean)false);
                return;
            }
        }
        TextureUtil.func_147955_a((int[][])sprite.func_147965_a(0), (int)sprite.func_94211_a(), (int)sprite.func_94216_b(), (int)sprite.func_130010_a(), (int)sprite.func_110967_i(), (boolean)false, (boolean)false);
    }

    public void cycleAnimationFrames() {
        this.bind();
        for (TextureAtlasSprite sprite : this.animatedSprites) {
            sprite.func_94219_l();
        }
    }

    @Override
    public void close() {
        PBRAtlasHolder pbrHolder = ((TextureAtlasExtension)this.texMap).getPBRHolder();
        if (pbrHolder != null) {
            switch (this.type) {
                case NORMAL: {
                    pbrHolder.setNormalAtlas(null);
                    break;
                }
                case SPECULAR: {
                    pbrHolder.setSpecularAtlas(null);
                }
            }
        }
    }

    @Generated
    public PBRType getType() {
        return this.type;
    }
}

