/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.rendering.AngelicaRenderQueue;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderRebuildTask;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderTranslucencySortTask;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderCacheLocal;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import me.jellysquid.mods.sodium.common.util.collections.DequeDrain;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class ChunkBuilder<T extends ChunkGraphicsState> {
    private static final int TASK_QUEUE_LIMIT_PER_WORKER = 2;
    private static final Logger LOGGER = LogManager.getLogger((String)"ChunkBuilder");
    private final Deque<WrappedTask<T>> buildQueue = new ConcurrentLinkedDeque<WrappedTask<T>>();
    private final Deque<ChunkBuildResult<T>> uploadQueue = new ConcurrentLinkedDeque<ChunkBuildResult<T>>();
    private final Deque<Throwable> failureQueue = new ConcurrentLinkedDeque<Throwable>();
    private final Object jobNotifier = new Object();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final List<Thread> threads = new ArrayList<Thread>();
    private ClonedChunkSectionCache sectionCache;
    private WorldClient world;
    private Vector3d cameraPosition = new Vector3d();
    private final int limitThreads;
    private final ChunkVertexType vertexType;
    private final ChunkRenderBackend<T> backend;

    public ChunkBuilder(ChunkVertexType vertexType, ChunkRenderBackend<T> backend) {
        this.vertexType = vertexType;
        this.backend = backend;
        this.limitThreads = ChunkBuilder.getThreadCount();
    }

    public int getSchedulingBudget() {
        return Math.max(0, this.limitThreads * 2 - this.buildQueue.size());
    }

    public void startWorkers() {
        if (this.running.getAndSet(true)) {
            return;
        }
        if (!this.threads.isEmpty()) {
            throw new IllegalStateException("Threads are still alive while in the STOPPED state");
        }
        Minecraft client = Minecraft.func_71410_x();
        for (int i = 0; i < this.limitThreads; ++i) {
            ChunkBuildBuffers buffers = new ChunkBuildBuffers(this.vertexType);
            ChunkRenderCacheLocal pipeline = new ChunkRenderCacheLocal(client, this.world);
            WorkerRunnable worker = new WorkerRunnable(buffers, pipeline);
            Thread thread = new Thread((Runnable)worker, "Chunk Render Task Executor #" + i);
            thread.setPriority(Math.max(0, 3));
            thread.start();
            this.threads.add(thread);
        }
        LOGGER.info("Started {} worker threads", new Object[]{this.threads.size()});
    }

    private boolean workersAlive() {
        for (Thread thread : this.threads) {
            if (!thread.isAlive()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWorkers() {
        if (!this.running.getAndSet(false)) {
            return;
        }
        if (this.threads.isEmpty()) {
            throw new IllegalStateException("No threads are alive but the executor is in the RUNNING state");
        }
        LOGGER.info("Stopping worker threads");
        Iterator<Object> iterator = this.jobNotifier;
        synchronized (iterator) {
            this.jobNotifier.notifyAll();
        }
        AngelicaRenderQueue.managedBlock(() -> !this.workersAlive());
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.threads.clear();
        this.uploadQueue.clear();
        this.failureQueue.clear();
        for (WrappedTask wrappedTask : this.buildQueue) {
            wrappedTask.future.cancel(true);
        }
        this.buildQueue.clear();
        this.world = null;
        this.sectionCache = null;
    }

    public void cleanupSectionCache() {
        this.sectionCache.cleanup();
    }

    public Iterator<ChunkBuildResult<T>> filterChunkBuilds(Iterator<ChunkBuildResult<T>> uploadIterator) {
        Reference2ReferenceLinkedOpenHashMap map = new Reference2ReferenceLinkedOpenHashMap();
        while (uploadIterator.hasNext()) {
            ChunkBuildResult<T> result = uploadIterator.next();
            ChunkRenderContainer section = result.render;
            ChunkBuildResult oldResult = (ChunkBuildResult)map.get(section);
            if (oldResult != null && result.passesToUpload.length < oldResult.passesToUpload.length) continue;
            map.put(section, result);
        }
        return map.values().iterator();
    }

    public boolean performPendingUploads() {
        if (this.uploadQueue.isEmpty()) {
            return false;
        }
        this.backend.upload(RenderDevice.INSTANCE.createCommandList(), this.filterChunkBuilds(new DequeDrain<ChunkBuildResult<T>>(this.uploadQueue)));
        return true;
    }

    public void handleFailures() {
        DequeDrain<Throwable> errorIterator = new DequeDrain<Throwable>(this.failureQueue);
        if (errorIterator.hasNext()) {
            Throwable ex = (Throwable)errorIterator.next();
            if (ex instanceof ReportedException) {
                throw (ReportedException)ex;
            }
            throw new RuntimeException("Chunk build failed", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<ChunkBuildResult<T>> schedule(ChunkRenderBuildTask<T> task) {
        if (!this.running.get()) {
            throw new IllegalStateException("Executor is stopped");
        }
        WrappedTask job = new WrappedTask(task);
        this.buildQueue.add(job);
        Object object = this.jobNotifier;
        synchronized (object) {
            this.jobNotifier.notify();
        }
        return job.future;
    }

    public void setCameraPosition(double x, double y, double z) {
        this.cameraPosition = new Vector3d(x, y, z);
    }

    public Vector3d getCameraPosition() {
        return this.cameraPosition;
    }

    public boolean isBuildQueueEmpty() {
        return this.buildQueue.isEmpty();
    }

    public void init(WorldClient world) {
        if (world == null) {
            throw new NullPointerException("World is null");
        }
        this.stopWorkers();
        this.world = world;
        this.sectionCache = new ClonedChunkSectionCache((World)this.world);
        this.startWorkers();
    }

    private static int getOptimalThreadCount() {
        return MathHelper.func_76125_a((int)Math.max(ChunkBuilder.getMaxThreadCount() / 3, ChunkBuilder.getMaxThreadCount() - 6), (int)1, (int)10);
    }

    private static int getThreadCount() {
        int requested = SodiumClientMod.options().performance.chunkBuilderThreads;
        return requested == 0 ? ChunkBuilder.getOptimalThreadCount() : Math.min(requested, ChunkBuilder.getMaxThreadCount());
    }

    private static int getMaxThreadCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public void handleCompletion(CompletableFuture<ChunkBuildResult<T>> future) {
        future.whenComplete((res, ex) -> {
            if (ex != null) {
                this.failureQueue.add((Throwable)ex);
            } else if (res != null) {
                this.enqueueUpload((ChunkBuildResult<T>)res);
            }
        });
    }

    public void deferSort(ChunkRenderContainer<T> render) {
        this.handleCompletion(this.scheduleSortTaskAsync(render));
    }

    public void enqueueUpload(ChunkBuildResult<T> result) {
        this.uploadQueue.add(result);
    }

    @Nullable
    public CompletableFuture<ChunkBuildResult<T>> scheduleRebuildTaskAsync(ChunkRenderContainer<T> render) {
        ChunkRenderBuildTask<T> task = this.createRebuildTask(render);
        if (task != null) {
            return this.schedule(task);
        }
        return null;
    }

    public CompletableFuture<ChunkBuildResult<T>> scheduleSortTaskAsync(ChunkRenderContainer<T> render) {
        return this.schedule(this.createSortTask(render));
    }

    private ChunkRenderBuildTask<T> createRebuildTask(ChunkRenderContainer<T> render) {
        render.cancelRebuildTask();
        ChunkRenderContext context = WorldSlice.prepare((World)this.world, render.getChunkPos(), this.sectionCache);
        if (context == null) {
            return null;
        }
        return new ChunkRenderRebuildTask<T>(render, context, render.getRenderOrigin()).withCameraPosition(this.cameraPosition);
    }

    private ChunkRenderBuildTask<T> createSortTask(ChunkRenderContainer<T> render) {
        render.cancelRebuildTask();
        return new ChunkRenderTranslucencySortTask<T>(render, render.getRenderOrigin(), this.cameraPosition);
    }

    public void onChunkDataChanged(int x, int y, int z) {
        this.sectionCache.invalidate(x, y, z);
    }

    private class WorkerRunnable
    implements Runnable {
        private final AtomicBoolean running;
        private final ChunkBuildBuffers bufferCache;
        private final ChunkRenderCacheLocal cache;

        public WorkerRunnable(ChunkBuildBuffers bufferCache, ChunkRenderCacheLocal cache) {
            this.running = ChunkBuilder.this.running;
            this.bufferCache = bufferCache;
            this.cache = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running.get()) {
                ChunkBuildResult result;
                WrappedTask job = this.getNextJob();
                if (job == null || job.isCancelled()) continue;
                try {
                    result = job.task.performBuild(this.cache, this.bufferCache, job);
                }
                catch (Exception e) {
                    job.future.completeExceptionally(e);
                    continue;
                }
                finally {
                    job.task.releaseResources();
                    continue;
                }
                if (result != null) {
                    job.future.complete(result);
                    LockSupport.unpark(GLStateManager.getMainThread());
                    continue;
                }
                if (job.isCancelled()) continue;
                job.future.completeExceptionally(new RuntimeException("No result was produced by the task " + job.task.getClass() + ": " + job.task));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WrappedTask<T> getNextJob() {
            WrappedTask job = (WrappedTask)ChunkBuilder.this.buildQueue.poll();
            if (job == null) {
                Object object = ChunkBuilder.this.jobNotifier;
                synchronized (object) {
                    try {
                        ChunkBuilder.this.jobNotifier.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return job;
        }
    }

    private static class WrappedTask<T extends ChunkGraphicsState>
    implements CancellationSource {
        private final ChunkRenderBuildTask<T> task;
        private final CompletableFuture<ChunkBuildResult<T>> future;

        private WrappedTask(ChunkRenderBuildTask<T> task) {
            this.task = task;
            this.future = new CompletableFuture();
            this.future.exceptionally(e -> {
                LOGGER.info("Exception thrown while building chunk", e);
                return null;
            });
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }
    }
}

