/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.builtin.BuiltinReplacementUniforms;

public class SodiumTerrainPipeline {
    Optional<String> terrainVertex = Optional.empty();
    Optional<String> terrainGeometry = Optional.empty();
    Optional<String> terrainFragment = Optional.empty();
    Optional<String> translucentVertex = Optional.empty();
    Optional<String> translucentGeometry = Optional.empty();
    Optional<String> translucentFragment = Optional.empty();
    Optional<String> shadowVertex = Optional.empty();
    Optional<String> shadowGeometry = Optional.empty();
    Optional<String> shadowFragment = Optional.empty();
    ProgramSet programSet;
    private final WorldRenderingPipeline parent;
    private final IntFunction<ProgramSamplers> createTerrainSamplers;
    private final IntFunction<ProgramSamplers> createShadowSamplers;
    private final IntFunction<ProgramImages> createTerrainImages;
    private final IntFunction<ProgramImages> createShadowImages;

    public SodiumTerrainPipeline(WorldRenderingPipeline parent, ProgramSet programSet, IntFunction<ProgramSamplers> createTerrainSamplers, IntFunction<ProgramSamplers> createShadowSamplers, IntFunction<ProgramImages> createTerrainImages, IntFunction<ProgramImages> createShadowImages) {
        this.parent = Objects.requireNonNull(parent);
        Optional<ProgramSource> terrainSource = SodiumTerrainPipeline.first(programSet.getGbuffersTerrain(), programSet.getGbuffersTexturedLit(), programSet.getGbuffersTextured(), programSet.getGbuffersBasic());
        Optional<ProgramSource> translucentSource = SodiumTerrainPipeline.first(programSet.getGbuffersWater(), terrainSource);
        Optional<ProgramSource> shadowSource = programSet.getShadow();
        this.programSet = programSet;
        terrainSource.ifPresent(sources -> {
            Map<PatchShaderType, String> result = TransformPatcher.patchSodiumTerrain(sources.getVertexSource().orElse(null), sources.getGeometrySource().orElse(null), sources.getFragmentSource().orElse(null));
            this.terrainVertex = Optional.ofNullable(result.get((Object)PatchShaderType.VERTEX));
            this.terrainGeometry = Optional.ofNullable(result.get((Object)PatchShaderType.GEOMETRY));
            this.terrainFragment = Optional.ofNullable(result.get((Object)PatchShaderType.FRAGMENT));
            PatchedShaderPrinter.debugPatchedShaders(sources.getName() + "_sodium", this.terrainVertex.orElse(null), this.terrainGeometry.orElse(null), this.terrainFragment.orElse(null));
        });
        translucentSource.ifPresent(sources -> {
            Map<PatchShaderType, String> result = TransformPatcher.patchSodiumTerrain(sources.getVertexSource().orElse(null), sources.getGeometrySource().orElse(null), sources.getFragmentSource().orElse(null));
            this.translucentVertex = Optional.ofNullable(result.get((Object)PatchShaderType.VERTEX));
            this.translucentGeometry = Optional.ofNullable(result.get((Object)PatchShaderType.GEOMETRY));
            this.translucentFragment = Optional.ofNullable(result.get((Object)PatchShaderType.FRAGMENT));
            PatchedShaderPrinter.debugPatchedShaders(sources.getName() + "_sodium", this.translucentVertex.orElse(null), this.translucentGeometry.orElse(null), this.translucentFragment.orElse(null));
        });
        shadowSource.ifPresent(sources -> {
            Map<PatchShaderType, String> result = TransformPatcher.patchSodiumTerrain(sources.getVertexSource().orElse(null), sources.getGeometrySource().orElse(null), sources.getFragmentSource().orElse(null));
            this.shadowVertex = Optional.ofNullable(result.get((Object)PatchShaderType.VERTEX));
            this.shadowGeometry = Optional.ofNullable(result.get((Object)PatchShaderType.GEOMETRY));
            this.shadowFragment = Optional.ofNullable(result.get((Object)PatchShaderType.FRAGMENT));
            PatchedShaderPrinter.debugPatchedShaders(sources.getName() + "_sodium", this.shadowVertex.orElse(null), this.shadowGeometry.orElse(null), this.shadowFragment.orElse(null));
        });
        this.createTerrainSamplers = createTerrainSamplers;
        this.createShadowSamplers = createShadowSamplers;
        this.createTerrainImages = createTerrainImages;
        this.createShadowImages = createShadowImages;
    }

    public Optional<String> getTerrainVertexShaderSource() {
        return this.terrainVertex;
    }

    public Optional<String> getTerrainGeometryShaderSource() {
        return this.terrainGeometry;
    }

    public Optional<String> getTerrainFragmentShaderSource() {
        return this.terrainFragment;
    }

    public Optional<String> getTranslucentVertexShaderSource() {
        return this.translucentVertex;
    }

    public Optional<String> getTranslucentGeometryShaderSource() {
        return this.translucentGeometry;
    }

    public Optional<String> getTranslucentFragmentShaderSource() {
        return this.translucentFragment;
    }

    public Optional<String> getShadowVertexShaderSource() {
        return this.shadowVertex;
    }

    public Optional<String> getShadowGeometryShaderSource() {
        return this.shadowGeometry;
    }

    public Optional<String> getShadowFragmentShaderSource() {
        return this.shadowFragment;
    }

    public ProgramUniforms initUniforms(int programId) {
        ProgramUniforms.Builder uniforms = ProgramUniforms.builder("<sodium shaders>", programId);
        CommonUniforms.addCommonUniforms(uniforms, this.programSet.getPack().getIdMap(), this.programSet.getPackDirectives(), this.parent.getFrameUpdateNotifier());
        BuiltinReplacementUniforms.addBuiltinReplacementUniforms(uniforms);
        return uniforms.buildUniforms();
    }

    public boolean hasShadowPass() {
        return this.createShadowSamplers != null;
    }

    public ProgramSamplers initTerrainSamplers(int programId) {
        return this.createTerrainSamplers.apply(programId);
    }

    public ProgramSamplers initShadowSamplers(int programId) {
        return this.createShadowSamplers.apply(programId);
    }

    public ProgramImages initTerrainImages(int programId) {
        return this.createTerrainImages.apply(programId);
    }

    public ProgramImages initShadowImages(int programId) {
        return this.createShadowImages.apply(programId);
    }

    @SafeVarargs
    private static <T> Optional<T> first(Optional<T> ... candidates) {
        for (Optional<T> candidate : candidates) {
            if (!candidate.isPresent()) continue;
            return candidate;
        }
        return Optional.empty();
    }
}

