/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.rendertarget;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.PixelFormat;
import net.coderbot.iris.gl.texture.PixelType;
import org.joml.Vector2i;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RenderTarget {
    private final InternalTextureFormat internalFormat;
    private final PixelFormat format;
    private final PixelType type;
    private int width;
    private int height;
    private boolean isValid = true;
    private final int mainTexture;
    private final int altTexture;
    private static final ByteBuffer NULL_BUFFER = null;
    private final IntBuffer deleteBuffer = BufferUtils.createIntBuffer((int)2);

    public RenderTarget(Builder builder) {
        this.internalFormat = builder.internalFormat;
        this.format = builder.format;
        this.type = builder.type;
        this.width = builder.width;
        this.height = builder.height;
        IntBuffer textures = BufferUtils.createIntBuffer((int)2);
        GL11.glGenTextures((IntBuffer)textures);
        this.mainTexture = textures.get(0);
        this.altTexture = textures.get(1);
        boolean isPixelFormatInteger = builder.internalFormat.getPixelFormat().isInteger();
        this.setupTexture(this.mainTexture, builder.width, builder.height, !isPixelFormatInteger);
        this.setupTexture(this.altTexture, builder.width, builder.height, !isPixelFormatInteger);
        GLStateManager.glBindTexture(3553, 0);
    }

    private void setupTexture(int texture, int width, int height, boolean allowsLinear) {
        this.resizeTexture(texture, width, height);
        RenderSystem.texParameteri(texture, 3553, 10241, allowsLinear ? 9729 : 9728);
        RenderSystem.texParameteri(texture, 3553, 10240, allowsLinear ? 9729 : 9728);
        RenderSystem.texParameteri(texture, 3553, 10242, 33071);
        RenderSystem.texParameteri(texture, 3553, 10243, 33071);
    }

    private void resizeTexture(int texture, int width, int height) {
        RenderSystem.texImage2D(texture, 3553, 0, this.internalFormat.getGlFormat(), width, height, 0, this.format.getGlFormat(), this.type.getGlFormat(), NULL_BUFFER);
    }

    void resize(Vector2i textureScaleOverride) {
        this.resize(textureScaleOverride.x, textureScaleOverride.y);
    }

    void resize(int width, int height) {
        this.requireValid();
        this.width = width;
        this.height = height;
        this.resizeTexture(this.mainTexture, width, height);
        this.resizeTexture(this.altTexture, width, height);
    }

    public int getMainTexture() {
        this.requireValid();
        return this.mainTexture;
    }

    public int getAltTexture() {
        this.requireValid();
        return this.altTexture;
    }

    public void destroy() {
        this.requireValid();
        this.isValid = false;
        this.deleteBuffer.put(0, this.mainTexture);
        this.deleteBuffer.put(1, this.altTexture);
        GLStateManager.glDeleteTextures(this.deleteBuffer);
    }

    private void requireValid() {
        if (!this.isValid) {
            throw new IllegalStateException("Attempted to use a deleted composite render target");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public InternalTextureFormat getInternalFormat() {
        return this.internalFormat;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static class Builder {
        private InternalTextureFormat internalFormat = InternalTextureFormat.RGBA8;
        private int width = 0;
        private int height = 0;
        private PixelFormat format = PixelFormat.RGBA;
        private PixelType type = PixelType.UNSIGNED_BYTE;

        private Builder() {
        }

        public Builder setInternalFormat(InternalTextureFormat format) {
            this.internalFormat = format;
            return this;
        }

        public Builder setDimensions(int width, int height) {
            if (width <= 0) {
                throw new IllegalArgumentException("Width must be greater than zero");
            }
            if (height <= 0) {
                throw new IllegalArgumentException("Height must be greater than zero");
            }
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder setPixelFormat(PixelFormat pixelFormat) {
            this.format = pixelFormat;
            return this;
        }

        public Builder setPixelType(PixelType pixelType) {
            this.type = pixelType;
            return this;
        }

        public RenderTarget build() {
            return new RenderTarget(this);
        }
    }
}

