/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.occlusion;

import com.gtnewhorizons.angelica.compat.mojang.BlockPosImpl;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockOcclusionCache {
    private static final byte UNCACHED_VALUE = 127;
    private final Object2ByteLinkedOpenHashMap<CachedOcclusionShapeTest> map;
    private final CachedOcclusionShapeTest cachedTest = new CachedOcclusionShapeTest();
    private final BlockPosImpl cpos = new BlockPosImpl();

    public BlockOcclusionCache() {
        this.map = new Object2ByteLinkedOpenHashMap(2048, 0.5f);
        this.map.defaultReturnValue((byte)127);
    }

    public boolean shouldDrawSide(Block block, int meta, IBlockAccess view, BlockPosImpl pos, ForgeDirection facing) {
        if (facing == ForgeDirection.UNKNOWN) {
            return true;
        }
        BlockPosImpl adjPos = this.cpos;
        adjPos.set(pos.getX() + facing.offsetX, pos.getY() + facing.offsetY, pos.getZ() + facing.offsetZ);
        Block adjState = view.func_147439_a(adjPos.x, adjPos.y, adjPos.z);
        return !adjState.func_149662_c();
    }

    private boolean calculate(Block selfShape, Block adjShape) {
        CachedOcclusionShapeTest cache = this.cachedTest;
        cache.a = selfShape;
        cache.b = adjShape;
        cache.updateHash();
        byte cached = this.map.getByte((Object)cache);
        if (cached != 127) {
            return cached == 1;
        }
        boolean ret = adjShape.func_149662_c() && selfShape.func_149662_c();
        this.map.put((Object)cache.copy(), (byte)(ret ? 1 : 0));
        if (this.map.size() > 2048) {
            this.map.removeFirstByte();
        }
        return ret;
    }

    private static final class CachedOcclusionShapeTest {
        private Block a;
        private Block b;
        private int hashCode;

        private CachedOcclusionShapeTest() {
        }

        private CachedOcclusionShapeTest(Block a, Block b, int hashCode) {
            this.a = a;
            this.b = b;
            this.hashCode = hashCode;
        }

        public void updateHash() {
            int result = System.identityHashCode(this.a);
            this.hashCode = result = 31 * result + System.identityHashCode(this.b);
        }

        public CachedOcclusionShapeTest copy() {
            return new CachedOcclusionShapeTest(this.a, this.b, this.hashCode);
        }

        public boolean equals(Object o) {
            if (o instanceof CachedOcclusionShapeTest) {
                CachedOcclusionShapeTest that = (CachedOcclusionShapeTest)o;
                return this.a == that.a && this.b == that.b;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

