/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.quad.properties;

import net.minecraftforge.common.util.ForgeDirection;
import org.joml.Vector3f;

public enum ModelQuadFacing {
    UP,
    DOWN,
    EAST,
    WEST,
    SOUTH,
    NORTH,
    UNASSIGNED;

    public static final ModelQuadFacing[] VALUES;
    public static final int COUNT;

    public static ModelQuadFacing fromDirection(ForgeDirection dir) {
        ModelQuadFacing modelQuadFacing;
        switch (dir) {
            case DOWN: {
                modelQuadFacing = DOWN;
                break;
            }
            case UP: {
                modelQuadFacing = UP;
                break;
            }
            case NORTH: {
                modelQuadFacing = NORTH;
                break;
            }
            case SOUTH: {
                modelQuadFacing = SOUTH;
                break;
            }
            case WEST: {
                modelQuadFacing = WEST;
                break;
            }
            case EAST: {
                modelQuadFacing = EAST;
                break;
            }
            default: {
                modelQuadFacing = UNASSIGNED;
            }
        }
        return modelQuadFacing;
    }

    public static ForgeDirection toDirection(ModelQuadFacing dir) {
        ForgeDirection forgeDirection;
        switch (dir) {
            case DOWN: {
                forgeDirection = ForgeDirection.DOWN;
                break;
            }
            case UP: {
                forgeDirection = ForgeDirection.UP;
                break;
            }
            case NORTH: {
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            case SOUTH: {
                forgeDirection = ForgeDirection.SOUTH;
                break;
            }
            case WEST: {
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case EAST: {
                forgeDirection = ForgeDirection.EAST;
                break;
            }
            default: {
                forgeDirection = ForgeDirection.UNKNOWN;
            }
        }
        return forgeDirection;
    }

    public static ModelQuadFacing fromVector(Vector3f normal) {
        if (normal.x == 0.0f) {
            if (normal.y == 0.0f) {
                if (normal.z > 0.0f) {
                    return SOUTH;
                }
                if (normal.z < 0.0f) {
                    return NORTH;
                }
            } else if (normal.z == 0.0f) {
                if (normal.y > 0.0f) {
                    return UP;
                }
                if (normal.y < 0.0f) {
                    return DOWN;
                }
            }
        } else if (normal.y == 0.0f && normal.z == 0.0f) {
            if (normal.x > 0.0f) {
                return EAST;
            }
            if (normal.x < 0.0f) {
                return WEST;
            }
        }
        return UNASSIGNED;
    }

    public ModelQuadFacing getOpposite() {
        ModelQuadFacing modelQuadFacing;
        switch (this) {
            case UP: {
                modelQuadFacing = DOWN;
                break;
            }
            case DOWN: {
                modelQuadFacing = UP;
                break;
            }
            case EAST: {
                modelQuadFacing = WEST;
                break;
            }
            case WEST: {
                modelQuadFacing = EAST;
                break;
            }
            case SOUTH: {
                modelQuadFacing = NORTH;
                break;
            }
            case NORTH: {
                modelQuadFacing = SOUTH;
                break;
            }
            default: {
                modelQuadFacing = UNASSIGNED;
            }
        }
        return modelQuadFacing;
    }

    static {
        VALUES = ModelQuadFacing.values();
        COUNT = VALUES.length;
    }
}

