/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.light.flat;

import com.gtnewhorizons.angelica.compat.mojang.BlockPosImpl;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.minecraftforge.common.util.ForgeDirection;

public class FlatLightPipeline
implements LightPipeline {
    private final LightDataAccess lightCache;

    public FlatLightPipeline(LightDataAccess lightCache) {
        this.lightCache = lightCache;
    }

    @Override
    public void calculate(ModelQuadView quad, BlockPosImpl pos, QuadLightData out, ForgeDirection cullFace, ForgeDirection face, boolean shade) {
        int flags;
        int lightmap = cullFace != null ? this.getOffsetLightmap(pos, cullFace) : (((flags = quad.getFlags()) & 4) != 0 || (flags & 2) != 0 && LightDataAccess.unpackFC(this.lightCache.get(pos)) ? this.getOffsetLightmap(pos, face) : LightDataAccess.getLightMap(this.lightCache.get(pos), pos));
        Arrays.fill(out.lm, lightmap);
        float brightness = AngelicaConfig.enableIris && BlockRenderingSettings.INSTANCE.shouldDisableDirectionalShading() ? 1.0f : this.lightCache.getWorld().getBrightness(face, shade);
        Arrays.fill(out.br, brightness);
    }

    private int getOffsetLightmap(BlockPosImpl pos, ForgeDirection face) {
        int lightmap = LightDataAccess.getLightMap(this.lightCache.get(pos, face), pos);
        if ((lightmap & 0xF0) != 240) {
            int originLightmap = LightDataAccess.getLightMap(this.lightCache.get(pos), pos);
            lightmap = lightmap & 0xFFFFFF00 | Math.max(lightmap & 0xFF, originLightmap & 0xFF);
        }
        return lightmap;
    }
}

