/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.light.data;

import com.gtnewhorizons.angelica.compat.mojang.BlockPosImpl;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLights;
import me.jellysquid.mods.sodium.client.util.StateUtil;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class LightDataAccess {
    private final BlockPosImpl pos = new BlockPosImpl();
    protected WorldSlice world;

    public long get(int x, int y, int z, ForgeDirection d1, ForgeDirection d2) {
        return this.get(x + d1.offsetX + d2.offsetX, y + d1.offsetY + d2.offsetY, z + d1.offsetZ + d2.offsetZ);
    }

    public long get(int x, int y, int z, ForgeDirection dir) {
        return this.get(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
    }

    public long get(BlockPosImpl pos, ForgeDirection dir) {
        return this.get(pos.x, pos.y, pos.z, dir);
    }

    public long get(BlockPosImpl pos) {
        return this.get(pos.x, pos.y, pos.getZ());
    }

    public abstract long get(int var1, int var2, int var3);

    protected long compute(int x, int y, int z) {
        boolean em;
        float ao;
        WorldSlice world = this.world;
        Block block = world.func_147439_a(x, y, z);
        if (block.func_149750_m() == 0) {
            ao = block.func_149685_I();
            em = false;
        } else {
            ao = 1.0f;
            em = true;
        }
        boolean op = !block.func_149662_c() || block.func_149717_k() == 0;
        boolean fo = block.func_149662_c();
        boolean fc = StateUtil.areBoundsFullCube(block);
        int lm = fo && !em ? 0 : block.func_149677_c((IBlockAccess)world, x, y, z);
        return LightDataAccess.packAO(ao) | LightDataAccess.packLM(lm) | LightDataAccess.packOP(op) | LightDataAccess.packFO(fo) | LightDataAccess.packFC(fc) | 0x1000000000000000L;
    }

    public static long packOP(boolean opaque) {
        return (opaque ? 1L : 0L) << 56;
    }

    public static boolean unpackOP(long word) {
        return (word >>> 56 & 1L) != 0L;
    }

    public static long packFO(boolean opaque) {
        return (opaque ? 1L : 0L) << 57;
    }

    public static boolean unpackFO(long word) {
        return (word >>> 57 & 1L) != 0L;
    }

    public static long packFC(boolean fullCube) {
        return (fullCube ? 1L : 0L) << 58;
    }

    public static boolean unpackFC(long word) {
        return (word >>> 58 & 1L) != 0L;
    }

    public static long packLM(int lm) {
        return (long)lm & 0xFFFFFFFFL;
    }

    public static int unpackLM(long word) {
        return (int)(word & 0xFFFFFFFFL);
    }

    public static long packAO(float ao) {
        int aoi = (int)(ao * 4096.0f);
        return ((long)aoi & 0xFFFFL) << 32;
    }

    public static float unpackAO(long word) {
        int aoi = (int)(word >>> 32 & 0xFFFFL);
        return (float)aoi * 2.4414062E-4f;
    }

    public static int getLightMap(long originWord, BlockPosImpl pos) {
        if (!DynamicLights.isEnabled()) {
            return LightDataAccess.unpackLM(originWord);
        }
        if (LightDataAccess.unpackFO(originWord)) {
            return LightDataAccess.unpackLM(originWord);
        }
        double dynamic = DynamicLights.get().getDynamicLightLevel(pos);
        return DynamicLights.get().getLightmapWithDynamicLight(dynamic, LightDataAccess.unpackLM(originWord));
    }

    public WorldSlice getWorld() {
        return this.world;
    }
}

