/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.ctm.ITileOverride;
import com.prupe.mcpatcher.ctm.RenderBlockState;
import com.prupe.mcpatcher.mal.block.BlockStateMatcher;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jss.notfine.config.MCPatcherForgeConfig;
import net.minecraft.block.Block;
import net.minecraft.util.IIcon;

public abstract class TileOverrideIterator
implements Iterator<ITileOverride> {
    private static final int MAX_RECURSION = MCPatcherForgeConfig.instance().maxRecursion;
    private final Map<Block, List<BlockStateMatcher>> allBlockOverrides;
    private final Map<String, List<ITileOverride>> allTileOverrides;
    protected IIcon currentIcon;
    private List<BlockStateMatcher> blockOverrides;
    private List<ITileOverride> tileOverrides;
    private final Set<ITileOverride> skipOverrides = new HashSet<ITileOverride>();
    private RenderBlockState renderBlockState;
    private int blockPos;
    private int iconPos;
    private boolean foundNext;
    private ITileOverride nextOverride;
    private ITileOverride lastMatchedOverride;

    protected TileOverrideIterator(Map<Block, List<BlockStateMatcher>> allBlockOverrides, Map<String, List<ITileOverride>> allTileOverrides) {
        this.allBlockOverrides = allBlockOverrides;
        this.allTileOverrides = allTileOverrides;
    }

    synchronized void clear() {
        this.currentIcon = null;
        this.blockOverrides = null;
        this.tileOverrides = null;
        this.nextOverride = null;
        this.lastMatchedOverride = null;
        this.skipOverrides.clear();
    }

    private synchronized void resetForNextPass() {
        this.blockOverrides = null;
        this.tileOverrides = this.allTileOverrides.get(this.currentIcon.func_94215_i());
        this.blockPos = 0;
        this.iconPos = 0;
        this.foundNext = false;
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.foundNext) {
            return true;
        }
        if (this.tileOverrides != null) {
            while (this.iconPos < this.tileOverrides.size()) {
                if (!this.checkOverride(this.tileOverrides.get(this.iconPos++))) continue;
                this.renderBlockState.setFilter(null);
                return true;
            }
        }
        if (this.blockOverrides != null) {
            while (this.blockPos < this.blockOverrides.size()) {
                BlockStateMatcher matcher;
                if (!this.renderBlockState.match(matcher = this.blockOverrides.get(this.blockPos++)) || !this.checkOverride((ITileOverride)matcher.getData())) continue;
                this.renderBlockState.setFilter(matcher);
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized ITileOverride next() {
        if (!this.foundNext) {
            throw new IllegalStateException("next called before hasNext() == true");
        }
        this.foundNext = false;
        return this.nextOverride;
    }

    @Override
    public synchronized void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    private synchronized boolean checkOverride(ITileOverride override) {
        if (override != null && !override.isDisabled() && !this.skipOverrides.contains(override)) {
            this.foundNext = true;
            this.nextOverride = override;
            return true;
        }
        return false;
    }

    public synchronized ITileOverride go(RenderBlockState renderBlockState, IIcon origIcon) {
        this.renderBlockState = renderBlockState;
        renderBlockState.setFilter(null);
        this.currentIcon = origIcon;
        this.blockOverrides = this.allBlockOverrides.get(renderBlockState.getBlock());
        this.tileOverrides = this.allTileOverrides.get(origIcon.func_94215_i());
        this.blockPos = 0;
        this.iconPos = 0;
        this.foundNext = false;
        this.nextOverride = null;
        this.lastMatchedOverride = null;
        this.skipOverrides.clear();
        block0: for (int pass = 0; pass < MAX_RECURSION; ++pass) {
            while (this.hasNext()) {
                ITileOverride override = this.next();
                IIcon newIcon = this.getTile(override, renderBlockState, origIcon);
                if (newIcon == null) continue;
                this.lastMatchedOverride = override;
                this.skipOverrides.add(override);
                this.currentIcon = newIcon;
                this.resetForNextPass();
                continue block0;
            }
            break block0;
        }
        return this.lastMatchedOverride;
    }

    public synchronized IIcon getIcon() {
        return this.currentIcon;
    }

    protected abstract IIcon getTile(ITileOverride var1, RenderBlockState var2, IIcon var3);

    public static final class Metadata
    extends TileOverrideIterator {
        Metadata(Map<Block, List<BlockStateMatcher>> blockOverrides, Map<String, List<ITileOverride>> tileOverrides) {
            super(blockOverrides, tileOverrides);
        }

        @Override
        protected synchronized IIcon getTile(ITileOverride override, RenderBlockState renderBlockState, IIcon origIcon) {
            return override.getTileHeld(renderBlockState, origIcon);
        }
    }

    public static final class IJK
    extends TileOverrideIterator {
        IJK(Map<Block, List<BlockStateMatcher>> blockOverrides, Map<String, List<ITileOverride>> tileOverrides) {
            super(blockOverrides, tileOverrides);
        }

        @Override
        protected synchronized IIcon getTile(ITileOverride override, RenderBlockState renderBlockState, IIcon origIcon) {
            return override.getTileWorld(renderBlockState, origIcon);
        }
    }
}

