/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.transform.compat;

import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class ExtraUtilsTransformer
implements IClassTransformer {
    private static final String RenderBlockColor = "com.rwtema.extrautils.block.render.RenderBlockColor";
    private static final String RenderBlockConnectedTextures = "com.rwtema.extrautils.block.render.RenderBlockConnectedTextures";
    private static final String RenderBlockConnectedTexturesEthereal = "com.rwtema.extrautils.block.render.RenderBlockConnectedTexturesEthereal";
    private static final String RenderBlockFullBright = "com.rwtema.extrautils.block.render.RenderBlockFullBright";
    private static final String RenderBlockSpike = "com.rwtema.extrautils.block.render.RenderBlockSpike";
    private static final List<String> transformedClasses = Arrays.asList("com.rwtema.extrautils.block.render.RenderBlockColor", "com.rwtema.extrautils.block.render.RenderBlockConnectedTextures", "com.rwtema.extrautils.block.render.RenderBlockConnectedTexturesEthereal", "com.rwtema.extrautils.block.render.RenderBlockFullBright", "com.rwtema.extrautils.block.render.RenderBlockSpike");
    private static final Map<String, Boolean> perThreadMap = new HashMap<String, Boolean>();

    public byte[] transform(String className, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (!transformedClasses.contains(transformedName)) {
            return basicClass;
        }
        AngelicaTweaker.LOGGER.info("Adding ThreadSafeISBRH for Extra Utilities to: {}", new Object[]{transformedName});
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        this.addThreadSafeISBRHAnnotation(transformedName, cn);
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public void addThreadSafeISBRHAnnotation(String transformedName, ClassNode cn) {
        AnnotationNode isbrhAnnotation = new AnnotationNode("Lcom/gtnewhorizons/angelica/api/ThreadSafeISBRH;");
        Boolean perThread = perThreadMap.get(transformedName);
        if (perThread == null) {
            perThread = false;
            AngelicaTweaker.LOGGER.info("Tried to add ThreadSafeISBRH annotation to {} which is missing from perThreadMap. Using false for perThread.", new Object[]{transformedName});
        }
        isbrhAnnotation.values = Arrays.asList("perThread", perThread);
        if (cn.visibleAnnotations == null) {
            cn.visibleAnnotations = new ArrayList();
        }
        cn.visibleAnnotations.add(isbrhAnnotation);
    }

    static {
        perThreadMap.put(RenderBlockColor, false);
        perThreadMap.put(RenderBlockConnectedTextures, true);
        perThreadMap.put(RenderBlockConnectedTexturesEthereal, true);
        perThreadMap.put(RenderBlockFullBright, false);
        perThreadMap.put(RenderBlockSpike, false);
    }
}

