/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.transform.compat;

import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

public enum CompatASMTransformers {
    EXTRA_UTILITIES_ISBRH("RenderBlockColor Transformer", () -> AngelicaConfig.fixExtraUtilsSodiumCompat, Side.CLIENT, "com.gtnewhorizons.angelica.transform.compat.ExtraUtilsTransformer");

    private final Supplier<Boolean> applyIf;
    private final Side side;
    private final String[] transformerClasses;

    private CompatASMTransformers(String description, Supplier<Boolean> applyIf, Side side, String ... transformers) {
        this.applyIf = applyIf;
        this.side = side;
        this.transformerClasses = transformers;
    }

    private boolean shouldBeLoaded() {
        return this.applyIf.get() != false && this.shouldLoadSide();
    }

    private boolean shouldLoadSide() {
        return this.side == Side.BOTH || this.side == Side.SERVER && FMLLaunchHandler.side().isServer() || this.side == Side.CLIENT && FMLLaunchHandler.side().isClient();
    }

    public static List<String> getTransformers() {
        ArrayList<String> list = new ArrayList<String>();
        for (CompatASMTransformers transformer : CompatASMTransformers.values()) {
            if (transformer.shouldBeLoaded()) {
                AngelicaTweaker.LOGGER.info("Loading transformer {}", (Object[])transformer.transformerClasses);
                list.addAll(Arrays.asList(transformer.transformerClasses));
                continue;
            }
            AngelicaTweaker.LOGGER.info("Not loading transformer {}", (Object[])transformer.transformerClasses);
        }
        return list;
    }

    private static enum Side {
        BOTH,
        CLIENT,
        SERVER;

    }
}

