/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.transform;

import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.Expression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.Statement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.query.Root;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.transform.ASTParser;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class Template<T extends ASTNode> {
    private final Map<ASTNode, Supplier<ASTNode>> replacements = new HashMap<ASTNode, Supplier<ASTNode>>();
    private int localReplacementsMarked = 0;
    private List<ASTNode> localReplacements = Collections.emptyList();
    protected final T source;

    public Template(T source) {
        this.source = source;
    }

    public T getSource() {
        return this.source;
    }

    public Root getSourceRoot() {
        return ((ASTNode)this.source).getRoot();
    }

    public <R> R getReplacement(R original) {
        Supplier<ASTNode> replacementSupplier = this.replacements.get(original);
        return (R)(replacementSupplier == null ? null : replacementSupplier.get());
    }

    public T getSeparateInstance() {
        return (T)((ASTNode)this.source).cloneSeparate();
    }

    public T getInstanceFor(Root root) {
        return (T)((ASTNode)this.source).cloneInto(root);
    }

    public T getInstanceFor(ASTNode treeMember) {
        return (T)((ASTNode)this.source).cloneInto(treeMember);
    }

    public void supplyLocalReplacements(List<ASTNode> replacements) {
        Objects.requireNonNull(replacements);
        if (replacements.size() < this.localReplacementsMarked) {
            throw new IllegalStateException("The local replacements must have enough items for all marked nodes in the template.");
        }
        this.localReplacements = replacements;
    }

    public void supplyLocalReplacements(ASTNode replacement) {
        Objects.requireNonNull(replacement);
        this.supplyLocalReplacements(Collections.singletonList(replacement));
    }

    public void supplyLocalReplacements(ASTNode ... replacements) {
        Objects.requireNonNull(replacements);
        this.supplyLocalReplacements(Arrays.asList(replacements));
    }

    public T getSeparateInstance(List<ASTNode> localReplacements) {
        this.supplyLocalReplacements(localReplacements);
        return this.getSeparateInstance();
    }

    public T getInstanceFor(Root root, List<ASTNode> localReplacements) {
        this.supplyLocalReplacements(localReplacements);
        return this.getInstanceFor(root);
    }

    public T getInstanceFor(ASTNode treeMember, List<ASTNode> localReplacements) {
        this.supplyLocalReplacements(localReplacements);
        return this.getInstanceFor(treeMember);
    }

    public T getSeparateInstance(ASTNode localReplacement) {
        this.supplyLocalReplacements(localReplacement);
        return this.getSeparateInstance();
    }

    public T getInstanceFor(Root root, ASTNode localReplacement) {
        this.supplyLocalReplacements(localReplacement);
        return this.getInstanceFor(root);
    }

    public T getInstanceFor(ASTNode treeMember, ASTNode localReplacement) {
        this.supplyLocalReplacements(localReplacement);
        return this.getInstanceFor(treeMember);
    }

    public T getSeparateInstance(ASTNode ... localReplacements) {
        this.supplyLocalReplacements(localReplacements);
        return this.getSeparateInstance();
    }

    public T getInstanceFor(Root root, ASTNode ... localReplacements) {
        this.supplyLocalReplacements(localReplacements);
        return this.getInstanceFor(root);
    }

    public T getInstanceFor(ASTNode treeMember, ASTNode ... localReplacements) {
        this.supplyLocalReplacements(localReplacements);
        return this.getInstanceFor(treeMember);
    }

    public void markLocalReplacement(ASTNode original) {
        int index = this.localReplacementsMarked++;
        this.markReplacement(original, () -> this.localReplacements.get(index));
    }

    public void markLocalReplacement(String tag, Class<? extends ASTNode> type) {
        this.markLocalReplacement(((ASTNode)this.source).getRoot().identifierIndex.getOne(tag).getAncestor(type));
    }

    public void markIdentifierReplacement(String tag) {
        this.markLocalReplacement(((ASTNode)this.source).getRoot().identifierIndex.getOne(tag));
    }

    public void markIdentifierReplacement(String tag, Supplier<ASTNode> replacement) {
        this.markReplacement(((ASTNode)this.source).getRoot().identifierIndex.getOne(tag), replacement);
    }

    public void markReplacement(ASTNode original, Supplier<ASTNode> replacement) {
        Objects.requireNonNull(original);
        Objects.requireNonNull(replacement);
        this.replacements.put(original, replacement);
        original.markTemplate(this);
    }

    public <R extends ASTNode> void markReplacement(String tag, Class<R> type, Supplier<R> replacement) {
        this.markReplacement((ASTNode)((ASTNode)this.source).getRoot().identifierIndex.getOne(tag).getAncestor(type), replacement);
    }

    public static <T extends ASTNode> Template<T> ofCloned(T source) {
        return new Template<ASTNode>(source.cloneSeparate());
    }

    public static Template<ExternalDeclaration> withExternalDeclaration(String input) {
        return new Template<ExternalDeclaration>(ASTParser.getInternalInstance().parseSeparateExternalDeclaration(input));
    }

    public static Template<Statement> withStatement(String input) {
        return new Template<Statement>(ASTParser.getInternalInstance().parseSeparateStatement(input));
    }

    public static Template<Expression> withExpression(String input) {
        return new Template<Expression>(ASTParser.getInternalInstance().parseSeparateExpression(input));
    }
}

