/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.models;

import com.gtnewhorizons.angelica.api.QuadView;
import com.gtnewhorizons.angelica.models.GeometryHelper;
import com.gtnewhorizons.angelica.models.Material;
import com.gtnewhorizons.angelica.models.NormalHelper;
import com.gtnewhorizons.angelica.models.TexHelper;
import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFlags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class NdQuadBuilder
implements ModelQuadView {
    public static final int BAKE_ROTATE_NONE = 0;
    public static final int BAKE_ROTATE_90 = 1;
    public static final int BAKE_ROTATE_180 = 2;
    public static final int BAKE_ROTATE_270 = 3;
    public static final int BAKE_LOCK_UV = 4;
    public static final int BAKE_FLIP_U = 8;
    public static final int BAKE_FLIP_V = 16;
    public static final int BAKE_NORMALIZED = 32;
    public static float CULL_FACE_EPSILON = 1.0E-5f;
    private ForgeDirection cullFace = ForgeDirection.UNKNOWN;
    private ForgeDirection nominalFace = ForgeDirection.UNKNOWN;
    private ForgeDirection lightFace = ForgeDirection.UP;
    private final int[] data = new int[32];
    private int geometryFlags = 0;
    private boolean isGeometryInvalid = true;
    private int tag = 0;
    private int colorIndex = -1;
    final Vector3f faceNormal = new Vector3f();
    public final Material mat = new Material();

    public QuadView build(QuadView out) {
        this.computeGeometry();
        out.setRaw(this.data, this.hasShade(), this.cullFace(), this.colorIndex, this.geometryFlags);
        this.clear();
        return out;
    }

    public void clear() {
        Arrays.fill(this.data, 0);
        this.cullFace = ForgeDirection.UNKNOWN;
        this.nominalFace = ForgeDirection.UNKNOWN;
        this.lightFace = ForgeDirection.UP;
        this.geometryFlags = 0;
        this.isGeometryInvalid = true;
        this.tag(0);
        this.colorIndex(-1);
        this.mat.reset();
    }

    public void color(int vertexIndex, int color) {
        this.data[vertexIndex * 8 + 5] = color;
    }

    public void color(int c0, int c1, int c2, int c3) {
        this.color(0, c0);
        this.color(1, c1);
        this.color(2, c2);
        this.color(3, c3);
    }

    public void colorIndex(int colorIndex) {
        this.colorIndex = colorIndex;
    }

    private void computeGeometry() {
        if (this.isGeometryInvalid) {
            this.isGeometryInvalid = false;
            NormalHelper.computeFaceNormal(this.faceNormal, this);
            this.lightFace = GeometryHelper.lightFace(this);
            this.geometryFlags = ModelQuadFlags.getQuadFlags(this);
        }
    }

    public final ForgeDirection cullFace() {
        return this.cullFace;
    }

    public void cullFace(ForgeDirection dir) {
        this.cullFace = dir;
        this.nominalFace(dir);
    }

    private boolean hasShade() {
        return this.mat.getDiffuse();
    }

    @Override
    @NotNull
    public ForgeDirection getLightFace() {
        this.computeGeometry();
        return this.lightFace;
    }

    public void nominalFace(@Nullable ForgeDirection face) {
        this.nominalFace = face;
    }

    public ForgeDirection nominalFace() {
        return this.nominalFace;
    }

    public void pos(int vertexIndex, float x, float y, float z) {
        this.data[vertexIndex * 8 + 0] = Float.floatToRawIntBits(x);
        this.data[vertexIndex * 8 + 1] = Float.floatToRawIntBits(y);
        this.data[vertexIndex * 8 + 2] = Float.floatToRawIntBits(z);
        this.isGeometryInvalid = true;
    }

    public Vector3f pos(int vertexIndex) {
        return new Vector3f(Float.intBitsToFloat(this.data[vertexIndex * 8 + 0]), Float.intBitsToFloat(this.data[vertexIndex * 8 + 1]), Float.intBitsToFloat(this.data[vertexIndex * 8 + 2]));
    }

    float posByIndex(int vertexIndex, int coordinateIndex) {
        return Float.intBitsToFloat(this.data[vertexIndex * 8 + 0 + coordinateIndex]);
    }

    public void spriteBake(String spriteName, int bakeFlags) {
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(spriteName);
        TexHelper.bakeSprite(this, (IIcon)icon, bakeFlags);
    }

    public void spriteBake(IIcon sprite, int bakeFlags) {
        TexHelper.bakeSprite(this, sprite, bakeFlags);
    }

    public void square(ForgeDirection nominalFace, float left, float bottom, float right, float top, float depth) {
        if (Math.abs(depth) < CULL_FACE_EPSILON) {
            this.cullFace(nominalFace);
            depth = 0.0f;
        } else {
            this.cullFace(ForgeDirection.UNKNOWN);
        }
        this.nominalFace(nominalFace);
        switch (nominalFace) {
            case UP: {
                depth = 1.0f - depth;
                top = 1.0f - top;
                bottom = 1.0f - bottom;
            }
            case DOWN: {
                this.pos(0, left, depth, top);
                this.pos(1, left, depth, bottom);
                this.pos(2, right, depth, bottom);
                this.pos(3, right, depth, top);
                break;
            }
            case EAST: {
                depth = 1.0f - depth;
                left = 1.0f - left;
                right = 1.0f - right;
            }
            case WEST: {
                this.pos(0, depth, top, left);
                this.pos(1, depth, bottom, left);
                this.pos(2, depth, bottom, right);
                this.pos(3, depth, top, right);
                break;
            }
            case SOUTH: {
                depth = 1.0f - depth;
                left = 1.0f - left;
                right = 1.0f - right;
            }
            case NORTH: {
                this.pos(0, 1.0f - left, top, depth);
                this.pos(1, 1.0f - left, bottom, depth);
                this.pos(2, 1.0f - right, bottom, depth);
                this.pos(3, 1.0f - right, top, depth);
            }
        }
    }

    public int tag() {
        return this.tag;
    }

    public void tag(int tag) {
        this.tag = tag;
    }

    public void uv(int vertexIndex, float u, float v) {
        this.data[vertexIndex * 8 + 3] = Float.floatToRawIntBits(u);
        this.data[vertexIndex * 8 + 4] = Float.floatToRawIntBits(v);
    }

    @Override
    public float getX(int vertexIndex) {
        return Float.intBitsToFloat(this.data[vertexIndex * 8 + 0]);
    }

    @Override
    public float getY(int vertexIndex) {
        return Float.intBitsToFloat(this.data[vertexIndex * 8 + 1]);
    }

    @Override
    public float getZ(int vertexIndex) {
        return Float.intBitsToFloat(this.data[vertexIndex * 8 + 2]);
    }

    @Override
    public float getTexU(int vertexIndex) {
        return Float.intBitsToFloat(this.data[vertexIndex * 8 + 3]);
    }

    @Override
    public float getTexV(int vertexIndex) {
        return Float.intBitsToFloat(this.data[vertexIndex * 8 + 4]);
    }

    @Override
    public int getColor(int vertexIndex) {
        return this.data[vertexIndex * 8 + 5];
    }

    @Override
    public int getNormal(int vertexIndex) {
        return this.data[vertexIndex * 8 + 6];
    }

    @Override
    public int getLight(int vertexIndex) {
        return this.data[vertexIndex * 8 + 7];
    }

    @Override
    public int getFlags() {
        return this.geometryFlags;
    }

    @Override
    public TextureAtlasSprite rubidium$getSprite() {
        return null;
    }

    public static Vector3f mapSideToVertex(Vector3f from, Vector3f to, int index, ForgeDirection side) {
        Vector3f vector3f;
        block0 : switch (side) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DOWN: {
                switch (index) {
                    case 0: {
                        vector3f = new Vector3f(from.x, from.y, to.z);
                        break block0;
                    }
                    case 1: {
                        vector3f = new Vector3f(from.x, from.y, from.z);
                        break block0;
                    }
                    case 2: {
                        vector3f = new Vector3f(to.x, from.y, from.z);
                        break block0;
                    }
                    case 3: {
                        vector3f = new Vector3f(to.x, from.y, to.z);
                        break block0;
                    }
                }
                throw new RuntimeException("Too many indices!");
            }
            case UP: {
                switch (index) {
                    case 0: {
                        vector3f = new Vector3f(from.x, to.y, from.z);
                        break block0;
                    }
                    case 1: {
                        vector3f = new Vector3f(from.x, to.y, to.z);
                        break block0;
                    }
                    case 2: {
                        vector3f = new Vector3f(to.x, to.y, to.z);
                        break block0;
                    }
                    case 3: {
                        vector3f = new Vector3f(to.x, to.y, from.z);
                        break block0;
                    }
                }
                throw new RuntimeException("Too many indices!");
            }
            case NORTH: {
                switch (index) {
                    case 0: {
                        vector3f = new Vector3f(to.x, to.y, from.z);
                        break block0;
                    }
                    case 1: {
                        vector3f = new Vector3f(to.x, from.y, from.z);
                        break block0;
                    }
                    case 2: {
                        vector3f = new Vector3f(from.x, from.y, from.z);
                        break block0;
                    }
                    case 3: {
                        vector3f = new Vector3f(from.x, to.y, from.z);
                        break block0;
                    }
                }
                throw new RuntimeException("Too many indices!");
            }
            case SOUTH: {
                switch (index) {
                    case 0: {
                        vector3f = new Vector3f(from.x, to.y, to.z);
                        break block0;
                    }
                    case 1: {
                        vector3f = new Vector3f(from.x, from.y, to.z);
                        break block0;
                    }
                    case 2: {
                        vector3f = new Vector3f(to.x, from.y, to.z);
                        break block0;
                    }
                    case 3: {
                        vector3f = new Vector3f(to.x, to.y, to.z);
                        break block0;
                    }
                }
                throw new RuntimeException("Too many indices!");
            }
            case WEST: {
                switch (index) {
                    case 0: {
                        vector3f = new Vector3f(from.x, to.y, from.z);
                        break block0;
                    }
                    case 1: {
                        vector3f = new Vector3f(from.x, from.y, from.z);
                        break block0;
                    }
                    case 2: {
                        vector3f = new Vector3f(from.x, from.y, to.z);
                        break block0;
                    }
                    case 3: {
                        vector3f = new Vector3f(from.x, to.y, to.z);
                        break block0;
                    }
                }
                throw new RuntimeException("Too many indices!");
            }
            case EAST: {
                switch (index) {
                    case 0: {
                        vector3f = new Vector3f(to.x, to.y, to.z);
                        break block0;
                    }
                    case 1: {
                        vector3f = new Vector3f(to.x, from.y, to.z);
                        break block0;
                    }
                    case 2: {
                        vector3f = new Vector3f(to.x, from.y, from.z);
                        break block0;
                    }
                    case 3: {
                        vector3f = new Vector3f(to.x, to.y, from.z);
                        break block0;
                    }
                }
                throw new RuntimeException("Too many indices!");
            }
            case UNKNOWN: {
                vector3f = null;
            }
        }
        return vector3f;
    }

    @Override
    public int getColorIndex() {
        return this.colorIndex;
    }
}

