/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import java.util.Optional;
import net.coderbot.iris.shaderpack.ProgramSet;
import org.joml.Vector2f;
import org.joml.Vector3i;

public class ComputeSource {
    private final String name;
    private final String source;
    private final ProgramSet parent;
    private Vector3i workGroups;
    private Vector2f workGroupRelative;

    public ComputeSource(String name, String source, ProgramSet parent) {
        this.name = name;
        this.source = source;
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getSource() {
        return Optional.ofNullable(this.source);
    }

    public ProgramSet getParent() {
        return this.parent;
    }

    public boolean isValid() {
        return this.source != null;
    }

    public void setWorkGroups(Vector3i workGroups) {
        this.workGroups = workGroups;
    }

    public void setWorkGroupRelative(Vector2f workGroupRelative) {
        this.workGroupRelative = workGroupRelative;
    }

    public Vector2f getWorkGroupRelative() {
        return this.workGroupRelative;
    }

    public Vector3i getWorkGroups() {
        return this.workGroups;
    }

    public Optional<ComputeSource> requireValid() {
        if (this.isValid()) {
            return Optional.of(this);
        }
        return Optional.empty();
    }
}

