/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.shaderoptions;

import java.util.List;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.shaderoptions.BaseEntry;
import net.coderbot.iris.gui.element.widget.AbstractElementWidget;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;

public class ElementRowEntry
extends BaseEntry {
    private final List<AbstractElementWidget<?>> widgets;
    private final ShaderPackScreen screen;
    private int cachedWidth;
    private int cachedPosX;

    public ElementRowEntry(ShaderPackScreen screen, NavigationController navigation, List<AbstractElementWidget<?>> widgets) {
        super(navigation);
        this.screen = screen;
        this.widgets = widgets;
    }

    @Override
    public void drawEntry(ShaderPackScreen screen, int index, int x, int y, int slotWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isMouseOver) {
        this.cachedWidth = slotWidth;
        this.cachedPosX = x;
        int totalWidthWithoutMargins = slotWidth - 2 * (this.widgets.size() - 1);
        float singleWidgetWidth = (float)(totalWidthWithoutMargins -= 3) / (float)this.widgets.size();
        for (int i = 0; i < this.widgets.size(); ++i) {
            AbstractElementWidget<?> widget = this.widgets.get(i);
            boolean widgetHovered = isMouseOver && this.getHoveredWidget(mouseX) == i;
            widget.drawScreen(x + (int)((singleWidgetWidth + 2.0f) * (float)i), y, (int)singleWidgetWidth, slotHeight + 2, mouseX, mouseY, 0.0f, widgetHovered);
            screen.setElementHoveredStatus(widget, widgetHovered);
        }
    }

    public int getHoveredWidget(int mouseX) {
        float positionAcrossWidget = (float)MathHelper.func_76125_a((int)(mouseX - this.cachedPosX), (int)0, (int)this.cachedWidth) / (float)this.cachedWidth;
        return MathHelper.func_76125_a((int)((int)Math.floor((float)this.widgets.size() * positionAcrossWidget)), (int)0, (int)(this.widgets.size() - 1));
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        return this.widgets.get(this.getHoveredWidget(mouseX)).mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        return this.widgets.get(this.getHoveredWidget(mouseX)).mouseReleased(mouseX, mouseY, button);
    }
}

