/*
 * Decompiled with CFR 0.152.
 */
package jss.notfine.asm;

import jss.notfine.asm.ASMUtils;
import jss.notfine.asm.mappings.Names;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class RenderBlocksTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if ("net.minecraft.client.renderer.RenderBlocks".equals(transformedName)) {
            return RenderBlocksTransformer.patchRenderBlocks(basicClass);
        }
        return basicClass;
    }

    private static byte[] patchRenderBlocks(byte[] basicClass) {
        Logger logger = LogManager.getLogger((String)"MCPatcherForge");
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        int ifStartsHandled = 0;
        int ifEndsHandled = 0;
        boolean secondWrappedIfHandled = false;
        int ifStartsHandledPartial = 0;
        int ifEndsHandledPartial = 0;
        boolean secondWrappedIfHandledPartial = false;
        VarInsnNode ifSequence1 = new VarInsnNode(21, 13);
        AbstractInsnNode[] ifSequence2 = RenderBlocksTransformer.getStartIfSequence2();
        AbstractInsnNode[] endIfSequence = RenderBlocksTransformer.getEndIfSequence();
        Pair<InsnList, InsnList> ifWrapper1 = RenderBlocksTransformer.getRenderBlocksIfWrapper(0, 4601, 4626, false);
        Pair<InsnList, InsnList> ifWrapper2 = RenderBlocksTransformer.getRenderBlocksIfWrapper(1, 4715, 4730, true);
        Pair<InsnList, InsnList> ifWrapper3 = RenderBlocksTransformer.getRenderBlocksIfWrapper(2, 4822, 4847, false);
        Pair<InsnList, InsnList> ifWrapper4 = RenderBlocksTransformer.getRenderBlocksIfWrapper(3, 4956, 4981, false);
        Pair<InsnList, InsnList> ifWrapper5 = RenderBlocksTransformer.getRenderBlocksIfWrapper(4, 5090, 5115, false);
        Pair<InsnList, InsnList> ifWrapper6 = RenderBlocksTransformer.getRenderBlocksIfWrapper(5, 5224, 5249, false);
        Pair<InsnList, InsnList> ifWrapper7 = RenderBlocksTransformer.getRenderBlocksIfWrapper(0, 5405, 5419, false);
        Pair<InsnList, InsnList> ifWrapper8 = RenderBlocksTransformer.getRenderBlocksIfWrapper(1, 5519, 5523, true);
        Pair<InsnList, InsnList> ifWrapper9 = RenderBlocksTransformer.getRenderBlocksIfWrapper(2, 5509, 5523, false);
        Pair<InsnList, InsnList> ifWrapper10 = RenderBlocksTransformer.getRenderBlocksIfWrapper(3, 5642, 5655, false);
        Pair<InsnList, InsnList> ifWrapper11 = RenderBlocksTransformer.getRenderBlocksIfWrapper(4, 5784, 5798, false);
        Pair<InsnList, InsnList> ifWrapper12 = RenderBlocksTransformer.getRenderBlocksIfWrapper(5, 5926, 5940, false);
        block0: for (MethodNode methodNode : classNode.methods) {
            if (RenderBlocksTransformer.isRenderStandardBlockWithAmbientOcclusion(methodNode)) {
                logger.debug("found renderStandardBlockWithAmbientOcclusion");
                for (AbstractInsnNode node : methodNode.instructions.toArray()) {
                    if (ifStartsHandled == 0 && ASMUtils.matchesNodeSequence(node, new AbstractInsnNode[]{ifSequence1})) {
                        methodNode.instructions.insertBefore(node, (InsnList)ifWrapper1.getLeft());
                        ++ifStartsHandled;
                        continue;
                    }
                    if (!secondWrappedIfHandled && ASMUtils.matchesNodeSequence(node, ifSequence2)) {
                        methodNode.instructions.insertBefore(node, (InsnList)ifWrapper2.getLeft());
                        secondWrappedIfHandled = true;
                        continue;
                    }
                    if (ifStartsHandled == 1 && ASMUtils.matchesNodeSequence(node, new AbstractInsnNode[]{ifSequence1})) {
                        methodNode.instructions.insertBefore(node, (InsnList)ifWrapper3.getLeft());
                        ++ifStartsHandled;
                        continue;
                    }
                    if (ifStartsHandled == 2 && ASMUtils.matchesNodeSequence(node, new AbstractInsnNode[]{ifSequence1})) {
                        methodNode.instructions.insertBefore(node, (InsnList)ifWrapper4.getLeft());
                        ++ifStartsHandled;
                        continue;
                    }
                    if (ifStartsHandled == 3 && ASMUtils.matchesNodeSequence(node, new AbstractInsnNode[]{ifSequence1})) {
                        methodNode.instructions.insertBefore(node, (InsnList)ifWrapper5.getLeft());
                        ++ifStartsHandled;
                        continue;
                    }
                    if (ifStartsHandled == 4 && ASMUtils.matchesNodeSequence(node, new AbstractInsnNode[]{ifSequence1})) {
                        methodNode.instructions.insertBefore(node, (InsnList)ifWrapper6.getLeft());
                        ++ifStartsHandled;
                        continue;
                    }
                    if (ifEndsHandled == 0 && ASMUtils.matchesNodeSequence(node, endIfSequence)) {
                        methodNode.instructions.remove(node.getNext().getNext().getNext());
                        methodNode.instructions.insert(node.getNext().getNext(), (InsnList)ifWrapper1.getRight());
                        ++ifEndsHandled;
                        continue;
                    }
                    if (ifEndsHandled == 1 && ASMUtils.matchesNodeSequence(node, endIfSequence)) {
                        methodNode.instructions.remove(node.getNext().getNext().getNext());
                        methodNode.instructions.insert(node.getNext().getNext(), (InsnList)ifWrapper2.getRight());
                        ++ifEndsHandled;
                        continue;
                    }
                    if (ifEndsHandled == 2 && ASMUtils.matchesNodeSequence(node, endIfSequence)) {
                        methodNode.instructions.remove(node.getNext().getNext().getNext());
                        methodNode.instructions.insert(node.getNext().getNext(), (InsnList)ifWrapper3.getRight());
                        ++ifEndsHandled;
                        continue;
                    }
                    if (ifEndsHandled == 3 && ASMUtils.matchesNodeSequence(node, endIfSequence)) {
                        methodNode.instructions.remove(node.getNext().getNext().getNext());
                        methodNode.instructions.insert(node.getNext().getNext(), (InsnList)ifWrapper4.getRight());
                        ++ifEndsHandled;
                        continue;
                    }
                    if (ifEndsHandled == 4 && ASMUtils.matchesNodeSequence(node, endIfSequence)) {
                        methodNode.instructions.remove(node.getNext().getNext().getNext());
                        methodNode.instructions.insert(node.getNext().getNext(), (InsnList)ifWrapper5.getRight());
                        ++ifEndsHandled;
                        continue;
                    }
                    if (ifEndsHandled != 5 || !ASMUtils.matchesNodeSequence(node, endIfSequence)) continue;
                    methodNode.instructions.remove(node.getNext().getNext().getNext());
                    methodNode.instructions.insert(node.getNext().getNext(), (InsnList)ifWrapper6.getRight());
                    ++ifEndsHandled;
                    continue block0;
                }
                continue;
            }
            if (!RenderBlocksTransformer.isRenderStandardBlockWithAmbientOcclusionPartial(methodNode)) continue;
            logger.debug("found renderStandardBlockWithAmbientOcclusionPartial");
            for (AbstractInsnNode node : methodNode.instructions.toArray()) {
                if (ifStartsHandledPartial == 0 && ASMUtils.matchesNodeSequence(node, new AbstractInsnNode[]{ifSequence1})) {
                    methodNode.instructions.insertBefore(node, (InsnList)ifWrapper7.getLeft());
                    ++ifStartsHandledPartial;
                    continue;
                }
                if (!secondWrappedIfHandledPartial && ASMUtils.matchesNodeSequence(node, ifSequence2)) {
                    methodNode.instructions.insertBefore(node, (InsnList)ifWrapper8.getLeft());
                    secondWrappedIfHandledPartial = true;
                    continue;
                }
                if (ifStartsHandledPartial == 1 && ASMUtils.matchesNodeSequence(node, new AbstractInsnNode[]{ifSequence1})) {
                    methodNode.instructions.insertBefore(node, (InsnList)ifWrapper9.getLeft());
                    ++ifStartsHandledPartial;
                    continue;
                }
                if (ifStartsHandledPartial == 2 && ASMUtils.matchesNodeSequence(node, new AbstractInsnNode[]{ifSequence1})) {
                    methodNode.instructions.insertBefore(node, (InsnList)ifWrapper10.getLeft());
                    ++ifStartsHandledPartial;
                    continue;
                }
                if (ifStartsHandledPartial == 3 && ASMUtils.matchesNodeSequence(node, new AbstractInsnNode[]{ifSequence1})) {
                    methodNode.instructions.insertBefore(node, (InsnList)ifWrapper11.getLeft());
                    ++ifStartsHandledPartial;
                    continue;
                }
                if (ifStartsHandledPartial == 4 && ASMUtils.matchesNodeSequence(node, new AbstractInsnNode[]{ifSequence1})) {
                    methodNode.instructions.insertBefore(node, (InsnList)ifWrapper12.getLeft());
                    ++ifStartsHandledPartial;
                    continue;
                }
                if (ifEndsHandledPartial == 0 && ASMUtils.matchesNodeSequence(node, endIfSequence)) {
                    methodNode.instructions.remove(node.getNext().getNext().getNext());
                    methodNode.instructions.insert(node.getNext().getNext(), (InsnList)ifWrapper7.getRight());
                    ++ifEndsHandledPartial;
                    continue;
                }
                if (ifEndsHandledPartial == 1 && ASMUtils.matchesNodeSequence(node, endIfSequence)) {
                    methodNode.instructions.remove(node.getNext().getNext().getNext());
                    methodNode.instructions.insert(node.getNext().getNext(), (InsnList)ifWrapper8.getRight());
                    ++ifEndsHandledPartial;
                    continue;
                }
                if (ifEndsHandledPartial == 2 && ASMUtils.matchesNodeSequence(node, endIfSequence)) {
                    methodNode.instructions.remove(node.getNext().getNext().getNext());
                    methodNode.instructions.insert(node.getNext().getNext(), (InsnList)ifWrapper9.getRight());
                    ++ifEndsHandledPartial;
                    continue;
                }
                if (ifEndsHandledPartial == 3 && ASMUtils.matchesNodeSequence(node, endIfSequence)) {
                    methodNode.instructions.remove(node.getNext().getNext().getNext());
                    methodNode.instructions.insert(node.getNext().getNext(), (InsnList)ifWrapper10.getRight());
                    ++ifEndsHandledPartial;
                    continue;
                }
                if (ifEndsHandledPartial == 4 && ASMUtils.matchesNodeSequence(node, endIfSequence)) {
                    methodNode.instructions.remove(node.getNext().getNext().getNext());
                    methodNode.instructions.insert(node.getNext().getNext(), (InsnList)ifWrapper11.getRight());
                    ++ifEndsHandledPartial;
                    continue;
                }
                if (ifEndsHandledPartial != 5 || !ASMUtils.matchesNodeSequence(node, endIfSequence)) continue;
                methodNode.instructions.remove(node.getNext().getNext().getNext());
                methodNode.instructions.insert(node.getNext().getNext(), (InsnList)ifWrapper12.getRight());
                ++ifEndsHandledPartial;
                continue block0;
            }
        }
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    private static Pair<InsnList, InsnList> getRenderBlocksIfWrapper(int face, int lineNumber1, int lineNumber2, boolean second) {
        int n;
        switch (face) {
            case 0: {
                n = 3;
                break;
            }
            case 1: {
                n = 4;
                break;
            }
            case 2: {
                n = 5;
                break;
            }
            case 3: {
                n = 6;
                break;
            }
            case 4: {
                n = 7;
                break;
            }
            case 5: {
                n = 8;
                break;
            }
            default: {
                n = 0;
            }
        }
        int iConst = n;
        InsnList ifStart = new InsnList();
        ifStart.add((AbstractInsnNode)new VarInsnNode(25, 0));
        ifStart.add((AbstractInsnNode)new VarInsnNode(25, 1));
        ifStart.add((AbstractInsnNode)new VarInsnNode(25, 0));
        ifStart.add((AbstractInsnNode)new FieldInsnNode(180, Names.renderBlocks_blockAccess.clas, Names.renderBlocks_blockAccess.name, Names.renderBlocks_blockAccess.desc));
        ifStart.add((AbstractInsnNode)new VarInsnNode(21, 2));
        ifStart.add((AbstractInsnNode)new VarInsnNode(21, 3));
        ifStart.add((AbstractInsnNode)new VarInsnNode(21, 4));
        ifStart.add((AbstractInsnNode)new InsnNode(iConst));
        ifStart.add((AbstractInsnNode)new VarInsnNode(23, 9));
        ifStart.add((AbstractInsnNode)new VarInsnNode(23, 10));
        ifStart.add((AbstractInsnNode)new VarInsnNode(23, 11));
        ifStart.add((AbstractInsnNode)new VarInsnNode(23, 12));
        ifStart.add((AbstractInsnNode)new MethodInsnNode(184, "com/prupe/mcpatcher/cc/ColorizeBlock", "setupBlockSmoothing", "(" + Names.renderBlocks_.desc + Names.block_.desc + Names.iBlockAccess_.desc + "IIIIFFFF)Z", false));
        Label label1 = new Label();
        ifStart.add((AbstractInsnNode)new JumpInsnNode(154, new LabelNode(label1)));
        Label label2 = new Label();
        ifStart.add((AbstractInsnNode)new LabelNode(label2));
        ifStart.add((AbstractInsnNode)new LineNumberNode(lineNumber1, new LabelNode(label2)));
        InsnList ifEnd = new InsnList();
        ifEnd.add((AbstractInsnNode)new LabelNode(label1));
        ifEnd.add((AbstractInsnNode)new LineNumberNode(lineNumber2, new LabelNode(label1)));
        if (second) {
            ifEnd.add((AbstractInsnNode)new FrameNode(1, 1, new Object[]{Opcodes.FLOAT}, 0, null));
        } else {
            ifEnd.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        }
        return Pair.of((Object)ifStart, (Object)ifEnd);
    }

    private static AbstractInsnNode[] getStartIfSequence2() {
        VarInsnNode searchNode1 = new VarInsnNode(25, 0);
        VarInsnNode searchNode2 = new VarInsnNode(25, 0);
        VarInsnNode searchNode3 = new VarInsnNode(25, 0);
        VarInsnNode searchNode4 = new VarInsnNode(25, 0);
        VarInsnNode searchNode5 = new VarInsnNode(23, 5);
        InsnNode searchNode6 = new InsnNode(90);
        return new AbstractInsnNode[]{searchNode1, searchNode2, searchNode3, searchNode4, searchNode5, searchNode6};
    }

    private static AbstractInsnNode[] getEndIfSequence() {
        VarInsnNode searchNode1 = new VarInsnNode(23, 12);
        InsnNode searchNode2 = new InsnNode(106);
        FieldInsnNode searchNode3 = new FieldInsnNode(181, Names.renderBlocks_colorBlueTopRight.clas, Names.renderBlocks_colorBlueTopRight.name, Names.renderBlocks_colorBlueTopRight.desc);
        return new AbstractInsnNode[]{searchNode1, searchNode2, searchNode3};
    }

    private static boolean isRenderStandardBlockWithAmbientOcclusion(MethodNode methodNode) {
        return Names.renderBlocks_renderStandardBlockWithAmbientOcclusion.equalsNameDesc(methodNode.name, methodNode.desc);
    }

    private static boolean isRenderStandardBlockWithAmbientOcclusionPartial(MethodNode methodNode) {
        return Names.renderBlocks_renderStandardBlockWithAmbientOcclusionPartial.equalsNameDesc(methodNode.name, methodNode.desc);
    }
}

