/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.transform;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class BlockTransformer
implements IClassTransformer {
    public static final String BlockClass = "net/minecraft/block/Block";
    public static final String BlockPackage = "net/minecraft/block/Block".substring(0, "net/minecraft/block/Block".lastIndexOf(47) + 1);
    private static final String BlockClassFriendly = "net/minecraft/block/Block".replace('/', '.');
    public static final List<Pair<String, String>> BlockBoundsFields = ImmutableList.of((Object)Pair.of((Object)"minX", (Object)"field_149759_B"), (Object)Pair.of((Object)"minY", (Object)"field_149760_C"), (Object)Pair.of((Object)"minZ", (Object)"field_149754_D"), (Object)Pair.of((Object)"maxX", (Object)"field_149755_E"), (Object)Pair.of((Object)"maxY", (Object)"field_149756_F"), (Object)Pair.of((Object)"maxZ", (Object)"field_149757_G"));

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass != null && transformedName.equals(BlockClassFriendly)) {
            ClassReader cr = new ClassReader(basicClass);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            cn.fields.removeIf(node -> BlockBoundsFields.stream().anyMatch(pair -> node.name.equals(pair.getLeft()) || node.name.equals(pair.getRight())));
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            basicClass = cw.toByteArray();
        }
        return basicClass;
    }
}

