/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.cst.traversal;

import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.cst.traversal.PartialParseTreeListener;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.tree.ExtendedContext;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.ParserRuleContext;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.ErrorNode;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.ParseTreeListener;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.TerminalNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;

public class ProxyParseTreeListener
implements PartialParseTreeListener {
    private Collection<PartialParseTreeListener> listeners = new ArrayList<PartialParseTreeListener>();
    private Collection<PartialParseTreeListener> stoppableListeners = new ArrayList<PartialParseTreeListener>();
    private Iterator<PartialParseTreeListener> listenerIterator;
    private PartialParseTreeListener currentListener;

    public void add(PartialParseTreeListener listener) {
        this.listeners.add(listener);
        if (listener.canStop()) {
            this.stoppableListeners.add(listener);
        }
    }

    public boolean needsWalk() {
        return !this.listeners.isEmpty();
    }

    public void removeCurrentListener() {
        this.listenerIterator.remove();
        this.stoppableListeners.remove(this.currentListener);
    }

    private void iterateListeners(Consumer<PartialParseTreeListener> consumer) {
        for (PartialParseTreeListener this.currentListener : this.listeners) {
            consumer.accept(this.currentListener);
        }
        this.listenerIterator = null;
    }

    private boolean hasNonStoppingListeners() {
        return this.stoppableListeners.size() < this.listeners.size();
    }

    @Override
    public boolean isDeepEnough(ExtendedContext node, int depth) {
        if (this.hasNonStoppingListeners()) {
            return false;
        }
        for (PartialParseTreeListener listener : this.stoppableListeners) {
            if (listener.isDeepEnough(node, depth)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFinished(int depth) {
        if (this.hasNonStoppingListeners()) {
            return false;
        }
        boolean finished = true;
        Iterator<PartialParseTreeListener> stoppableListenerIterator = this.stoppableListeners.iterator();
        while (stoppableListenerIterator.hasNext()) {
            PartialParseTreeListener listener = stoppableListenerIterator.next();
            if (listener.isFinished(depth)) {
                this.listeners.remove(listener);
                stoppableListenerIterator.remove();
                continue;
            }
            finished = false;
        }
        return finished;
    }

    @Override
    public void enterEveryRule(ParserRuleContext ctx) {
        this.iterateListeners(listener -> {
            listener.enterEveryRule(ctx);
            ctx.enterRule((ParseTreeListener)listener);
        });
    }

    @Override
    public void exitEveryRule(ParserRuleContext ctx) {
        this.iterateListeners(listener -> {
            ctx.exitRule((ParseTreeListener)listener);
            listener.exitEveryRule(ctx);
        });
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
        this.iterateListeners(listener -> listener.visitErrorNode(node));
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        this.iterateListeners(listener -> listener.visitTerminal(node));
    }
}

