/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.render;

import com.gtnewhorizons.angelica.client.renderer.CapturingTessellator;
import com.gtnewhorizons.angelica.compat.mojang.DefaultVertexFormat;
import com.gtnewhorizons.angelica.compat.mojang.VertexBuffer;
import com.gtnewhorizons.angelica.compat.mojang.VertexFormat;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.TessellatorManager;
import com.gtnewhorizons.angelica.glsm.VBOManager;
import jss.notfine.core.Settings;
import jss.notfine.gui.options.named.GraphicsQualityOff;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class CloudRenderer
implements IResourceManagerReloadListener {
    private static final float PX_SIZE = 0.00390625f;
    private static final VertexFormat FORMAT = DefaultVertexFormat.POSITION_TEXTURE_COLOR;
    private static final int TOP_SECTIONS = 12;
    private static final int HEIGHT = 4;
    private static final float INSET = 0.001f;
    private static final float ALPHA = 0.8f;
    private static final boolean WIREFRAME = false;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final ResourceLocation texture = new ResourceLocation("textures/environment/clouds.png");
    private int displayList = -1;
    private VertexBuffer vbo;
    private int cloudMode = -1;
    private int renderDistance = -1;
    private DynamicTexture COLOR_TEX = null;
    private int texW;
    private int texH;
    private static CloudRenderer instance;

    public CloudRenderer() {
        ((IReloadableResourceManager)this.mc.func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    public static CloudRenderer getCloudRenderer() {
        if (instance == null) {
            instance = new CloudRenderer();
        }
        return instance;
    }

    private int getScale() {
        return this.cloudMode == 2 ? 12 : 8;
    }

    private float ceilToScale(float value) {
        float scale = this.getScale();
        return (float)Math.ceil(value / scale) * scale;
    }

    private void vertices(CapturingTessellator tessellator) {
        float sectX0;
        GraphicsQualityOff cloudGraphicsQuality = (GraphicsQualityOff)Settings.MODE_CLOUDS.option.getStore();
        boolean fancy = cloudGraphicsQuality == GraphicsQualityOff.FANCY || cloudGraphicsQuality == GraphicsQualityOff.DEFAULT && this.mc.field_71474_y.field_74347_j;
        float scale = this.getScale();
        float CULL_DIST = 2.0f * scale;
        float bCol = fancy ? 0.7f : 1.0f;
        float sectEnd = this.ceilToScale(this.renderDistance * 2 * 16);
        float sectStart = -sectEnd;
        float sectStep = this.ceilToScale(sectEnd * 2.0f / 12.0f);
        float sectPx = 0.00390625f / scale;
        tessellator.func_78382_b();
        float sectX1 = sectX0 = sectStart;
        while (sectX1 < sectEnd) {
            float sectZ0;
            if ((sectX1 += sectStep) > sectEnd) {
                sectX1 = sectEnd;
            }
            float sectZ1 = sectZ0 = sectStart;
            while (sectZ1 < sectEnd) {
                if ((sectZ1 += sectStep) > sectEnd) {
                    sectZ1 = sectEnd;
                }
                float u0 = sectX0 * sectPx;
                float u1 = sectX1 * sectPx;
                float v0 = sectZ0 * sectPx;
                float v1 = sectZ1 * sectPx;
                tessellator.pos(sectX0, 0.0, sectZ0).tex(u0, v0).color(bCol, bCol, bCol, 0.8f).endVertex();
                tessellator.pos(sectX1, 0.0, sectZ0).tex(u1, v0).color(bCol, bCol, bCol, 0.8f).endVertex();
                tessellator.pos(sectX1, 0.0, sectZ1).tex(u1, v1).color(bCol, bCol, bCol, 0.8f).endVertex();
                tessellator.pos(sectX0, 0.0, sectZ1).tex(u0, v1).color(bCol, bCol, bCol, 0.8f).endVertex();
                if (fancy) {
                    float sliceCoord1;
                    float sliceCoord0;
                    tessellator.pos(sectX0, 4.0, sectZ0).tex(u0, v0).color(1.0f, 1.0f, 1.0f, 0.8f).endVertex();
                    tessellator.pos(sectX0, 4.0, sectZ1).tex(u0, v1).color(1.0f, 1.0f, 1.0f, 0.8f).endVertex();
                    tessellator.pos(sectX1, 4.0, sectZ1).tex(u1, v1).color(1.0f, 1.0f, 1.0f, 0.8f).endVertex();
                    tessellator.pos(sectX1, 4.0, sectZ0).tex(u1, v0).color(1.0f, 1.0f, 1.0f, 0.8f).endVertex();
                    float slice = sectX0;
                    while (slice < sectX1) {
                        sliceCoord0 = slice * sectPx;
                        sliceCoord1 = sliceCoord0 + 0.00390625f;
                        if (slice > -CULL_DIST) {
                            tessellator.pos(slice += 0.001f, 0.0, sectZ1).tex(sliceCoord0, v1).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                            tessellator.pos(slice, 4.0, sectZ1).tex(sliceCoord1, v1).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                            tessellator.pos(slice, 4.0, sectZ0).tex(sliceCoord1, v0).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                            tessellator.pos(slice, 0.0, sectZ0).tex(sliceCoord0, v0).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                            slice -= 0.001f;
                        }
                        if (!((slice += scale) <= CULL_DIST)) continue;
                        tessellator.pos(slice -= 0.001f, 0.0, sectZ0).tex(sliceCoord0, v0).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                        tessellator.pos(slice, 4.0, sectZ0).tex(sliceCoord1, v0).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                        tessellator.pos(slice, 4.0, sectZ1).tex(sliceCoord1, v1).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                        tessellator.pos(slice, 0.0, sectZ1).tex(sliceCoord0, v1).color(0.9f, 0.9f, 0.9f, 0.8f).endVertex();
                        slice += 0.001f;
                    }
                    slice = sectZ0;
                    while (slice < sectZ1) {
                        sliceCoord0 = slice * sectPx;
                        sliceCoord1 = sliceCoord0 + 0.00390625f;
                        if (slice > -CULL_DIST) {
                            tessellator.pos(sectX0, 0.0, slice += 0.001f).tex(u0, sliceCoord0).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                            tessellator.pos(sectX0, 4.0, slice).tex(u0, sliceCoord1).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                            tessellator.pos(sectX1, 4.0, slice).tex(u1, sliceCoord1).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                            tessellator.pos(sectX1, 0.0, slice).tex(u1, sliceCoord0).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                            slice -= 0.001f;
                        }
                        if (!((slice += scale) <= CULL_DIST)) continue;
                        tessellator.pos(sectX1, 0.0, slice -= 0.001f).tex(u1, sliceCoord0).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                        tessellator.pos(sectX1, 4.0, slice).tex(u1, sliceCoord1).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                        tessellator.pos(sectX0, 4.0, slice).tex(u0, sliceCoord1).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                        tessellator.pos(sectX0, 0.0, slice).tex(u0, sliceCoord0).color(0.8f, 0.8f, 0.8f, 0.8f).endVertex();
                        slice += 0.001f;
                    }
                }
                sectZ0 = sectZ1;
            }
            sectX0 = sectX1;
        }
    }

    private void dispose() {
        if (this.vbo != null) {
            this.vbo.close();
            this.vbo = null;
        }
    }

    private void build() {
        TessellatorManager.startCapturing();
        CapturingTessellator tess = (CapturingTessellator)TessellatorManager.get();
        this.vertices(tess);
        if (this.displayList == -1) {
            this.displayList = VBOManager.generateDisplayLists(1);
        }
        this.vbo = VBOManager.registerVBO(this.displayList, TessellatorManager.stopCapturingToVBO(FORMAT));
    }

    private int fullCoord(double coord, int scale) {
        return (int)coord / scale - (coord < 0.0 ? 1 : 0);
    }

    private boolean isBuilt() {
        return this.vbo != null;
    }

    public void checkSettings() {
        boolean newEnabled;
        GraphicsQualityOff cloudGraphicsQuality = (GraphicsQualityOff)Settings.MODE_CLOUDS.option.getStore();
        int cloudQualitySetting = cloudGraphicsQuality == GraphicsQualityOff.FANCY || cloudGraphicsQuality == GraphicsQualityOff.DEFAULT && this.mc.field_71474_y.field_74347_j ? 2 : 1;
        boolean bl = newEnabled = this.mc.field_71474_y.func_74309_c() && this.mc.field_71441_e != null && this.mc.field_71441_e.field_73011_w.func_76569_d();
        if (this.isBuilt() && (!newEnabled || cloudQualitySetting != this.cloudMode || this.mc.field_71474_y.field_151451_c != this.renderDistance)) {
            this.dispose();
        }
        this.cloudMode = cloudQualitySetting;
        this.renderDistance = this.mc.field_71474_y.field_151451_c;
        if (newEnabled && !this.isBuilt()) {
            this.build();
        }
    }

    public boolean render(int cloudTicks, float partialTicks) {
        if (!this.isBuilt()) {
            return false;
        }
        EntityLivingBase entity = this.mc.field_71451_h;
        double totalOffset = (float)cloudTicks + partialTicks;
        double x = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks + totalOffset * 0.03;
        double y = (double)this.mc.field_71441_e.field_73011_w.func_76571_f() - (entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks) + 0.33;
        double z = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        int scale = this.getScale();
        if (this.cloudMode == 2) {
            z += 0.33 * (double)scale;
        }
        int offU = this.fullCoord(x, scale);
        int offV = this.fullCoord(z, scale);
        GLStateManager.glPushMatrix();
        GLStateManager.glTranslated((double)(offU * scale) - x, y, (double)(offV * scale) - z);
        GLStateManager.glMatrixMode(5890);
        GLStateManager.glTranslated((float)(offU %= this.texW) * 0.00390625f, (float)(offV %= this.texH) * 0.00390625f, 0.0);
        GLStateManager.glMatrixMode(5888);
        GLStateManager.disableCull();
        GLStateManager.enableBlend();
        GLStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        Vec3 color = this.mc.field_71441_e.func_72824_f(partialTicks);
        float r = (float)color.field_72450_a;
        float g = (float)color.field_72448_b;
        float b = (float)color.field_72449_c;
        if (this.mc.field_71474_y.field_74337_g) {
            float tempR = r * 0.3f + g * 0.59f + b * 0.11f;
            float tempG = r * 0.3f + g * 0.7f;
            float tempB = r * 0.3f + b * 0.7f;
            r = tempR;
            g = tempG;
            b = tempB;
        }
        if (this.COLOR_TEX == null) {
            this.COLOR_TEX = new DynamicTexture(1, 1);
        }
        this.COLOR_TEX.func_110565_c()[0] = 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
        this.COLOR_TEX.func_110564_a();
        GLStateManager.glActiveTexture(OpenGlHelper.field_77476_b);
        GLStateManager.glBindTexture(3553, this.COLOR_TEX.func_110552_b());
        GLStateManager.enableTexture();
        GLStateManager.glActiveTexture(OpenGlHelper.field_77478_a);
        this.mc.field_71446_o.func_110577_a(this.texture);
        this.vbo.setupState();
        GLStateManager.glColorMask(false, false, false, false);
        this.vbo.draw();
        if (!this.mc.field_71474_y.field_74337_g) {
            GLStateManager.glColorMask(true, true, true, true);
        } else {
            switch (EntityRenderer.field_78515_b) {
                case 0: {
                    GLStateManager.glColorMask(false, true, true, true);
                    break;
                }
                case 1: {
                    GLStateManager.glColorMask(true, false, false, true);
                }
            }
        }
        this.vbo.draw();
        this.vbo.cleanupState();
        GLStateManager.glActiveTexture(OpenGlHelper.field_77476_b);
        GLStateManager.disableTexture();
        GLStateManager.glActiveTexture(OpenGlHelper.field_77478_a);
        GLStateManager.glMatrixMode(5890);
        GLStateManager.glLoadIdentity();
        GLStateManager.glMatrixMode(5888);
        GLStateManager.disableBlend();
        GLStateManager.enableCull();
        GLStateManager.glPopMatrix();
        return true;
    }

    private void reloadTextures() {
        if (this.mc.field_71446_o != null) {
            this.mc.field_71446_o.func_110577_a(this.texture);
            this.texW = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            this.texH = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.reloadTextures();
    }
}

