/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.mojang;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.angelica.api.QuadView;
import com.gtnewhorizons.angelica.compat.mojang.DefaultVertexFormat;
import com.gtnewhorizons.angelica.compat.mojang.VertexFormatElement;
import com.gtnewhorizons.angelica.compat.nd.IWriteQuads;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.vertices.ImmediateState;
import net.coderbot.iris.vertices.IrisVertexFormats;

public class VertexFormat {
    protected final ImmutableList<VertexFormatElement> elements;
    protected final IntList offsets = new IntArrayList();
    protected final int vertexSize;
    protected IWriteQuads quadWriter;

    public VertexFormat(ImmutableList<VertexFormatElement> elements) {
        this(elements, null);
    }

    public VertexFormat(ImmutableList<VertexFormatElement> elements, IWriteQuads quadWriter) {
        this.elements = elements;
        int i = 0;
        for (VertexFormatElement element : elements) {
            this.offsets.add(i);
            i += element.getByteSize();
        }
        this.vertexSize = i;
        this.quadWriter = quadWriter;
    }

    public void setupBufferState(long l) {
        if (BlockRenderingSettings.INSTANCE.shouldUseExtendedVertexFormat() && ImmediateState.renderWithExtendedVertexFormat) {
            if (this == DefaultVertexFormat.POSITION_COLOR_TEXTURE_LIGHT_NORMAL || this == DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP) {
                IrisVertexFormats.TERRAIN.setupBufferState(l);
                return;
            }
            if (this == DefaultVertexFormat.POSITION_COLOR_TEXTURE_OVERLAY_LIGHT_NORMAL) {
                IrisVertexFormats.ENTITY.setupBufferState(l);
                return;
            }
        }
        int i = this.getVertexSize();
        ImmutableList<VertexFormatElement> list = this.getElements();
        int listSize = list.size();
        for (int j = 0; j < listSize; ++j) {
            ((VertexFormatElement)list.get(j)).setupBufferState(l + (long)this.offsets.getInt(j), i);
        }
    }

    public void clearBufferState() {
        if (BlockRenderingSettings.INSTANCE.shouldUseExtendedVertexFormat() && ImmediateState.renderWithExtendedVertexFormat) {
            if (this == DefaultVertexFormat.POSITION_COLOR_TEXTURE_LIGHT_NORMAL || this == DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP) {
                IrisVertexFormats.TERRAIN.clearBufferState();
                return;
            }
            if (this == DefaultVertexFormat.POSITION_COLOR_TEXTURE_OVERLAY_LIGHT_NORMAL) {
                IrisVertexFormats.ENTITY.clearBufferState();
                return;
            }
        }
        ImmutableList<VertexFormatElement> list = this.getElements();
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            ((VertexFormatElement)list.get(i)).clearBufferState();
        }
    }

    public boolean canWriteQuads() {
        return this.quadWriter != null;
    }

    public void writeQuad(QuadView quad, ByteBuffer byteBuffer) {
        if (this.quadWriter == null) {
            throw new IllegalStateException("No quad writer set");
        }
        this.quadWriter.writeQuad(quad, byteBuffer);
    }

    public ImmutableList<VertexFormatElement> getElements() {
        return this.elements;
    }

    public int getVertexSize() {
        return this.vertexSize;
    }
}

