/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.model.complex;

import com.gtnewhorizons.angelica.client.renderer.CapturingTessellator;
import com.gtnewhorizons.angelica.compat.mojang.DefaultVertexFormat;
import com.gtnewhorizons.angelica.compat.mojang.VertexBuffer;
import com.gtnewhorizons.angelica.compat.mojang.VertexFormat;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.glsm.TessellatorManager;
import com.gtnewhorizons.angelica.glsm.VBOManager;
import glowredman.amazingtrophies.model.complex.BaseModelStructure;
import glowredman.amazingtrophies.model.complex.CustomRenderBlocks;
import glowredman.amazingtrophies.model.complex.RenderHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class RenderHelperAngelica {
    static final VertexFormat format = DefaultVertexFormat.POSITION_TEXTURE_NORMAL;
    private static final float TROPHY_BASE_RATIO = 0.75f;

    private static void centreModel(BaseModelStructure model) {
        String[][] testShape = model.getStructureString();
        int x = testShape.length / 2;
        int z = testShape[0][0].length() / 2;
        GL11.glTranslated((double)(-x), (double)-0.5, (double)(-1 - z));
    }

    private static VertexBuffer rebuildVBO(BaseModelStructure model) {
        CustomRenderBlocks renderBlocks = new CustomRenderBlocks((IBlockAccess)Minecraft.func_71410_x().field_71441_e);
        renderBlocks.field_147863_w = false;
        TessellatorManager.startCapturing();
        CapturingTessellator tessellator = (CapturingTessellator)TessellatorManager.get();
        for (int x = 0; x < model.getXLength(); ++x) {
            for (int y = 0; y < model.getYLength(); ++y) {
                for (int z = 0; z < model.getZLength(); ++z) {
                    Character blockChar = Character.valueOf(model.getStructureString()[x][z].charAt(y));
                    if (blockChar.equals(Character.valueOf(' ')) || model.renderFacesArray[x][z][y].allHidden()) continue;
                    Pair<Block, Integer> blockInfo = model.getAssociatedBlockInfo(blockChar.charValue());
                    renderBlocks.setRenderFacesInfo(model.renderFacesArray[x][z][y]);
                    tessellator.func_78373_b((double)x, (double)(z + 1), (double)(y + 1));
                    RenderHelperAngelica.renderBlock((Block)blockInfo.getLeft(), (Integer)blockInfo.getRight(), renderBlocks);
                }
            }
        }
        tessellator.func_78373_b(0.0, 0.0, 0.0);
        int vboId = VBOManager.generateDisplayLists((int)1);
        VertexBuffer vertexBuffer = TessellatorManager.stopCapturingToVBO((VertexFormat)format);
        VBOManager.registerVBO((int)vboId, (VertexBuffer)vertexBuffer);
        model.vertexBuffer = vertexBuffer;
        return vertexBuffer;
    }

    private static void renderModelInternal(BaseModelStructure model) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        VertexBuffer vertexBuffer = (VertexBuffer)model.vertexBuffer;
        if (model.vertexBuffer == null) {
            vertexBuffer = RenderHelperAngelica.rebuildVBO(model);
        }
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)32826);
        vertexBuffer.render();
    }

    private static void scaleModel(BaseModelStructure model) {
        float maxScale = 0.75f / model.maxAxisSize();
        GL11.glScalef((float)maxScale, (float)maxScale, (float)maxScale);
    }

    public static void renderModel(BaseModelStructure model) {
        if (model == null) {
            return;
        }
        if (!AngelicaConfig.enableVBO) {
            RenderHelper.renderModel(model);
            return;
        }
        GL11.glPushMatrix();
        RenderHelperAngelica.scaleModel(model);
        RenderHelperAngelica.centreModel(model);
        RenderHelperAngelica.renderModelInternal(model);
        GL11.glPopMatrix();
    }

    public static void renderBlock(Block block, int metadata, CustomRenderBlocks renderBlocks) {
        renderBlocks.func_147800_a(block, metadata, 1.0f);
    }
}

